/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.UndeployTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public class UndeployAppMojo
extends BasicSupport {
    protected String appArchive = null;
    protected ArtifactItem appArtifact;
    protected int timeout = 40;

    protected void doExecute() throws Exception {
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        if (this.appArchive != null && this.appArtifact != null) {
            throw new MojoExecutionException(messages.getString("error.app.set.twice"));
        }
        if (this.appArtifact != null) {
            Artifact artifact = this.getArtifact(this.appArtifact);
            this.appArchive = artifact.getFile().getName();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based application", this.appArtifact));
        } else if (this.appArchive != null) {
            File file = new File(this.appArchive);
            if (file.exists()) {
                this.appArchive = file.getName();
            }
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based application", this.appArchive));
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.undeploy.app.set.validate"), ""));
        }
        File destFile = new File(this.serverDirectory, "dropins/" + this.appArchive);
        if (destFile == null || !destFile.exists() || destFile.isDirectory()) {
            throw new IOException(MessageFormat.format(messages.getString("error.undeploy.app.noexist"), destFile.getCanonicalPath()));
        }
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.undeploy.app"), destFile.getCanonicalPath()));
        UndeployTask undeployTask = (UndeployTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:undeploy");
        if (undeployTask == null) {
            throw new NullPointerException("server task not found");
        }
        undeployTask.setInstallDir(this.installDirectory);
        undeployTask.setServerName(this.serverName);
        undeployTask.setUserDir(this.userDirectory);
        undeployTask.setOutputDir(this.outputDirectory);
        undeployTask.setFile(this.appArchive);
        undeployTask.setTimeout(Long.toString(this.timeout * 1000));
        undeployTask.execute();
    }
}

