/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.DeployTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public class DeployAppMojo
extends BasicSupport {
    protected File appArchive = null;
    protected ArtifactItem appArtifact;
    protected int timeout = 40;

    protected void doExecute() throws Exception {
        DeployTask deployTask;
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        if (this.appArchive != null && this.appArtifact != null) {
            throw new MojoExecutionException(messages.getString("error.app.set.twice"));
        }
        if (this.appArtifact != null) {
            Artifact artifact = this.getArtifact(this.appArtifact);
            this.appArchive = artifact.getFile();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based application", this.appArtifact));
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based application", this.appArchive));
        }
        if (this.appArchive == null || !this.appArchive.exists() || this.appArchive.isDirectory()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.deploy.app.set.validate"), ""));
        }
        if (this.appArchive.getName().endsWith("war") || this.appArchive.getName().endsWith("ear") || this.appArchive.getName().endsWith("rar") || this.appArchive.getName().endsWith("eba") || this.appArchive.getName().endsWith("jar") || this.appArchive.getName().endsWith("zip")) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.deploy.app"), this.appArchive.getCanonicalPath()));
            deployTask = (DeployTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:deploy");
            if (deployTask == null) {
                throw new NullPointerException("server task not found");
            }
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.deploy"), ""));
        }
        deployTask.setInstallDir(this.installDirectory);
        deployTask.setServerName(this.serverName);
        deployTask.setUserDir(this.userDirectory);
        deployTask.setOutputDir(this.outputDirectory);
        deployTask.setFile(this.appArchive);
        deployTask.setTimeout(Long.toString(this.timeout * 1000));
        deployTask.execute();
    }
}

