/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.wasdev.wlp.maven.plugins.AbstractLibertySupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.codehaus.plexus.util.FileUtils;

public class BasicSupport
extends AbstractLibertySupport {
    protected static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    protected static final ResourceBundle messages = ResourceBundle.getBundle("net.wasdev.wlp.maven.plugins.MvnMessages");
    protected boolean refresh = false;
    protected boolean isInstall = true;
    protected File assemblyInstallDirectory;
    protected File installDirectory;
    private File serverHome;
    protected String serverName = null;
    protected File userDirectory = null;
    protected File outputDirectory = null;
    protected File serverDirectory;
    protected InstallType installType;
    protected File assemblyArchive;
    protected ArtifactItem assemblyArtifact;

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        if (this.installDirectory == null) {
            this.installDirectory = this.serverHome;
        }
        try {
            if (this.installDirectory != null) {
                this.installDirectory = this.installDirectory.getCanonicalFile();
                File file = new File(this.installDirectory, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.validate"), ""));
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "pre-installed assembly", this.installDirectory));
                this.installType = InstallType.ALREADY_EXISTS;
            } else {
                if (this.assemblyArchive != null && this.assemblyArtifact != null) {
                    throw new MojoExecutionException("Server assembly specified twice: specify only one of maven coordinates in assemblyArtifact or a file in assemblyArchive");
                }
                if (this.assemblyArtifact != null) {
                    Artifact artifact = this.getArtifact(this.assemblyArtifact);
                    this.assemblyArchive = artifact.getFile();
                    this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based assembly archive", this.assemblyArtifact));
                } else {
                    this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based assembly archive", this.assemblyArchive));
                }
                if (this.assemblyArchive == null) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.assembly.validate"), "artifact based assembly archive", ""));
                }
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            }
            if (this.serverName == null) {
                this.serverName = "defaultServer";
            }
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverName", this.serverName));
            if (this.userDirectory == null) {
                this.userDirectory = new File(this.installDirectory, "usr");
            }
            File serversDirectory = new File(this.userDirectory, "servers");
            this.serverDirectory = new File(serversDirectory, this.serverName);
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverDirectory", this.serverDirectory));
            if (this.outputDirectory == null) {
                this.outputDirectory = serversDirectory;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void checkServerHomeExists() throws MojoExecutionException {
        if (!this.installDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.noexist"), this.installDirectory));
        }
    }

    protected void checkServerDirectoryExists() throws MojoExecutionException {
        if (!this.serverDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.noexist"), this.serverName));
        }
    }

    private File checkServerHome(File archive) throws IOException, MojoExecutionException {
        this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.discover.server.home"), ""));
        File dir = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> n = zipFile.entries();
            while (n.hasMoreElements()) {
                ZipEntry entry = n.nextElement();
                if (!entry.getName().endsWith("lib/ws-launch.jar")) continue;
                File file = new File(this.assemblyInstallDirectory, entry.getName());
                dir = file.getParentFile().getParentFile();
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.discover.server.home.fail"), archive), (Exception)e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception e) {}
        }
        if (dir == null) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.archive.not.contain.server"), archive));
        }
        return dir.getCanonicalFile();
    }

    protected void installServerAssembly() throws Exception {
        if (this.installType == InstallType.ALREADY_EXISTS) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            return;
        }
        File installMarker = new File(this.installDirectory, ".installed");
        if (!this.refresh) {
            if (!installMarker.exists()) {
                this.refresh = true;
            } else if (this.assemblyArchive.lastModified() > installMarker.lastModified()) {
                this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.detect.assembly.archive"), ""));
                this.refresh = true;
            }
        } else {
            this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.request.refresh"), ""));
        }
        if (this.refresh && this.installDirectory.exists()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.uninstalling.server.home"), this.installDirectory));
            FileUtils.forceDelete((File)this.installDirectory);
        }
        if (!installMarker.exists()) {
            this.log.info((CharSequence)"Installing assembly...");
            FileUtils.forceMkdir((File)this.installDirectory);
            Expand unzip = (Expand)this.ant.createTask("unzip");
            unzip.setSrc(this.assemblyArchive);
            unzip.setDest(this.assemblyInstallDirectory.getCanonicalFile());
            unzip.execute();
            Chmod chmod = (Chmod)this.ant.createTask("chmod");
            chmod.setPerm("ugo+rx");
            chmod.setDir(this.installDirectory);
            chmod.setIncludes("bin/*");
            chmod.setExcludes("bin/*.bat");
            chmod.execute();
            installMarker.delete();
            installMarker.createNewFile();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.reuse.installed.assembly"), ""));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum InstallType {
        FROM_FILE,
        ALREADY_EXISTS;

    }
}

