/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.ecc;

import net.vrallev.java.ecc.Ecc25519Helper;
import net.vrallev.java.ecc.KeyHolder;
import net.vrallev.java.ecc.fast.Ecc25519HelperFast;
import net.vrallev.java.ecc.fast.KeyHolderFast;
import net.vrallev.java.sqrl.ecc.EccKeyPair;
import net.vrallev.java.sqrl.ecc.EccProvider25519;

public class JavaEccProvider
implements EccProvider25519 {
    private final boolean mFast;
    private final Ecc25519Helper mHelper;

    public JavaEccProvider(boolean fast) {
        this.mFast = fast;
        this.mHelper = fast ? new Ecc25519HelperFast() : new Ecc25519Helper();
    }

    @Override
    public EccKeyPair computeKeyPair(byte[] privateKey) {
        KeyHolderFast keyHolder = this.mFast ? new KeyHolderFast(privateKey) : new KeyHolder(privateKey);
        return new EccKeyPair(keyHolder.getPrivateKey(), keyHolder.getPublicKeySignature(), keyHolder.getPublicKeyDiffieHellman());
    }

    @Override
    public boolean isValidSignature(byte[] message, byte[] signature, byte[] publicKey) {
        return this.mHelper.isValidSignature(message, signature, publicKey);
    }

    @Override
    public byte[] sign(byte[] message, byte[] privateKey, byte[] publicKey) {
        return this.mHelper.sign(message, privateKey, publicKey);
    }

    @Override
    public byte[] diffieHellman(byte[] privateKey, byte[] publicKey) {
        return this.mHelper.diffieHellman(privateKey, publicKey);
    }
}

