/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.ecc;

import net.vrallev.android.ecc.Ecc25519Helper;
import net.vrallev.android.ecc.KeyHolder;
import net.vrallev.java.sqrl.ecc.EccKeyPair;
import net.vrallev.java.sqrl.ecc.EccProvider25519;

public class AndroidEccProvider
implements EccProvider25519 {
    private final Ecc25519Helper mHelper = new Ecc25519Helper();

    @Override
    public EccKeyPair computeKeyPair(byte[] privateKey) {
        KeyHolder keyHolder = new KeyHolder(privateKey);
        return new EccKeyPair(keyHolder.getPrivateKey(), keyHolder.getPublicKeySignature(), keyHolder.getPublicKeyDiffieHellman());
    }

    @Override
    public boolean isValidSignature(byte[] message, byte[] signature, byte[] publicKey) {
        return this.mHelper.isValidSignature(message, signature, publicKey);
    }

    @Override
    public byte[] sign(byte[] message, byte[] privateKey, byte[] publicKey) {
        return this.mHelper.sign(message, privateKey);
    }

    @Override
    public byte[] diffieHellman(byte[] privateKey, byte[] publicKey) {
        return this.mHelper.diffieHellman(privateKey, publicKey);
    }
}

