/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.Map;
import net.vrallev.java.sqrl.SqrlException;
import net.vrallev.java.sqrl.body.ServerParameter;
import net.vrallev.java.sqrl.body.ServerParameterParser;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;
import net.vrallev.java.sqrl.body.SqrlServerBody;

public class SqrlServerBodyParser {
    private Map<String, String> mParameters;

    public SqrlServerBodyParser from(String serverBody) {
        return this.from(SqrlRequestUtil.splitKeyValue(serverBody, "&", "="));
    }

    public SqrlServerBodyParser from(Map<String, String> parameters) {
        this.mParameters = parameters;
        return this;
    }

    public SqrlServerBody parsed() throws SqrlException {
        if (!this.mParameters.containsKey("server")) {
            throw new SqrlException("missing important parameter");
        }
        ServerParameter serverParameter = new ServerParameterParser().parse(this.mParameters.get("server"), true);
        return new SqrlServerBody(serverParameter);
    }
}

