/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.Map;
import net.vrallev.java.sqrl.SqrlException;
import net.vrallev.java.sqrl.body.ClientParameter;
import net.vrallev.java.sqrl.body.ClientParameterParser;
import net.vrallev.java.sqrl.body.ServerParameter;
import net.vrallev.java.sqrl.body.ServerParameterParser;
import net.vrallev.java.sqrl.body.SqrlClientBody;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;
import net.vrallev.java.sqrl.ecc.EccProvider25519;

public class SqrlClientBodyParser {
    private final EccProvider25519 mProvider;
    private Map<String, String> mParameters;
    private byte[] mStoredServerUnlockKey;
    private byte[] mStoredVerifyUnlockKey;

    public SqrlClientBodyParser(EccProvider25519 provider) {
        this.mProvider = provider;
    }

    public SqrlClientBodyParser from(String clientBody) {
        return this.from(SqrlRequestUtil.splitKeyValue(clientBody, "&", "="));
    }

    public SqrlClientBodyParser from(Map<String, String> parameters) {
        this.mParameters = parameters;
        return this;
    }

    public SqrlClientBodyParser withStoredKeys(byte[] serverUnlockKey, byte[] verifyUnlockKey) {
        this.mStoredServerUnlockKey = serverUnlockKey;
        this.mStoredVerifyUnlockKey = verifyUnlockKey;
        return this;
    }

    public SqrlClientBody execute() throws SqrlException {
        return this.parseInternal(false);
    }

    public SqrlClientBody verified() throws SqrlException {
        return this.parseInternal(true);
    }

    private SqrlClientBody parseInternal(boolean checkSignatures) throws SqrlException {
        if (!(this.mParameters.containsKey("client") && this.mParameters.containsKey("server") && this.mParameters.containsKey("ids"))) {
            throw new SqrlException("missing important parameter");
        }
        String clientParameterDecoded = new String(SqrlRequestUtil.decodeBase64(this.mParameters.get("client")), SqrlRequestUtil.ASCII);
        ClientParameter clientParameter = new ClientParameterParser().parse(clientParameterDecoded);
        ServerParameter serverParameter = new ServerParameterParser().parse(this.mParameters.get("server"), true);
        byte[] concatenation = (this.mParameters.get("client") + this.mParameters.get("server")).getBytes(SqrlRequestUtil.ASCII);
        byte[] ids = SqrlRequestUtil.decodeBase64(this.mParameters.get("ids"));
        if (checkSignatures && !this.mProvider.isValidSignature(concatenation, ids, clientParameter.getIdentityKeyDecoded())) {
            throw new SqrlException("signature mismatch");
        }
        byte[] pids = null;
        if (this.mParameters.containsKey("pids")) {
            pids = SqrlRequestUtil.decodeBase64(this.mParameters.get("pids"));
            if (checkSignatures && !this.mProvider.isValidSignature(concatenation, pids, clientParameter.getPreviousIdentityKeyDecoded())) {
                throw new SqrlException("signature mismatch");
            }
        }
        byte[] urs = null;
        if (this.mParameters.containsKey("urs")) {
            urs = SqrlRequestUtil.decodeBase64(this.mParameters.get("urs"));
            if (this.mStoredServerUnlockKey != null && this.mStoredVerifyUnlockKey != null ? checkSignatures && !this.mProvider.isValidSignature(this.mStoredVerifyUnlockKey, urs, this.mStoredVerifyUnlockKey) : checkSignatures && !this.mProvider.isValidSignature(clientParameter.getVerifyUnlockKeyDecoded(), urs, clientParameter.getVerifyUnlockKeyDecoded())) {
                throw new SqrlException("signature mismatch");
            }
        }
        return new SqrlClientBody(clientParameter, serverParameter, ids, pids, urs);
    }
}

