/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.vrallev.java.sqrl.SqrlException;
import net.vrallev.java.sqrl.body.ClientParameter;
import net.vrallev.java.sqrl.body.ServerParameter;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;
import net.vrallev.java.sqrl.body.SqrlServerBody;
import net.vrallev.java.sqrl.ecc.EccKeyPair;
import net.vrallev.java.sqrl.ecc.EccProvider25519;
import net.vrallev.java.sqrl.util.SqrlCipherTool;

public class SqrlClientBody {
    private ClientParameter mClientParameter;
    private ServerParameter mServerParameter;
    private byte[] mIdentitySignature;
    private byte[] mPreviousIdentitySignature;
    private byte[] mUnlockRequestSignature;
    private String mBody;

    public SqrlClientBody(ClientParameter clientParameter, ServerParameter serverParameter, byte[] identitySignature, byte[] previousIdentitySignature, byte[] unlockRequestSignature) {
        this.mClientParameter = clientParameter;
        this.mServerParameter = serverParameter;
        this.mIdentitySignature = identitySignature;
        this.mPreviousIdentitySignature = previousIdentitySignature;
        this.mUnlockRequestSignature = unlockRequestSignature;
        StringBuilder builder = new StringBuilder().append("client=").append(this.mClientParameter.getParameterEncoded()).append("&server=").append(this.mServerParameter.getParameterEncoded()).append("&ids=").append(SqrlRequestUtil.encodeBase64(this.mIdentitySignature));
        if (this.mPreviousIdentitySignature != null) {
            builder.append("&pids=").append(SqrlRequestUtil.encodeBase64(this.mPreviousIdentitySignature));
        }
        if (this.mUnlockRequestSignature != null) {
            builder.append("&urs=").append(SqrlRequestUtil.encodeBase64(this.mUnlockRequestSignature));
        }
        this.mBody = builder.toString();
    }

    public String getBodyEncoded() {
        return this.mBody;
    }

    public ClientParameter getClientParameter() {
        return this.mClientParameter;
    }

    public ServerParameter getServerParameter() {
        return this.mServerParameter;
    }

    public byte[] getIdentitySignatureDecoded() {
        return this.mIdentitySignature;
    }

    public byte[] getPreviousIdentitySignatureDecoded() {
        return this.mPreviousIdentitySignature;
    }

    public byte[] getUnlockRequestSignatureDecoded() {
        return this.mUnlockRequestSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqrlClientBody)) {
            return false;
        }
        SqrlClientBody that = (SqrlClientBody)o;
        if (!this.mBody.equals(that.mBody)) {
            return false;
        }
        if (!this.mClientParameter.equals(that.mClientParameter)) {
            return false;
        }
        if (!Arrays.equals(this.mIdentitySignature, that.mIdentitySignature)) {
            return false;
        }
        if (!Arrays.equals(this.mPreviousIdentitySignature, that.mPreviousIdentitySignature)) {
            return false;
        }
        if (!this.mServerParameter.equals(that.mServerParameter)) {
            return false;
        }
        return Arrays.equals(this.mUnlockRequestSignature, that.mUnlockRequestSignature);
    }

    public int hashCode() {
        int result = this.mClientParameter.hashCode();
        result = 31 * result + this.mServerParameter.hashCode();
        result = 31 * result + Arrays.hashCode(this.mIdentitySignature);
        result = 31 * result + (this.mPreviousIdentitySignature != null ? Arrays.hashCode(this.mPreviousIdentitySignature) : 0);
        result = 31 * result + (this.mUnlockRequestSignature != null ? Arrays.hashCode(this.mUnlockRequestSignature) : 0);
        result = 31 * result + this.mBody.hashCode();
        return result;
    }

    public static class Builder {
        private final SqrlCipherTool mCipherTool;
        private final EccProvider25519 mEccProvider;
        private final byte[] mMasterKey;
        private final String mSiteKey;
        private String mVersion;
        private ServerParameter mServerParameter;
        private String mSignatureUri;
        private final List<String> mCommands;
        private byte[] mIdentityUnlockKey;
        private byte[] mPreviousMasterKey;
        private byte[] mPreviousServerUnlockKey;
        private byte[] mPreviousVerifyUnlockKey;
        private byte[] mNewServerUnlockKey;
        private byte[] mNewVerifyUnlockKey;

        public Builder(SqrlCipherTool sqrlCipherTool, EccProvider25519 eccProvider, byte[] masterKey, String siteKey) {
            this.mCipherTool = sqrlCipherTool;
            this.mEccProvider = eccProvider;
            this.mMasterKey = masterKey;
            this.mSiteKey = siteKey;
            this.mCommands = new ArrayList<String>();
            this.mVersion = "1";
        }

        public Builder withVersion(String version) {
            this.mVersion = version;
            return this;
        }

        public Builder addCommand(String command) {
            this.mCommands.add(command);
            return this;
        }

        public Builder withIdentityUnlockKey(byte[] identityUnlockKey) {
            this.mIdentityUnlockKey = identityUnlockKey;
            return this;
        }

        public Builder withPreviousMasterKey(byte[] previousMasterKey) {
            this.mPreviousMasterKey = previousMasterKey;
            return this;
        }

        public Builder withPreviousServerKeys(byte[] serverUnlockKey, byte[] verifyUnlockKey) {
            this.mPreviousServerUnlockKey = serverUnlockKey;
            this.mPreviousVerifyUnlockKey = verifyUnlockKey;
            return this;
        }

        public Builder withNewServerKeys(byte[] serverUnlockKey, byte[] verifyUnlockKey) {
            this.mNewServerUnlockKey = serverUnlockKey;
            this.mNewVerifyUnlockKey = verifyUnlockKey;
            return this;
        }

        public SqrlClientBody buildRequest(String signatureUri) throws SqrlException {
            if (signatureUri == null) {
                throw new IllegalArgumentException("no null value allowed");
            }
            this.mSignatureUri = signatureUri;
            return this.build();
        }

        public SqrlClientBody buildResponse(SqrlServerBody serverBody) throws SqrlException {
            return this.buildResponse(serverBody.getServerParameter());
        }

        public SqrlClientBody buildResponse(ServerParameter serverParameter) throws SqrlException {
            if (serverParameter == null) {
                throw new IllegalArgumentException("no null value allowed");
            }
            this.mServerParameter = serverParameter;
            return this.build();
        }

        private SqrlClientBody build() throws SqrlException {
            byte[] unlockRequestSignature;
            byte[] privateSiteKey = this.mCipherTool.computeHmac(this.mSiteKey.getBytes(SqrlRequestUtil.UTF8), this.mMasterKey);
            EccKeyPair identityKeyPair = this.mEccProvider.computeKeyPair(privateSiteKey);
            byte[] identityKey = identityKeyPair.getPublicKeySignature();
            EccKeyPair previousKeyPair = null;
            byte[] previousIdentityKey = null;
            if (this.mPreviousMasterKey != null) {
                byte[] previousPrivateSiteKey = this.mCipherTool.computeHmac(this.mSiteKey.getBytes(SqrlRequestUtil.UTF8), this.mPreviousMasterKey);
                previousKeyPair = this.mEccProvider.computeKeyPair(previousPrivateSiteKey);
                previousIdentityKey = previousKeyPair.getPublicKeySignature();
            }
            if (this.mCommands.isEmpty()) {
                this.mCommands.add("login");
            }
            if (this.mCommands.contains("create")) {
                this.mCommands.add("setkey");
                this.mCommands.add("setlock");
            }
            ClientParameter clientParameter = new ClientParameter.Builder(this.mCommands, identityKey).withVersion(this.mVersion).setPreviousIdentityKey(previousIdentityKey).setServerUnlockKey(this.mNewServerUnlockKey).setVerifyUnlockKey(this.mNewVerifyUnlockKey).build();
            ServerParameter serverParameter = this.mServerParameter != null ? this.mServerParameter : new ServerParameter(this.mSignatureUri);
            byte[] concatenation = (clientParameter.getParameterEncoded() + serverParameter.getParameterEncoded()).getBytes(SqrlRequestUtil.ASCII);
            byte[] identitySignature = this.mEccProvider.sign(concatenation, identityKeyPair.getPrivateKey(), identityKeyPair.getPublicKeySignature());
            byte[] previousIdentitySignature = clientParameter.getPreviousIdentityKeyDecoded() != null && previousKeyPair != null ? this.mEccProvider.sign(concatenation, previousKeyPair.getPrivateKey(), previousKeyPair.getPublicKeySignature()) : null;
            if (this.mIdentityUnlockKey != null) {
                byte[] unlockRequestSigningKey = this.mEccProvider.diffieHellman(this.mIdentityUnlockKey, this.mPreviousServerUnlockKey);
                EccKeyPair ursKeyPair = this.mEccProvider.computeKeyPair(unlockRequestSigningKey);
                byte[] verifyUnlockKey = ursKeyPair.getPublicKeySignature();
                if (verifyUnlockKey == null || !Arrays.equals(verifyUnlockKey, this.mPreviousVerifyUnlockKey)) {
                    throw new SqrlException("Verify unlock key didn't match");
                }
                unlockRequestSignature = this.mEccProvider.sign(verifyUnlockKey, ursKeyPair.getPrivateKey(), ursKeyPair.getPublicKeySignature());
            } else {
                unlockRequestSignature = null;
            }
            return new SqrlClientBody(clientParameter, serverParameter, identitySignature, previousIdentitySignature, unlockRequestSignature);
        }
    }
}

