/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import net.vrallev.java.sqrl.body.GenericParameterHolder;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;
import net.vrallev.java.sqrl.body.SqrlServerBody;

public class ServerParameter {
    public static final int ID_MATCH = 1;
    public static final int PREVIOUS_ID_MATCH = 2;
    public static final int IP_MATCH = 4;
    public static final int SQRL_ENABLED = 8;
    public static final int USER_LOGGED_IN = 16;
    public static final int SQRL_ACCOUNT_CREATION_ALLOWED = 32;
    public static final int COMMAND_FAILED = 64;
    public static final int SQRL_FAILURE = 128;
    private final boolean mIsUri;
    private final String mEncodedUri;
    private final GenericParameterHolder mParameterHolder;
    private final String mDecodedFromServer;

    public ServerParameter(String uriSignaturePart) {
        byte[] subUri = uriSignaturePart.getBytes(SqrlRequestUtil.UTF8);
        this.mEncodedUri = SqrlRequestUtil.encodeBase64(subUri);
        this.mParameterHolder = null;
        this.mDecodedFromServer = null;
        this.mIsUri = true;
    }

    private ServerParameter(GenericParameterHolder parameterHolder, String decodedFromServer) {
        this.mParameterHolder = parameterHolder;
        this.mDecodedFromServer = decodedFromServer;
        this.mEncodedUri = null;
        this.mIsUri = false;
    }

    public String getParameterEncoded() {
        if (this.mIsUri) {
            return this.mEncodedUri;
        }
        if (this.mDecodedFromServer != null) {
            return SqrlRequestUtil.encodeBase64(this.mDecodedFromServer.getBytes(SqrlRequestUtil.ASCII));
        }
        return this.mParameterHolder.getEncoded();
    }

    public byte[] getParameterDecoded() {
        if (this.mIsUri) {
            return SqrlRequestUtil.decodeBase64(this.mEncodedUri);
        }
        if (this.mDecodedFromServer != null) {
            return this.mDecodedFromServer.getBytes(SqrlRequestUtil.ASCII);
        }
        return this.mParameterHolder.getDecoded();
    }

    public String getVersionDecoded() {
        return this.mIsUri ? null : this.mParameterHolder.getPlainParameter("ver");
    }

    public String getNutDecoded() {
        if (this.mIsUri) {
            int nutBegin;
            String string = new String(this.getParameterDecoded(), SqrlRequestUtil.ASCII);
            int nutEnd = string.indexOf("&", nutBegin = string.indexOf("nut=") + "nut=".length());
            if (nutEnd == -1) {
                nutEnd = string.length();
            }
            return string.substring(nutBegin, nutEnd);
        }
        return new String(SqrlRequestUtil.decodeBase64(this.mParameterHolder.getPlainParameter("nut")), SqrlRequestUtil.UTF8);
    }

    public int getTransactionInformationFlag() {
        return this.mIsUri ? -1 : Integer.parseInt(this.mParameterHolder.getPlainParameter("tif"));
    }

    public boolean hasTransactionFlag(int flag) {
        return (this.getTransactionInformationFlag() & flag) == flag;
    }

    public String getServerFriendlyNameDecoded() {
        return this.mIsUri ? null : this.mParameterHolder.getPlainParameter("sfn");
    }

    public byte[] getServerUnlockKeyDecoded() {
        return this.mIsUri ? null : this.mParameterHolder.getDecodedParameter("suk");
    }

    public byte[] getVerifyUnlockKeyDecoded() {
        return this.mIsUri ? null : this.mParameterHolder.getDecodedParameter("vuk");
    }

    public boolean isUri() {
        return this.mIsUri;
    }

    public SqrlServerBody asSqrlServerBody() {
        return new SqrlServerBody(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerParameter)) {
            return false;
        }
        ServerParameter that = (ServerParameter)o;
        if (this.mIsUri != that.mIsUri) {
            return false;
        }
        if (this.mEncodedUri != null ? !this.mEncodedUri.equals(that.mEncodedUri) : that.mEncodedUri != null) {
            return false;
        }
        return !(this.mParameterHolder != null ? !this.mParameterHolder.equals(that.mParameterHolder) : that.mParameterHolder != null);
    }

    public int hashCode() {
        int result = this.mIsUri ? 1 : 0;
        result = 31 * result + (this.mEncodedUri != null ? this.mEncodedUri.hashCode() : 0);
        result = 31 * result + (this.mParameterHolder != null ? this.mParameterHolder.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private final GenericParameterHolder mParameterHolder;
        private final String mDecodedParameter;

        public Builder(String nut, int tif) {
            this(nut, tif, null);
        }

        public Builder(String nut, int tif, String decodedParameter) {
            if (nut == null || nut.isEmpty()) {
                throw new IllegalArgumentException("nut can't be null or empty");
            }
            this.mParameterHolder = new GenericParameterHolder();
            this.mParameterHolder.putPlainParameter("nut", SqrlRequestUtil.encodeBase64(nut.getBytes(SqrlRequestUtil.UTF8)));
            this.mParameterHolder.putPlainParameter("tif", String.valueOf(tif));
            this.mDecodedParameter = decodedParameter;
            this.withVersion("1");
        }

        public Builder withVersion(String version) {
            this.mParameterHolder.putPlainParameter("ver", version);
            return this;
        }

        public Builder withServerFriendlyName(String serverFriendlyName) {
            this.mParameterHolder.putPlainParameter("sfn", serverFriendlyName);
            return this;
        }

        public Builder withStoredKeys(byte[] serverUnlockKey, byte[] verifyUnlockKey) {
            this.mParameterHolder.putEncodedParameter("suk", serverUnlockKey);
            this.mParameterHolder.putEncodedParameter("vuk", verifyUnlockKey);
            return this;
        }

        public ServerParameter create() {
            if (!this.mParameterHolder.containsKey("ver")) {
                this.mParameterHolder.putPlainParameter("ver", "1");
            }
            return new ServerParameter(this.mParameterHolder, this.mDecodedParameter);
        }

        private void checkKey(byte[] key) {
            if (key != null && key.length != 32) {
                throw new IllegalArgumentException("illegal key length");
            }
        }
    }
}

