/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.vrallev.java.sqrl.SqrlException;
import net.vrallev.java.sqrl.body.ClientParameter;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;

class ClientParameterParser {
    ClientParameterParser() {
    }

    public ClientParameter parse(String parameter) throws SqrlException {
        Map<String, String> map = SqrlRequestUtil.splitKeyValue(parameter, "\r\n", "=");
        if (!map.containsKey("ver") || !"1".equals(map.get("ver"))) {
            throw new SqrlException("Wrong version");
        }
        if (!map.containsKey("cmd") || !map.containsKey("idk")) {
            throw new SqrlException("missing important parameter");
        }
        String commandList = map.get("cmd");
        List<String> commands = Arrays.asList(commandList.split("~"));
        byte[] identityKey = SqrlRequestUtil.decodeBase64(map.get("idk"));
        ClientParameter.Builder builder = new ClientParameter.Builder(commands, identityKey);
        if (map.containsKey("pidk")) {
            builder.setPreviousIdentityKey(SqrlRequestUtil.decodeBase64(map.get("pidk")));
        }
        if (map.containsKey("suk")) {
            builder.setServerUnlockKey(SqrlRequestUtil.decodeBase64(map.get("suk")));
        }
        if (map.containsKey("vuk")) {
            builder.setVerifyUnlockKey(SqrlRequestUtil.decodeBase64(map.get("vuk")));
        }
        return builder.build();
    }
}

