/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl;

import net.vrallev.java.sqrl.body.ServerParameter;
import net.vrallev.java.sqrl.body.SqrlClientBody;
import net.vrallev.java.sqrl.body.SqrlClientBodyParser;
import net.vrallev.java.sqrl.body.SqrlServerBody;
import net.vrallev.java.sqrl.body.SqrlServerBodyParser;
import net.vrallev.java.sqrl.ecc.AndroidEccProvider;
import net.vrallev.java.sqrl.ecc.EccProvider25519;
import net.vrallev.java.sqrl.ecc.JavaEccProvider;
import net.vrallev.java.sqrl.util.SqrlCipherTool;

public final class SqrlProtocol {
    private static SqrlProtocol instance;
    private final EccProvider25519 mEccProvider;
    private final SqrlCipherTool mSqrlCipherTool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqrlProtocol instance() {
        if (instance != null) return instance;
        Class<SqrlProtocol> clazz = SqrlProtocol.class;
        synchronized (SqrlProtocol.class) {
            if (instance != null) return instance;
            instance = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void instance(SqrlProtocol instance) {
        SqrlProtocol.instance = instance;
    }

    private SqrlProtocol(EccProvider25519 eccProvider, SqrlCipherTool sqrlCipherTool) {
        if (eccProvider == null) {
            throw new IllegalArgumentException("you must provide an EccProvider25519");
        }
        this.mEccProvider = eccProvider;
        this.mSqrlCipherTool = sqrlCipherTool;
    }

    public EccProvider25519 getEccProvider() {
        return this.mEccProvider;
    }

    public SqrlCipherTool getSqrlCipherTool() {
        return this.mSqrlCipherTool;
    }

    public SqrlClientBody.Builder authenticate(byte[] masterKey, String siteKey) {
        return new SqrlClientBody.Builder(this.mSqrlCipherTool, this.mEccProvider, masterKey, siteKey);
    }

    public SqrlClientBody.Builder answerServer(byte[] masterKey, String siteKey, SqrlServerBody serverBody) {
        byte[] suk = serverBody.getServerParameter().getServerUnlockKeyDecoded();
        byte[] vuk = serverBody.getServerParameter().getVerifyUnlockKeyDecoded();
        return new SqrlClientBody.Builder(this.mSqrlCipherTool, this.mEccProvider, masterKey, siteKey).withPreviousServerKeys(suk, vuk);
    }

    public SqrlClientBodyParser readSqrlClientBody() {
        return new SqrlClientBodyParser(this.mEccProvider);
    }

    public ServerParameter.Builder answerClient(SqrlClientBody clientBody, int tif) {
        String nut = clientBody.getServerParameter().getNutDecoded();
        return new ServerParameter.Builder(nut, tif);
    }

    public ServerParameter.Builder answerClient(SqrlClientBody clientBody, int ... tifs) {
        int tif = 0;
        for (int flag : tifs) {
            tif |= flag;
        }
        return this.answerClient(clientBody, tif);
    }

    public SqrlServerBodyParser readSqrlServerBody() {
        return new SqrlServerBodyParser();
    }

    private static EccProvider25519 tryToFindProvider() {
        try {
            Class.forName("net.vrallev.java.ecc.Ecc25519Helper");
            return new JavaEccProvider(true);
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("net.vrallev.android.ecc.Ecc25519Helper");
                return new AndroidEccProvider();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static class Builder {
        private EccProvider25519 mEccProvider;
        private SqrlCipherTool mSqrlCipherTool;

        public Builder setEccProvider(EccProvider25519 eccProvider) {
            this.mEccProvider = eccProvider;
            return this;
        }

        public Builder setSqrlCipherTool(SqrlCipherTool sqrlCipherTool) {
            this.mSqrlCipherTool = sqrlCipherTool;
            return this;
        }

        public SqrlProtocol build() {
            if (this.mEccProvider == null) {
                this.mEccProvider = SqrlProtocol.tryToFindProvider();
            }
            if (this.mSqrlCipherTool == null) {
                this.mSqrlCipherTool = new SqrlCipherTool();
            }
            return new SqrlProtocol(this.mEccProvider, this.mSqrlCipherTool);
        }
    }
}

