/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.util;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.modes.GCMBlockCipher;
import org.spongycastle.crypto.params.AEADParameters;
import org.spongycastle.crypto.params.KeyParameter;

public class SqrlCipherTool {
    private static final String MAC_ALGO = "HmacSHA256";
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final SecureRandom mRandom = new SecureRandom();
    private final Mac mHMacSha256;
    private final GCMBlockCipher mAesGcmEngine;
    protected MessageDigest mMessageDigest;
    protected Charset mCharset;

    public SqrlCipherTool() {
        this(DEFAULT_HASH_ALGORITHM, UTF_8);
    }

    public SqrlCipherTool(String algorithm, Charset charset) {
        this.mCharset = charset;
        this.mAesGcmEngine = new GCMBlockCipher((BlockCipher)new AESFastEngine());
        try {
            this.mHMacSha256 = Mac.getInstance(MAC_ALGO);
            this.mMessageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] getHash(String clearText) {
        return this.getHash(clearText, 1);
    }

    public byte[] getHash(byte[] data) {
        return this.getHash(data, 1);
    }

    public String getHashString(String clearText) {
        return this.getHashString(clearText.getBytes(this.mCharset));
    }

    public String getHashString(byte[] data) {
        return this.getHashString(data, 1);
    }

    public String getHashString(String clearText, int iterations) {
        return this.getHashString(clearText.getBytes(this.mCharset), iterations);
    }

    public String getHashString(byte[] data, int iterations) {
        return SqrlCipherTool.bin2hex(this.getHash(data, iterations));
    }

    public byte[] getHash(String clearText, int iterations) {
        return this.getHash(clearText.getBytes(this.mCharset), iterations);
    }

    public byte[] getHash(byte[] data, int iterations) {
        iterations = Math.max(1, iterations);
        for (int i = 0; i < iterations; ++i) {
            data = this.mMessageDigest.digest(data);
        }
        return data;
    }

    public byte[] createRandomHash(int lengthBit) {
        byte[] bytes = new byte[128];
        this.mRandom.nextBytes(bytes);
        byte[] hash = this.getHash(bytes);
        return Arrays.copyOf(hash, lengthBit / 8);
    }

    public String createRescueCode() {
        StringBuilder builder = new StringBuilder(24);
        for (int i = 0; i < 24; ++i) {
            builder.append(this.mRandom.nextInt(10));
        }
        return builder.toString();
    }

    public byte[] computeHmac(byte[] data, String password) {
        return this.computeHmac(data, password.getBytes(this.mCharset));
    }

    public byte[] computeHmac(byte[] data, byte[] password) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(password, MAC_ALGO);
            this.mHMacSha256.init(secretKeySpec);
            return this.mHMacSha256.doFinal(data);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] getHashChained(byte[] data, int rounds) {
        byte[] hash = this.getHash(data);
        if (rounds == 1) {
            return hash;
        }
        byte[] xor = hash;
        for (int i = 1; i < rounds; ++i) {
            hash = this.getHash(hash);
            xor = SqrlCipherTool.xor(xor, hash);
        }
        return xor;
    }

    public AesGcmResult aesGcmEncrypt(byte[] plainText, byte[] key) {
        return this.aesGcmEncrypt(plainText, key, new byte[12], null);
    }

    public AesGcmResult aesGcmEncrypt(byte[] plainText, byte[] key, byte[] iv, byte[] aad) {
        AEADParameters parameters = new AEADParameters(new KeyParameter(key), 128, iv, aad);
        this.mAesGcmEngine.init(true, (CipherParameters)parameters);
        byte[] encMsg = new byte[this.mAesGcmEngine.getOutputSize(plainText.length)];
        int encLen = this.mAesGcmEngine.processBytes(plainText, 0, plainText.length, encMsg, 0);
        try {
            this.mAesGcmEngine.doFinal(encMsg, encLen);
            byte[] tag = this.mAesGcmEngine.getMac();
            encMsg = Arrays.copyOf(encMsg, encMsg.length - tag.length);
            return new AesGcmResult(encMsg, tag);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] aesGcmDecrypt(AesGcmResult result, byte[] key) {
        return this.aesGcmDecrypt(result.getEncryptedMessage(), result.getTag(), key);
    }

    public byte[] aesGcmDecrypt(byte[] cipherText, byte[] tag, byte[] key) {
        return this.aesGcmDecrypt(cipherText, tag, key, new byte[12], null);
    }

    public byte[] aesGcmDecrypt(byte[] cipherText, byte[] tag, byte[] key, byte[] iv, byte[] aad) {
        AEADParameters parameters = new AEADParameters(new KeyParameter(key), 128, iv, aad);
        this.mAesGcmEngine.init(false, (CipherParameters)parameters);
        byte[] text = Arrays.copyOf(cipherText, cipherText.length + tag.length);
        System.arraycopy(tag, 0, text, cipherText.length, tag.length);
        byte[] decMsg = new byte[this.mAesGcmEngine.getOutputSize(text.length)];
        int decLen = this.mAesGcmEngine.processBytes(text, 0, text.length, decMsg, 0);
        try {
            this.mAesGcmEngine.doFinal(decMsg, decLen);
            return decMsg;
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String bin2hex(byte[] data) {
        return String.format("%0" + data.length * 2 + 'x', new BigInteger(1, data));
    }

    private static byte[] xor(byte[] array1, byte[] array2) {
        if (array1 == null || array2 == null || array1.length != array2.length) {
            throw new IllegalArgumentException("arrays must have the same length");
        }
        byte[] result = new byte[array1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(array1[i] ^ array2[i]);
        }
        return result;
    }

    public static class AesGcmResult {
        private final byte[] mEncryptedMessage;
        private final byte[] mTag;

        public AesGcmResult(byte[] encryptedMessage, byte[] tag) {
            this.mEncryptedMessage = encryptedMessage;
            this.mTag = tag;
        }

        public byte[] getEncryptedMessage() {
            return this.mEncryptedMessage;
        }

        public byte[] getTag() {
            return this.mTag;
        }
    }
}

