/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import android.util.changed.Base64;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class SqrlRequestUtil {
    public static final String LINE_SEPARATOR = "\r\n";
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private SqrlRequestUtil() {
    }

    public static String encodeBase64(byte[] data) {
        return Base64.encodeToString(data, 11);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode(data, 11);
    }

    public static Map<String, String> splitKeyValue(String string, String listSeparator, String entrySeparator) throws IllegalArgumentException {
        String[] split = string.split(listSeparator);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String value : split) {
            String[] keyValue = value.split(entrySeparator);
            if (keyValue.length < 2) {
                throw new IllegalArgumentException("unexpected size");
            }
            if (keyValue.length > 2) {
                map.put(keyValue[0], SqrlRequestUtil.concat(Arrays.copyOfRange(keyValue, 1, keyValue.length), entrySeparator));
                continue;
            }
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    private static String concat(String[] array, String delimiter) {
        StringBuilder builder = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(delimiter).append(array[i]);
        }
        return builder.toString();
    }
}

