/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.Map;
import net.vrallev.java.sqrl.SqrlException;
import net.vrallev.java.sqrl.body.ServerParameter;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;

class ServerParameterParser {
    ServerParameterParser() {
    }

    public ServerParameter parse(String parameter, boolean encoded) throws SqrlException {
        if (encoded) {
            parameter = new String(SqrlRequestUtil.decodeBase64(parameter), SqrlRequestUtil.ASCII);
        }
        if (!parameter.startsWith("ver=")) {
            return new ServerParameter(parameter);
        }
        Map<String, String> map = SqrlRequestUtil.splitKeyValue(parameter, "\r\n", "=");
        if (!(map.containsKey("ver") && map.containsKey("nut") && map.containsKey("tif"))) {
            throw new SqrlException("missing important parameter");
        }
        String version = map.remove("ver");
        if (!"1".equals(version)) {
            throw new SqrlException("wrong version");
        }
        String nut = new String(SqrlRequestUtil.decodeBase64(map.remove("nut")), SqrlRequestUtil.UTF8);
        int tif = Integer.parseInt(map.remove("tif"));
        String serverFriendlyName = map.remove("sfn");
        byte[] serverUnlockKey = null;
        if (map.containsKey("suk")) {
            serverUnlockKey = SqrlRequestUtil.decodeBase64(map.remove("suk"));
        }
        byte[] verifyUnlockKey = null;
        if (map.containsKey("vuk")) {
            verifyUnlockKey = SqrlRequestUtil.decodeBase64(map.remove("vuk"));
        }
        return new ServerParameter.Builder(nut, tif, parameter).withVersion(version).withServerFriendlyName(serverFriendlyName).withStoredKeys(serverUnlockKey, verifyUnlockKey).create();
    }
}

