/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.HashMap;
import java.util.Map;
import net.vrallev.java.sqrl.body.SqrlRequestUtil;

class GenericParameterHolder {
    public static final String KEY_CMD = "cmd";
    public static final String KEY_SUK = "suk";
    public static final String KEY_VUK = "vuk";
    public static final String KEY_VER = "ver";
    public static final String KEY_IDK = "idk";
    public static final String KEY_PIDK = "pidk";
    public static final String KEY_NUT = "nut";
    public static final String KEY_TIF = "tif";
    public static final String KEY_SFN = "sfn";
    private final Map<String, String> mMap = new HashMap<String, String>();

    GenericParameterHolder() {
    }

    public GenericParameterHolder putPlainParameter(String key, String value) {
        this.mMap.put(key, value);
        return this;
    }

    public GenericParameterHolder putEncodedParameter(String key, byte[] value) {
        if (key != null && value != null) {
            this.putPlainParameter(key, SqrlRequestUtil.encodeBase64(value));
        }
        return this;
    }

    public String getPlainParameter(String key) {
        return this.mMap.get(key);
    }

    public byte[] getDecodedParameter(String key) {
        if (this.containsKey(key)) {
            return SqrlRequestUtil.decodeBase64(this.getPlainParameter(key));
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.mMap.containsKey(key);
    }

    public byte[] getDecoded() {
        StringBuilder builder = new StringBuilder();
        if (this.containsKey(KEY_VER)) {
            builder.append(KEY_VER).append('=').append(this.getPlainParameter(KEY_VER)).append("\r\n");
        }
        for (String key : this.mMap.keySet()) {
            if (key.equals(KEY_VER)) continue;
            builder.append(key).append('=').append(this.getPlainParameter(key)).append("\r\n");
        }
        return builder.toString().getBytes(SqrlRequestUtil.ASCII);
    }

    public String getEncoded() {
        return SqrlRequestUtil.encodeBase64(this.getDecoded());
    }

    public String toString() {
        return new String(this.getDecoded(), SqrlRequestUtil.ASCII);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericParameterHolder)) {
            return false;
        }
        GenericParameterHolder that = (GenericParameterHolder)o;
        if (this.mMap.size() != that.mMap.size()) {
            return false;
        }
        for (String key : this.mMap.keySet()) {
            if (!that.mMap.containsKey(key)) {
                return false;
            }
            if (this.mMap.get(key).equals(that.mMap.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }
}

