/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.sqrl.body;

import java.util.Arrays;
import java.util.List;
import net.vrallev.java.sqrl.body.GenericParameterHolder;

public class ClientParameter {
    private final GenericParameterHolder mParameterHolder;

    private ClientParameter(GenericParameterHolder parameterHolder) {
        this.mParameterHolder = parameterHolder;
    }

    public String getParameterEncoded() {
        return this.mParameterHolder.getEncoded();
    }

    public byte[] getParameterDecoded() {
        return this.mParameterHolder.getDecoded();
    }

    public List<String> getCommands() {
        String commands = this.mParameterHolder.getPlainParameter("cmd");
        if (commands == null) {
            return null;
        }
        return Arrays.asList(commands.split("~"));
    }

    public byte[] getIdentityKeyDecoded() {
        return this.mParameterHolder.getDecodedParameter("idk");
    }

    public byte[] getPreviousIdentityKeyDecoded() {
        return this.mParameterHolder.getDecodedParameter("pidk");
    }

    public byte[] getServerUnlockKeyDecoded() {
        return this.mParameterHolder.getDecodedParameter("suk");
    }

    public byte[] getVerifyUnlockKeyDecoded() {
        return this.mParameterHolder.getDecodedParameter("vuk");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientParameter)) {
            return false;
        }
        ClientParameter that = (ClientParameter)o;
        return this.mParameterHolder.equals(that.mParameterHolder);
    }

    public int hashCode() {
        return this.mParameterHolder.hashCode();
    }

    static String getCommandsAsString(List<String> commands) {
        StringBuilder builder = new StringBuilder();
        for (String command : commands) {
            if (builder.length() != 0) {
                builder.append('~');
            }
            builder.append(command);
        }
        return builder.toString();
    }

    public static class Builder {
        private final GenericParameterHolder mParameterHolder;

        public Builder(List<String> commands, byte[] identityKey) {
            if (commands == null || commands.isEmpty() || identityKey == null) {
                throw new IllegalArgumentException("command and identityKey can't be null");
            }
            this.checkKey(identityKey);
            this.mParameterHolder = new GenericParameterHolder();
            this.mParameterHolder.putPlainParameter("cmd", ClientParameter.getCommandsAsString(commands));
            this.mParameterHolder.putEncodedParameter("idk", identityKey);
            this.withVersion("1");
        }

        public Builder withVersion(String version) {
            this.mParameterHolder.putPlainParameter("ver", version);
            return this;
        }

        public Builder setPreviousIdentityKey(byte[] previousIdentityKey) {
            this.mParameterHolder.putEncodedParameter("pidk", previousIdentityKey);
            return this;
        }

        public Builder setServerUnlockKey(byte[] serverUnlockKey) {
            this.mParameterHolder.putEncodedParameter("suk", serverUnlockKey);
            return this;
        }

        public Builder setVerifyUnlockKey(byte[] verifyUnlockKey) {
            this.mParameterHolder.putEncodedParameter("vuk", verifyUnlockKey);
            return this;
        }

        public ClientParameter build() {
            if (!this.mParameterHolder.containsKey("ver")) {
                this.mParameterHolder.putPlainParameter("ver", "1");
            }
            return new ClientParameter(this.mParameterHolder);
        }

        private void checkKey(byte[] key) {
            if (key != null && key.length != 32) {
                throw new IllegalArgumentException("illegal key length");
            }
        }
    }
}

