/*
 * Decompiled with CFR 0.152.
 */
package net.vleo.timel.variable;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentNavigableMap;
import net.vleo.timel.executor.ExecutorContext;
import net.vleo.timel.executor.Sample;
import net.vleo.timel.executor.variable.Variable;
import net.vleo.timel.iterator.AdapterTimeIterator;
import net.vleo.timel.iterator.TimeIterator;
import net.vleo.timel.time.Interval;
import net.vleo.timel.time.IntervalMaps;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapDbVariable<V>
implements Variable<V> {
    private final DB db;
    private final ConcurrentNavigableMap<Interval, Payload<V>> values;

    private static DB getDefaultDb() {
        File dbFile;
        try {
            dbFile = File.createTempFile("timel-variable", ".tmp");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return DBMaker.fileDB((File)dbFile).transactionDisable().fileMmapEnableIfSupported().closeOnJvmShutdown().asyncWriteEnable().asyncWriteFlushDelay(5000).cacheLRUEnable().cacheSize(32768).make();
    }

    public MapDbVariable() {
        this(MapDbVariable.getDefaultDb(), "variable");
    }

    public MapDbVariable(DB db, String name) {
        this.db = db;
        this.values = db.createTreeMap(name).comparator(IntervalMaps.getIntervalEndComparator()).make();
    }

    public DB getDb() {
        return this.db;
    }

    public TimeIterator<V> readForward(Interval interval, ExecutorContext context) {
        return new AdapterTimeIterator<Payload<V>, V>(IntervalMaps.supremum(this.values, (Interval)interval)){

            protected Sample<V> adapt(Sample<Payload<V>> sample) {
                return sample.copyWithValue(((Payload)sample.getValue()).getPayload());
            }
        };
    }

    public TimeIterator<V> readBackward(Interval interval, ExecutorContext context) {
        return new AdapterTimeIterator<Payload<V>, V>(IntervalMaps.supremumBackward(this.values, (Interval)interval)){

            protected Sample<V> adapt(Sample<Payload<V>> sample) {
                return sample.copyWithValue(((Payload)sample.getValue()).getPayload());
            }
        };
    }

    public void write(Sample<V> sample) {
        this.values.put(sample.getInterval(), Payload.of(sample.getValue()));
    }

    private static class Payload<T>
    implements Serializable {
        private final T payload;

        public T getPayload() {
            return this.payload;
        }

        private Payload(T payload) {
            this.payload = payload;
        }

        public static <V> Payload<V> of(V value) {
            return new Payload<V>(value);
        }
    }
}

