/*
 * Decompiled with CFR 0.152.
 */
package net.videki.semver.cc.release.common;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.videki.semver.cc.release.common.Commit;
import net.videki.semver.cc.release.common.ConventionalCommitType;
import net.videki.semver.cc.release.common.GitCommitAdapter;
import net.videki.semver.cc.release.common.SemanticVersionChange;
import net.videki.semver.cc.release.common.SemanticVersionChangeResolver;
import org.eclipse.jgit.revwalk.RevCommit;

public class SimpleSemanticVersionChangeResolver
implements SemanticVersionChangeResolver {
    @Override
    public SemanticVersionChange resolveChange(Iterable<RevCommit> commits) {
        Objects.requireNonNull(commits, "commits may not be null");
        ArrayList commitList = new ArrayList();
        commits.iterator().forEachRemaining(c -> commitList.add(new Commit(new GitCommitAdapter((RevCommit)c))));
        SemanticVersionChange change = SemanticVersionChange.NONE;
        for (Commit c2 : commitList) {
            Optional<ConventionalCommitType> commitType = c2.getCommitType();
            if (!commitType.isPresent()) continue;
            if (SemanticVersionChange.MAJOR.equals((Object)commitType.get().getChangeType())) {
                return SemanticVersionChange.MAJOR;
            }
            if (SemanticVersionChange.MINOR.equals((Object)commitType.get().getChangeType())) {
                change = SemanticVersionChange.MINOR;
                continue;
            }
            if (!SemanticVersionChange.PATCH.equals((Object)commitType.get().getChangeType()) || SemanticVersionChange.MINOR.equals((Object)change)) continue;
            change = SemanticVersionChange.PATCH;
        }
        return change;
    }
}

