/*
 * Decompiled with CFR 0.152.
 */
package net.videki.semver.cc.release.common;

import java.util.Locale;
import java.util.Objects;
import net.videki.semver.cc.release.common.SemanticVersionChange;

public final class SemanticVersion {
    public static final String VERSION_SUFFIX_SNAPSHOT = "-SNAPSHOT";
    private final Integer major;
    private final Integer minor;
    private final Integer patch;

    public SemanticVersion(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("versions can only contain positive integers");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major.equals(that.major) && this.minor.equals(that.minor) && this.patch.equals(that.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public SemanticVersion releaseVersion(SemanticVersionChange change) {
        SemanticVersion nextVersion;
        switch (change) {
            case MAJOR: {
                nextVersion = new SemanticVersion(this.major + 1, 0, 0);
                break;
            }
            case MINOR: {
                nextVersion = new SemanticVersion(this.major, this.minor + 1, 0);
                break;
            }
            case PATCH: 
            case NONE: {
                nextVersion = new SemanticVersion(this.major, this.minor, this.patch);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid semantic version change");
            }
        }
        return nextVersion;
    }

    public SemanticVersion nextDevelopmentVersion(SemanticVersionChange change) {
        SemanticVersion nextVersion;
        switch (change) {
            case MAJOR: {
                nextVersion = new SemanticVersion(this.major + 1, 0, 0);
                break;
            }
            case MINOR: {
                nextVersion = new SemanticVersion(this.major, this.minor + 1, 0);
                break;
            }
            case PATCH: {
                nextVersion = new SemanticVersion(this.major, this.minor, this.patch + 1);
                break;
            }
            case NONE: {
                nextVersion = new SemanticVersion(this.major, this.minor, this.patch);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid semantic version change");
            }
        }
        return nextVersion;
    }

    public String toString() {
        return SemanticVersion.toString(this.major, this.minor, this.patch);
    }

    public static SemanticVersion parse(String version) {
        Objects.requireNonNull(version, "version required");
        String[] parts = version.replace(VERSION_SUFFIX_SNAPSHOT, "").split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid semantic version: " + version);
        }
        return new SemanticVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    private static String toString(int major, int minor, int patch) {
        return String.format(Locale.US, "%d.%d.%d", major, minor, patch);
    }

    public String getDevelopmentVersionString() {
        return this + VERSION_SUFFIX_SNAPSHOT;
    }
}

