/*
 * Decompiled with CFR 0.152.
 */
package net.videki.semver.cc.release.common;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHandler {
    private final Logger logger = LoggerFactory.getLogger(LogHandler.class);
    private final Repository repository;
    private final Git git;

    public LogHandler(Repository repository) {
        Objects.requireNonNull(repository, "repository cannot be null");
        this.repository = repository;
        this.git = Git.wrap((Repository)repository);
    }

    RevCommit getLastTaggedCommit() throws IOException, GitAPIException {
        RevCommit revCommit;
        List tags = this.git.tagList().call();
        List peeledTags = tags.stream().map(t -> this.repository.peel(t).getPeeledObjectId()).collect(Collectors.toList());
        PlotWalk walk = new PlotWalk(this.repository);
        RevCommit start = walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD"));
        walk.markStart(start);
        while ((revCommit = walk.next()) != null) {
            if (!peeledTags.contains(revCommit.getId())) continue;
            this.logger.debug("Found commit matching last tag: {}", (Object)revCommit);
            break;
        }
        walk.close();
        return revCommit;
    }

    public Iterable<RevCommit> getCommitsSinceLastTag() throws IOException, GitAPIException {
        ObjectId start = this.repository.resolve("HEAD");
        RevCommit lastCommit = this.getLastTaggedCommit();
        if (lastCommit == null) {
            this.logger.warn("No annotated tags found matching any commits on branch");
            return this.git.log().call();
        }
        this.logger.info("Listing commits in range {}...{}", (Object)start.getName(), (Object)lastCommit.getId().getName());
        return this.git.log().addRange((AnyObjectId)lastCommit.getId(), (AnyObjectId)start).call();
    }
}

