/*
 * Decompiled with CFR 0.152.
 */
package net.videki.semver.cc.release.common;

import java.io.IOException;
import java.util.Objects;
import net.videki.semver.cc.release.common.ConventionalVersioning;
import net.videki.semver.cc.release.common.LogHandler;
import net.videki.semver.cc.release.common.SemanticVersion;
import net.videki.semver.cc.release.common.SemanticVersionChange;
import net.videki.semver.cc.release.common.SemanticVersionChangeResolver;
import net.videki.semver.cc.release.common.SimpleSemanticVersionChangeResolver;
import net.videki.semver.cc.release.common.scm.ScmApiException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitConventionalVersioning
implements ConventionalVersioning {
    private final Repository repository;

    public GitConventionalVersioning(Repository repository) {
        Objects.requireNonNull(repository, "repository required");
        this.repository = repository;
    }

    @Override
    public LogHandler logHandler() {
        return new LogHandler(this.repository);
    }

    private SemanticVersionChangeResolver semanticVersionChangeResolver() {
        return new SimpleSemanticVersionChangeResolver();
    }

    @Override
    public SemanticVersionChange getNextVersionChangeType() throws ScmApiException, IOException {
        try {
            Iterable<RevCommit> commits = this.logHandler().getCommitsSinceLastTag();
            SemanticVersionChangeResolver resolver = this.semanticVersionChangeResolver();
            return resolver.resolveChange(commits);
        }
        catch (GitAPIException e) {
            throw new ScmApiException("Git operation failed", e);
        }
    }

    @Override
    public SemanticVersion getReleaseVersion(SemanticVersion currentVersion) throws IOException, ScmApiException {
        SemanticVersionChange change = this.getNextVersionChangeType();
        return currentVersion.releaseVersion(change);
    }
}

