/*
 * Decompiled with CFR 0.152.
 */
package net.videki.semver.cc.release.common;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.videki.semver.cc.release.common.CommitAdapter;
import net.videki.semver.cc.release.common.ConventionalCommitType;

public class Commit {
    private static final Pattern BREAKING_REGEX = Pattern.compile("^((build|chore|ci|docs|fix|feat|refactor|style|test)[a-z0-9\\(\\)]*)((\\!([\\s]*:(.|\\n)*))|([\\s]*:(.|\\n)*(BREAKING(\\s|-)CHANGE)(.|\\n)*))", 2);
    private static final Pattern CONVENTIONAL_COMMIT_REGEX = Pattern.compile("^((build|chore|ci|docs|fix|feat|refactor|style|test)[a-z0-9\\(\\)]*)((\\!([\\s]*:(.|\\n)*))|([\\s]*:(.|\\n)*))", 2);
    private final CommitAdapter commit;

    public Commit(CommitAdapter commit) {
        Objects.requireNonNull(commit, "commit may not be null");
        this.commit = commit;
    }

    public boolean isConventional() {
        return this.getCommitType().isPresent();
    }

    public Optional<ConventionalCommitType> getCommitType() {
        String msg = this.getMessageForComparison();
        ConventionalCommitType type = null;
        if (msg.startsWith("!")) {
            return Optional.empty();
        }
        if (BREAKING_REGEX.matcher(msg).matches()) {
            return Optional.of(ConventionalCommitType.BREAKING_CHANGE);
        }
        if (CONVENTIONAL_COMMIT_REGEX.matcher(msg).matches()) {
            block0: for (ConventionalCommitType cc : ConventionalCommitType.values()) {
                if (ConventionalCommitType.BREAKING_CHANGE.equals(cc)) continue;
                for (String t : cc.getCommitTypes()) {
                    if (!msg.startsWith(t)) continue;
                    type = cc;
                    continue block0;
                }
            }
        }
        return Optional.ofNullable(type);
    }

    private String getMessageForComparison() {
        String msg = this.commit.getShortMessage();
        return msg != null ? msg.toLowerCase() : "";
    }
}

