/*
 * Decompiled with CFR 0.152.
 */
package net.vergien.fig.mojo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.vergien.fig.Generator;
import net.vergien.fig.mojo.PkgConf;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="touch", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class FIGMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private List<PkgConf> mapping;
    private List<String> methodPrefixes = new ArrayList<String>(Arrays.asList("add", "set"));
    @Parameter(defaultValue="A", required=true)
    private String abstractPrefix;
    @Parameter(defaultValue="I", required=true)
    private String interfacePrefix;
    @Parameter(defaultValue="F", required=true)
    private String prefix;

    public void execute() throws MojoExecutionException {
        this.addOutputClassesToClassPath();
        File targetDir = new File(this.outputDirectory, "generated-sources/fluent-interface-generator-maven-plugin");
        this.project.addCompileSourceRoot(targetDir.getAbsolutePath());
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        this.getLog().info((CharSequence)("Prefix for generated abstract classes: " + this.abstractPrefix));
        this.getLog().info((CharSequence)("Prefix for interfaces: " + this.interfacePrefix));
        this.getLog().info((CharSequence)("Prefix for classes: " + this.prefix));
        Generator generator = new Generator(this.getLog(), targetDir, this.abstractPrefix, this.interfacePrefix, this.prefix, this.methodPrefixes);
        for (PkgConf targetPackage : this.mapping) {
            for (String className : targetPackage.getClassNames()) {
                this.getLog().info((CharSequence)("Create class for: " + className));
                try {
                    Class<?> sourceClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    generator.createFluentFor(sourceClass, targetPackage.getPkgName(), targetPackage.getIgnoreMethods(), targetPackage.getInterfacePkgName());
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException("Error creating file " + className, (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating file " + className, (Exception)e);
                }
            }
        }
    }

    private void addOutputClassesToClassPath() {
        URL outputURL = null;
        try {
            outputURL = new File(this.outputDirectory, "classes").toURI().toURL();
            System.out.println(outputURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URLClassLoader contextClassLoader = URLClassLoader.newInstance(new URL[]{outputURL}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }
}

