/*
 * Decompiled with CFR 0.152.
 */
package net.vergien.fig;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class Generator {
    private File targetDir;
    private String abstractPrefix;
    private String interfacePrefix;
    private String prefix;
    private List<String> methodPrefixes;
    private Log log;

    public Generator(Log log, File targetDir, String abstractPrefix, String interfacePrefix, String prefix, List<String> methodPrefixes) {
        this.log = log;
        this.targetDir = targetDir;
        this.abstractPrefix = abstractPrefix;
        this.interfacePrefix = interfacePrefix;
        this.prefix = prefix;
        this.methodPrefixes = new ArrayList<String>(methodPrefixes);
        Collections.sort(this.methodPrefixes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(o1.length(), o2.length());
            }
        });
    }

    public void createFluentFor(Class<?> sourceClass, String targetPackage, List<String> ignoreMethods, String interfaceTargetPackage) throws ClassNotFoundException, IOException {
        String fluentClassName = this.abstractPrefix + sourceClass.getSimpleName();
        Class<?> interfaceClass = this.createInterfaceClass(sourceClass, interfaceTargetPackage == null ? targetPackage : interfaceTargetPackage);
        Set<MethodSpec> withMethodSpecs = this.createMethodSpecs(sourceClass, targetPackage, ignoreMethods, interfaceClass);
        HashSet<MethodSpec> constructorMehtodSpecs = new HashSet<MethodSpec>();
        for (Constructor<?> constructor : sourceClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            constructorMehtodSpecs.add(this.createConstructorMethodSpec(constructor));
        }
        AnnotationSpec generatedAnnotationSpec = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.getClass().getName()}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)fluentClassName).addAnnotation(generatedAnnotationSpec).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.ABSTRACT, javax.lang.model.element.Modifier.PUBLIC}).addMethods(constructorMehtodSpecs).addMethods(withMethodSpecs).superclass(sourceClass);
        if (interfaceClass != null) {
            builder.addSuperinterface(interfaceClass);
        }
        TypeSpec fluentClass = builder.build();
        JavaFile fluentFile = JavaFile.builder((String)targetPackage, (TypeSpec)fluentClass).build();
        fluentFile.writeTo(this.targetDir);
    }

    private Class<?> createInterfaceClass(Class<?> sourceClass, String targetPackage) {
        Class<?> interfaceClass;
        String interfaceClassNameSimple = this.interfacePrefix + sourceClass.getSimpleName();
        String interfaceClassName = targetPackage + "." + interfaceClassNameSimple;
        try {
            this.log.debug((CharSequence)("Search for interface " + interfaceClassName));
            interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(interfaceClassName);
        }
        catch (ClassNotFoundException ex) {
            this.log.debug((CharSequence)("Interface " + interfaceClassName + " not found"));
            return null;
        }
        if (!interfaceClass.isInterface()) {
            this.log.debug((CharSequence)("Interface " + interfaceClassName + " not an interface!"));
            return null;
        }
        this.log.info((CharSequence)("Found interface " + interfaceClassName));
        return interfaceClass;
    }

    protected Set<MethodSpec> createMethodSpecs(Class<?> sourceClass, String targetPackage, List<String> ignoreMethods, Class<?> interfaceClass) {
        String targetClassName = this.prefix + sourceClass.getSimpleName();
        HashSet<MethodSpec> withMethodSpecs = new HashSet<MethodSpec>();
        Type type = sourceClass.getGenericSuperclass();
        HashMap<String, Type> typeMapping = new HashMap<String, Type>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type rawType = pType.getRawType();
            Class rawTypeClass = (Class)rawType;
            this.log.debug((CharSequence)("rawType: " + rawType.toString()));
            this.log.debug((CharSequence)("pType.getActualTypeArguements: " + Arrays.toString(pType.getActualTypeArguments())));
            this.log.debug((CharSequence)("rawTypeClass.getTypedParamters: " + Arrays.toString(rawTypeClass.getTypeParameters())));
            int i = 0;
            for (TypeVariable typeVariable : rawTypeClass.getTypeParameters()) {
                typeMapping.put(typeVariable.getName(), pType.getActualTypeArguments()[i]);
                ++i;
            }
        }
        this.log.debug((CharSequence)("Methods of " + sourceClass.getName() + ":"));
        block1: for (Method sourceMethod : sourceClass.getMethods()) {
            this.log.debug((CharSequence)("\tsourceMethod: " + sourceMethod));
            this.log.debug((CharSequence)("\t" + Arrays.toString(sourceMethod.getGenericParameterTypes())));
            if (!this.methodIsNotIgnored(ignoreMethods, sourceMethod) || !this.methodIsNotCompilerGenerated(sourceMethod) || !this.methodIsNotDeprecated(sourceMethod)) continue;
            for (String methodPrefix : this.methodPrefixes) {
                if (!this.methodIsSetter(sourceMethod, methodPrefix)) continue;
                withMethodSpecs.add(this.createWithMethodSpec(sourceMethod, targetPackage + "." + targetClassName, methodPrefix, sourceClass, interfaceClass, typeMapping));
                continue block1;
            }
        }
        return withMethodSpecs;
    }

    private boolean methodIsSetter(Method sourceMethod, String methodPrefix) {
        return sourceMethod.getName().startsWith(methodPrefix) && sourceMethod.getReturnType().equals(Void.TYPE);
    }

    private boolean methodIsNotDeprecated(Method sourceMethod) {
        return !sourceMethod.isAnnotationPresent(Deprecated.class);
    }

    private boolean methodIsNotCompilerGenerated(Method sourceMethod) {
        return !sourceMethod.isBridge() && !sourceMethod.isSynthetic();
    }

    private boolean methodIsNotIgnored(List<String> ignoreMethods, Method sourceMethod) {
        return !ignoreMethods.contains(sourceMethod.getName());
    }

    private MethodSpec createConstructorMethodSpec(Constructor<?> constructor) {
        List<ParameterSpec> parameterSpecs = this.createParameterSpecs(constructor.getParameters(), null);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterSpec parameterSpec : parameterSpecs) {
            parameterNames.add(parameterSpec.name);
        }
        MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addStatement("super(" + StringUtils.join(parameterNames.iterator(), (String)", ") + ")", new Object[0]).addParameters(parameterSpecs).build();
        return constructorSpec;
    }

    private MethodSpec createWithMethodSpec(Method setter, String targetType, String prefix, Class<?> sourceClass, Class<?> interfaceClass, Map<String, Type> typeMapping) {
        String methodName = "with" + setter.getName().substring(prefix.length());
        List<ParameterSpec> parameters = this.createParameterSpecs(setter.getParameters(), typeMapping);
        boolean varargs = false;
        if (!parameters.isEmpty()) {
            varargs = setter.getParameters()[parameters.size() - 1].isVarArgs();
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterSpec parameterSpec : parameters) {
            parameterNames.add(parameterSpec.name);
        }
        ClassName bestGuess = ClassName.bestGuess((String)targetType);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameters(parameters).addStatement("this." + setter.getName() + "(" + StringUtils.join(parameterNames.iterator(), (String)", ") + ")", new Object[0]).addStatement("return ($T) this", new Object[]{bestGuess}).returns((TypeName)bestGuess);
        if (varargs) {
            builder.varargs(true);
        }
        if (this.hasMethod(sourceClass, methodName, setter.getParameterTypes())) {
            builder.addAnnotation(Override.class);
        } else if (interfaceClass != null && this.hasMethod(interfaceClass, methodName, setter.getParameterTypes())) {
            builder.addAnnotation(Override.class);
        }
        return builder.build();
    }

    private List<ParameterSpec> createParameterSpecs(Parameter[] parameters, Map<String, Type> typeMapping) {
        ArrayList<ParameterSpec> specs = new ArrayList<ParameterSpec>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Type type = parameter.getType();
            if (typeMapping != null && typeMapping.containsKey(parameter.getParameterizedType().getTypeName())) {
                type = typeMapping.get(parameter.getParameterizedType().getTypeName());
            }
            specs.add(ParameterSpec.builder(type, (String)parameter.getName(), (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).build());
        }
        return specs;
    }

    private boolean hasMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            type.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

