package net.vergien.beanautoutils.demo;

import net.vergien.beanautoutils.annotation.Generated;

@Generated(value = "net.vergien.beanautoutils.processor.BeanAutoUtilsProcessor")
public class DemoBeanUtil {
  private DemoBeanUtil() {
    throw new java.lang.IllegalAccessError("Utility class");
  }

  public static String doToString(Demo demo) {
    StringBuilder builder = new StringBuilder();
    builder.append("Demo@");
    builder.append(System.identityHashCode(demo));
    builder.append("[");
    builder.append("intMember=");
    builder.append(demo.getIntMember());
    builder.append(", ");
    builder.append("boolenMember=");
    builder.append(demo.isBoolenMember());
    builder.append(", ");
    builder.append("longMember=");
    builder.append(demo.getLongMember());
    builder.append(", ");
    builder.append("shortMember=");
    builder.append(demo.getShortMember());
    builder.append(", ");
    builder.append("floatMember=");
    builder.append(demo.getFloatMember());
    builder.append(", ");
    builder.append("doubleMember=");
    builder.append(demo.getDoubleMember());
    builder.append(", ");
    builder.append("byteMember=");
    builder.append(demo.getByteMember());
    builder.append(", ");
    builder.append("arrayMember=");
    builder.append(java.util.Arrays.toString(demo.getArrayMember()));
    builder.append(", ");
    builder.append("nonPrimitiveMember=");
    builder.append(demo.getNonPrimitiveMember());
    builder.append(", ");
    builder.append("typeVarMember=");
    builder.append(demo.getTypeVarMember());
    builder.append("]");
    return builder.toString();
  }

  public static int doToHashCode(Demo demo) {
    final int prime = 31;
    int result = 1;
    long temp;
    result = prime * result + demo.getIntMember();
    result = prime * result + (demo.isBoolenMember() ? 1231 : 1237);
    result = prime * result + (int) (demo.getLongMember() ^ (demo.getLongMember() >>> 32));
    result = prime * result + demo.getShortMember();
    result = prime * result + Float.floatToIntBits(demo.getFloatMember());
    temp = Double.doubleToLongBits(demo.getDoubleMember());
    result = prime * result + (int) (temp ^ (temp >>> 32));
    result = prime * result + demo.getByteMember();
    result = prime * result + java.util.Arrays.hashCode(demo.getArrayMember());
    result = prime * result + ((demo.getNonPrimitiveMember() == null) ? 0 : demo.getNonPrimitiveMember().hashCode());
    result = prime * result + ((demo.getTypeVarMember() == null) ? 0 : demo.getTypeVarMember().hashCode());
    return result;
  }

  public static boolean doEquals(Demo lhs, Object obj) {
    if (lhs == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (lhs.getClass() != obj.getClass()) {
      return false;
    }
    Demo other = (Demo) obj;
    if (lhs.getIntMember() != other.getIntMember()) {
      return false;
    }
    if (lhs.isBoolenMember() != other.isBoolenMember()) {
      return false;
    }
    if (lhs.getLongMember() != other.getLongMember()) {
      return false;
    }
    if (lhs.getShortMember() != other.getShortMember()) {
      return false;
    }
    if (Float.floatToIntBits(lhs.getFloatMember()) != (Float.floatToIntBits(other.getFloatMember()))) {
      return false;
    }
    if (Double.doubleToLongBits(lhs.getDoubleMember()) != (Double.doubleToLongBits(other.getDoubleMember()))) {
      return false;
    }
    if (lhs.getByteMember() != other.getByteMember()) {
      return false;
    }
    if (!java.util.Arrays.equals(lhs.getArrayMember(), other.getArrayMember())) {
      return false;
    }
    if (lhs.getNonPrimitiveMember() == null) {
      if (other.getNonPrimitiveMember() != null) {
        return false;
      }
    } else if (!lhs.getNonPrimitiveMember().equals(other.getNonPrimitiveMember())) {
      return false;
    }
    if (lhs.getTypeVarMember() == null) {
      if (other.getTypeVarMember() != null) {
        return false;
      }
    } else if (!lhs.getTypeVarMember().equals(other.getTypeVarMember())) {
      return false;
    }
    return true;
  }
}

