/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.util;

import buri.ddmsence.ddms.UnsupportedVersionException;
import buri.ddmsence.util.PropertyReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DDMSVersion {
    private String _version;
    private String _namespace;
    private String _schema;
    private String _gmlNamespace;
    private String _gmlSchema;
    private String _ismCveLocation;
    private String _ismNamespace;
    private String _ntkNamespace;
    private String _ntkSchema;
    private String _tspiNamespace;
    private String _tspiSchema;
    private String _virtNamespace;
    private String _xlinkNamespace;
    private static final ThreadLocal<DDMSVersion> CURRENT_VERSION_HOLDER = new ThreadLocal();
    private static final Map<String, DDMSVersion> VERSIONS_TO_DETAILS = new TreeMap<String, DDMSVersion>();

    private DDMSVersion(String string) {
        int n = DDMSVersion.getSupportedVersionsProperty().indexOf(string);
        this._version = string;
        this._namespace = DDMSVersion.getSupportedDDMSNamespacesProperty().get(n);
        this._schema = PropertyReader.getProperty(string + ".ddms.xsdLocation");
        this._gmlNamespace = PropertyReader.getProperty(string + ".gml.xmlNamespace");
        this._gmlSchema = PropertyReader.getProperty(string + ".gml.xsdLocation");
        this._ismCveLocation = PropertyReader.getProperty(string + ".ism.cveLocation");
        this._ismNamespace = PropertyReader.getProperty(string + ".ism.xmlNamespace");
        this._ntkNamespace = PropertyReader.getProperty(string + ".ntk.xmlNamespace");
        this._ntkSchema = PropertyReader.getProperty(string + ".ntk.xsdLocation");
        this._tspiNamespace = PropertyReader.getProperty(string + ".tspi.xmlNamespace");
        this._tspiSchema = PropertyReader.getProperty(string + ".tspi.xsdLocation");
        this._virtNamespace = PropertyReader.getProperty(string + ".virt.xmlNamespace");
        this._xlinkNamespace = PropertyReader.getProperty(string + ".xlink.xmlNamespace");
    }

    public boolean isAtLeast(String string) {
        int n;
        string = DDMSVersion.aliasVersion(string);
        if (!DDMSVersion.getSupportedVersionsProperty().contains(string)) {
            throw new UnsupportedVersionException(string);
        }
        int n2 = DDMSVersion.getSupportedVersionsProperty().indexOf(this.getVersion());
        return n2 >= (n = DDMSVersion.getSupportedVersionsProperty().indexOf(string));
    }

    public static List<String> getSupportedVersions() {
        return Collections.unmodifiableList(DDMSVersion.getSupportedVersionsProperty());
    }

    private static List<String> getSupportedVersionsProperty() {
        return PropertyReader.getListProperty("ddms.supportedVersions");
    }

    private static List<String> getSupportedDDMSNamespacesProperty() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : DDMSVersion.getSupportedVersionsProperty()) {
            arrayList.add(PropertyReader.getProperty(string + ".ddms.xmlNamespace"));
        }
        return arrayList;
    }

    public static boolean isSupportedDDMSNamespace(String string) {
        return DDMSVersion.getSupportedDDMSNamespacesProperty().contains(string);
    }

    public static DDMSVersion getVersionFor(String string) {
        string = DDMSVersion.aliasVersion(string);
        if (!DDMSVersion.getSupportedVersionsProperty().contains(string)) {
            throw new UnsupportedVersionException(string);
        }
        return VERSIONS_TO_DETAILS.get(string);
    }

    public static DDMSVersion getVersionForNamespace(String string) {
        ArrayList<DDMSVersion> arrayList = new ArrayList<DDMSVersion>(VERSIONS_TO_DETAILS.values());
        Collections.reverse(arrayList);
        for (DDMSVersion dDMSVersion : arrayList) {
            if (!dDMSVersion.getNamespace().equals(string) && !dDMSVersion.getIsmNamespace().equals(string) && !dDMSVersion.getNtkNamespace().equals(string) && !dDMSVersion.getGmlNamespace().equals(string) && !dDMSVersion.getTspiNamespace().equals(string) && !dDMSVersion.getVirtNamespace().equals(string) && !dDMSVersion.getXlinkNamespace().equals(string)) continue;
            return dDMSVersion;
        }
        throw new UnsupportedVersionException("for XML namespace " + string);
    }

    public static DDMSVersion setCurrentVersion(String string) {
        string = DDMSVersion.aliasVersion(string);
        if (!DDMSVersion.getSupportedVersionsProperty().contains(string)) {
            throw new UnsupportedVersionException(string);
        }
        CURRENT_VERSION_HOLDER.set(DDMSVersion.getVersionFor(string));
        return DDMSVersion.getCurrentVersion();
    }

    private static String aliasVersion(String string) {
        if ("3.0.1".equals(string)) {
            return "3.0";
        }
        if ("4.0.1".equals(string)) {
            return "4.1";
        }
        return string;
    }

    public static DDMSVersion getCurrentVersion() {
        if (CURRENT_VERSION_HOLDER.get() == null) {
            DDMSVersion.setCurrentVersion(PropertyReader.getProperty("ddms.defaultVersion"));
        }
        return CURRENT_VERSION_HOLDER.get();
    }

    public static void clearCurrentVersion() {
        CURRENT_VERSION_HOLDER.remove();
    }

    public String toString() {
        return this.getVersion();
    }

    public String getVersion() {
        return this._version;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getGmlNamespace() {
        return this._gmlNamespace;
    }

    public String getGmlSchema() {
        return this._gmlSchema;
    }

    public String getIsmCveLocation() {
        return this._ismCveLocation;
    }

    public String getIsmNamespace() {
        return this._ismNamespace;
    }

    public String getNtkNamespace() {
        return this._ntkNamespace;
    }

    public String getNtkSchema() {
        return this._ntkSchema;
    }

    public String getTspiNamespace() {
        return this._tspiNamespace;
    }

    public String getTspiSchema() {
        return this._tspiSchema;
    }

    public String getVirtNamespace() {
        return this._virtNamespace;
    }

    public String getXlinkNamespace() {
        return this._xlinkNamespace;
    }

    static {
        for (String string : PropertyReader.getListProperty("ddms.supportedVersions")) {
            VERSIONS_TO_DETAILS.put(string, new DDMSVersion(string));
        }
    }
}

