/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import nu.xom.Element;

public final class VirtualCoverage
extends AbstractBaseComponent {
    private SecurityAttributes _securityAttributes = null;
    private static final String ADDRESS_NAME = "address";
    private static final String PROTOCOL_NAME = "protocol";
    private static final String ACCESS_NAME = "access";
    private static final String NETWORK_NAME = "network";

    public VirtualCoverage(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public VirtualCoverage(String string, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, string2, null, null, securityAttributes);
    }

    public VirtualCoverage(String string, String string2, String string3, String string4, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildDDMSElement(VirtualCoverage.getName(dDMSVersion), null);
            if (dDMSVersion.isAtLeast("5.0")) {
                String string5 = PropertyReader.getPrefix("ntk");
                String string6 = dDMSVersion.getNtkNamespace();
                String string7 = PropertyReader.getPrefix("virt");
                String string8 = dDMSVersion.getVirtNamespace();
                Util.addAttribute(element, string7, ADDRESS_NAME, string8, string);
                Util.addAttribute(element, string7, PROTOCOL_NAME, string8, string2);
                Util.addAttribute(element, string5, ACCESS_NAME, string6, string3);
                Util.addAttribute(element, string7, NETWORK_NAME, string8, string4);
            } else {
                Util.addDDMSAttribute(element, ADDRESS_NAME, string);
                Util.addDDMSAttribute(element, PROTOCOL_NAME, string2);
            }
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), VirtualCoverage.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getAddress())) {
            Util.requireDDMSValue(PROTOCOL_NAME, this.getProtocol());
        }
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            // empty if block
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes must not be applied to this component until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getAddress()) && Util.isEmpty(this.getProtocol()) && Util.isEmpty(this.getAccess()) && Util.isEmpty(this.getNetwork())) {
            this.addWarning("A completely empty ddms:virtualCoverage element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        VirtualCoverage.addJson(jsonObject, ADDRESS_NAME, this.getAddress());
        VirtualCoverage.addJson(jsonObject, PROTOCOL_NAME, this.getProtocol());
        VirtualCoverage.addJson(jsonObject, ACCESS_NAME, this.getAccess());
        VirtualCoverage.addJson(jsonObject, NETWORK_NAME, this.getNetwork());
        VirtualCoverage.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(VirtualCoverage.buildHTMLTextOutput(outputFormat, string3 + ADDRESS_NAME, this.getAddress()));
        stringBuffer.append(VirtualCoverage.buildHTMLTextOutput(outputFormat, string3 + PROTOCOL_NAME, this.getProtocol()));
        stringBuffer.append(VirtualCoverage.buildHTMLTextOutput(outputFormat, string3 + ACCESS_NAME, this.getAccess()));
        stringBuffer.append(VirtualCoverage.buildHTMLTextOutput(outputFormat, string3 + NETWORK_NAME, this.getNetwork()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof VirtualCoverage)) {
            return false;
        }
        VirtualCoverage virtualCoverage = (VirtualCoverage)object;
        return this.getAddress().equals(virtualCoverage.getAddress()) && this.getProtocol().equals(virtualCoverage.getProtocol()) && this.getAccess().equals(virtualCoverage.getAccess()) && this.getNetwork().equals(virtualCoverage.getNetwork());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAddress().hashCode();
        n = 7 * n + this.getProtocol().hashCode();
        n = 7 * n + this.getAccess().hashCode();
        n = 7 * n + this.getNetwork().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "virtualCoverage";
    }

    public String getAddress() {
        if (this.getDDMSVersion().isAtLeast("5.0")) {
            return this.getAttributeValue(ADDRESS_NAME, this.getDDMSVersion().getVirtNamespace());
        }
        return this.getAttributeValue(ADDRESS_NAME);
    }

    public String getProtocol() {
        if (this.getDDMSVersion().isAtLeast("5.0")) {
            return this.getAttributeValue(PROTOCOL_NAME, this.getDDMSVersion().getVirtNamespace());
        }
        return this.getAttributeValue(PROTOCOL_NAME);
    }

    public String getAccess() {
        return this.getAttributeValue(ACCESS_NAME, this.getDDMSVersion().getNtkNamespace());
    }

    public String getNetwork() {
        return this.getAttributeValue(NETWORK_NAME, this.getDDMSVersion().getVirtNamespace());
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 2986952678400201045L;
        private String _access;
        private String _address;
        private String _protocol;
        private String _network;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(VirtualCoverage virtualCoverage) {
            this.setAddress(virtualCoverage.getAddress());
            this.setProtocol(virtualCoverage.getProtocol());
            this.setAccess(virtualCoverage.getAccess());
            this.setNetwork(virtualCoverage.getNetwork());
            this.setSecurityAttributes(new SecurityAttributes.Builder(virtualCoverage.getSecurityAttributes()));
        }

        @Override
        public VirtualCoverage commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new VirtualCoverage(this.getAddress(), this.getProtocol(), this.getAccess(), this.getNetwork(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getAddress()) && Util.isEmpty(this.getProtocol()) && Util.isEmpty(this.getAccess()) && Util.isEmpty(this.getNetwork()) && this.getSecurityAttributes().isEmpty();
        }

        public String getAddress() {
            return this._address;
        }

        public void setAddress(String string) {
            this._address = string;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public void setProtocol(String string) {
            this._protocol = string;
        }

        public String getAccess() {
            return this._access;
        }

        public void setAccess(String string) {
            this._access = string;
        }

        public String getNetwork() {
            return this._network;
        }

        public void setNetwork(String string) {
            this._network = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

