/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Node;

public final class VerticalExtent
extends AbstractBaseComponent {
    private Double _min = null;
    private Double _max = null;
    private static final Set<String> VERTICAL_DATUM_TYPES = new HashSet<String>();
    private static final Set<String> LENGTH_MEASURE_TYPES;
    private static final String DATUM_NAME = "datum";
    private static final String UOM_NAME = "unitOfMeasure";

    public VerticalExtent(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("verticalExtent element", element);
            this.setXOMElement(element, false);
            this._min = VerticalExtent.getChildTextAsDouble(element, this.getMinVerticalExtentName());
            this._max = VerticalExtent.getChildTextAsDouble(element, this.getMaxVerticalExtentName());
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public VerticalExtent(double d, double d2, String string, String string2) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(VerticalExtent.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            Util.addDDMSAttribute(element, UOM_NAME, string);
            Util.addDDMSAttribute(element, DATUM_NAME, string2);
            element.appendChild((Node)Util.buildDDMSElement(this.getMinVerticalExtentName(), String.valueOf(d)));
            element.appendChild((Node)Util.buildDDMSElement(this.getMaxVerticalExtentName(), String.valueOf(d2)));
            this._min = d;
            this._max = d2;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public static void validateVerticalDatumType(String string) throws InvalidDDMSException {
        Util.requireDDMSValue("vertical datum type", string);
        if (!VERTICAL_DATUM_TYPES.contains(string)) {
            throw new InvalidDDMSException("The vertical datum type must be one of " + VERTICAL_DATUM_TYPES);
        }
    }

    public static void validateLengthMeasureType(String string) throws InvalidDDMSException {
        Util.requireDDMSValue("length measure type", string);
        if (!LENGTH_MEASURE_TYPES.contains(string)) {
            throw new InvalidDDMSException("The length measure type must be one of " + LENGTH_MEASURE_TYPES);
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtMostVersion("4.1");
        Util.requireDDMSQName(this.getXOMElement(), VerticalExtent.getName(this.getDDMSVersion()));
        Util.requireDDMSValue(this.getMinVerticalExtentName(), this.getMinVerticalExtent());
        Util.requireDDMSValue(this.getMaxVerticalExtentName(), this.getMaxVerticalExtent());
        Util.requireDDMSValue(UOM_NAME, this.getUnitOfMeasure());
        Util.requireDDMSValue(DATUM_NAME, this.getDatum());
        VerticalExtent.validateLengthMeasureType(this.getUnitOfMeasure());
        VerticalExtent.validateVerticalDatumType(this.getDatum());
        this.validateInheritedAttributes(this.getChild(this.getMinVerticalExtentName()));
        this.validateInheritedAttributes(this.getChild(this.getMaxVerticalExtentName()));
        if (this.getMaxVerticalExtent().compareTo(this.getMinVerticalExtent()) < 0) {
            throw new InvalidDDMSException("Minimum vertical extent must be less than maximum vertical extent.");
        }
        super.validate();
    }

    private void validateInheritedAttributes(Element element) throws InvalidDDMSException {
        String string = element.getAttributeValue(UOM_NAME, element.getNamespaceURI());
        String string2 = element.getAttributeValue(DATUM_NAME, element.getNamespaceURI());
        if (!Util.isEmpty(string) && !string.equals(this.getUnitOfMeasure())) {
            throw new InvalidDDMSException("The unitOfMeasure on the " + element.getLocalName() + " element must match the unitOfMeasure on the enclosing verticalExtent element.");
        }
        if (!Util.isEmpty(string2) && !string2.equals(this.getDatum())) {
            throw new InvalidDDMSException("The datum on the " + element.getLocalName() + " element must match the datum on the enclosing verticalExtent element.");
        }
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        VerticalExtent.addJson(jsonObject, UOM_NAME, this.getUnitOfMeasure());
        VerticalExtent.addJson(jsonObject, DATUM_NAME, this.getDatum());
        VerticalExtent.addJson(jsonObject, "minimum", this.getMinVerticalExtent());
        VerticalExtent.addJson(jsonObject, "maximum", this.getMaxVerticalExtent());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(VerticalExtent.buildHTMLTextOutput(outputFormat, string3 + UOM_NAME, this.getUnitOfMeasure()));
        stringBuffer.append(VerticalExtent.buildHTMLTextOutput(outputFormat, string3 + DATUM_NAME, this.getDatum()));
        stringBuffer.append(VerticalExtent.buildHTMLTextOutput(outputFormat, string3 + "minimum", String.valueOf(this.getMinVerticalExtent())));
        stringBuffer.append(VerticalExtent.buildHTMLTextOutput(outputFormat, string3 + "maximum", String.valueOf(this.getMaxVerticalExtent())));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof VerticalExtent)) {
            return false;
        }
        VerticalExtent verticalExtent = (VerticalExtent)object;
        return this.getUnitOfMeasure().equals(verticalExtent.getUnitOfMeasure()) && this.getDatum().equals(verticalExtent.getDatum()) && this.getMinVerticalExtent().equals(verticalExtent.getMinVerticalExtent()) && this.getMaxVerticalExtent().equals(verticalExtent.getMaxVerticalExtent());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getUnitOfMeasure().hashCode();
        n = 7 * n + this.getDatum().hashCode();
        n = 7 * n + this.getMinVerticalExtent().hashCode();
        n = 7 * n + this.getMaxVerticalExtent().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "verticalExtent";
    }

    private String getMinVerticalExtentName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "minVerticalExtent" : "MinVerticalExtent";
    }

    private String getMaxVerticalExtentName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "maxVerticalExtent" : "MaxVerticalExtent";
    }

    public String getUnitOfMeasure() {
        return this.getAttributeValue(UOM_NAME);
    }

    public String getDatum() {
        return this.getAttributeValue(DATUM_NAME);
    }

    public Double getMinVerticalExtent() {
        return this._min;
    }

    public Double getMaxVerticalExtent() {
        return this._max;
    }

    static {
        VERTICAL_DATUM_TYPES.add("MSL");
        VERTICAL_DATUM_TYPES.add("AGL");
        VERTICAL_DATUM_TYPES.add("HAE");
        LENGTH_MEASURE_TYPES = new HashSet<String>();
        LENGTH_MEASURE_TYPES.add("Meter");
        LENGTH_MEASURE_TYPES.add("Kilometer");
        LENGTH_MEASURE_TYPES.add("Foot");
        LENGTH_MEASURE_TYPES.add("StatuteMile");
        LENGTH_MEASURE_TYPES.add("NauticalMile");
        LENGTH_MEASURE_TYPES.add("Fathom");
        LENGTH_MEASURE_TYPES.add("Inch");
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 5188383406608210723L;
        private Double _minVerticalExtent;
        private Double _maxVerticalExtent;
        private String _unitOfMeasure;
        private String _datum;

        public Builder() {
        }

        public Builder(VerticalExtent verticalExtent) {
            this.setMinVerticalExtent(verticalExtent.getMinVerticalExtent());
            this.setMaxVerticalExtent(verticalExtent.getMaxVerticalExtent());
            this.setUnitOfMeasure(verticalExtent.getUnitOfMeasure());
            this.setDatum(verticalExtent.getDatum());
        }

        @Override
        public VerticalExtent commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            if (this.getMinVerticalExtent() == null || this.getMaxVerticalExtent() == null) {
                throw new InvalidDDMSException("A ddms:verticalExtent must have a minimum and maximum extent value.");
            }
            return new VerticalExtent(this.getMinVerticalExtent(), this.getMaxVerticalExtent(), this.getUnitOfMeasure(), this.getDatum());
        }

        @Override
        public boolean isEmpty() {
            return this.getMinVerticalExtent() == null && this.getMaxVerticalExtent() == null && Util.isEmpty(this.getUnitOfMeasure()) && Util.isEmpty(this.getDatum());
        }

        public Double getMinVerticalExtent() {
            return this._minVerticalExtent;
        }

        public void setMinVerticalExtent(Double d) {
            this._minVerticalExtent = d;
        }

        public Double getMaxVerticalExtent() {
            return this._maxVerticalExtent;
        }

        public void setMaxVerticalExtent(Double d) {
            this._maxVerticalExtent = d;
        }

        public String getUnitOfMeasure() {
            return this._unitOfMeasure;
        }

        public void setUnitOfMeasure(String string) {
            this._unitOfMeasure = string;
        }

        public String getDatum() {
            return this._datum;
        }

        public void setDatum(String string) {
            this._datum = string;
        }
    }
}

