/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.summary.CountryCode;
import buri.ddmsence.ddms.summary.FacilityIdentifier;
import buri.ddmsence.ddms.summary.SubDivisionCode;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class GeographicIdentifier
extends AbstractBaseComponent {
    private List<String> _names = null;
    private List<String> _regions = null;
    private CountryCode _countryCode = null;
    private SubDivisionCode _subDivisionCode = null;
    private FacilityIdentifier _facilityIdentifier = null;
    private static final String NAME_NAME = "name";
    private static final String REGION_NAME = "region";

    public GeographicIdentifier(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            Element element3;
            this.setXOMElement(element, false);
            DDMSVersion dDMSVersion = this.getDDMSVersion();
            this._names = Util.getDDMSChildValues(element, NAME_NAME);
            this._regions = Util.getDDMSChildValues(element, REGION_NAME);
            Element element4 = element.getFirstChildElement(CountryCode.getName(dDMSVersion), this.getNamespace());
            if (element4 != null) {
                this._countryCode = new CountryCode(element4);
            }
            if ((element3 = element.getFirstChildElement(SubDivisionCode.getName(dDMSVersion), this.getNamespace())) != null) {
                this._subDivisionCode = new SubDivisionCode(element3);
            }
            if ((element2 = element.getFirstChildElement(FacilityIdentifier.getName(dDMSVersion), this.getNamespace())) != null) {
                this._facilityIdentifier = new FacilityIdentifier(element2);
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public GeographicIdentifier(List<String> list, List<String> list2, CountryCode countryCode, SubDivisionCode subDivisionCode) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(GeographicIdentifier.getName(DDMSVersion.getCurrentVersion()), null);
            for (String string : list) {
                element.appendChild((Node)Util.buildDDMSElement(NAME_NAME, string));
            }
            for (String string : list2) {
                element.appendChild((Node)Util.buildDDMSElement(REGION_NAME, string));
            }
            if (countryCode != null) {
                element.appendChild((Node)countryCode.getXOMElementCopy());
            }
            if (subDivisionCode != null) {
                element.appendChild((Node)subDivisionCode.getXOMElementCopy());
            }
            this._names = list;
            this._regions = list2;
            this._countryCode = countryCode;
            this._subDivisionCode = subDivisionCode;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public GeographicIdentifier(FacilityIdentifier facilityIdentifier) throws InvalidDDMSException {
        Element element = Util.buildDDMSElement(GeographicIdentifier.getName(DDMSVersion.getCurrentVersion()), null);
        if (facilityIdentifier != null) {
            element.appendChild((Node)facilityIdentifier.getXOMElementCopy());
        }
        this._names = Collections.emptyList();
        this._regions = Collections.emptyList();
        this._facilityIdentifier = facilityIdentifier;
        this.setXOMElement(element, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), GeographicIdentifier.getName(this.getDDMSVersion()));
        if (this.getNames().isEmpty() && this.getRegions().isEmpty() && this.getCountryCode() == null && this.getSubDivisionCode() == null && this.getFacilityIdentifier() == null) {
            throw new InvalidDDMSException("At least 1 of name, region, countryCode, subDivisionCode, or facilityIdentifier must exist.");
        }
        if (!(!this.hasFacilityIdentifier() || this.getNames().isEmpty() && this.getRegions().isEmpty() && this.getCountryCode() == null && this.getSubDivisionCode() == null)) {
            throw new InvalidDDMSException("facilityIdentifier must not be used in tandem with other components.");
        }
        if (this.getDDMSVersion().isAtLeast("5.0") && this.getCountryCode() != null) {
            GeographicIdentifier.validateGencCountryCode(this.getCountryCode());
        }
        super.validate();
    }

    protected static void validateGencCountryCode(CountryCode countryCode) throws InvalidDDMSException {
        String string = countryCode.getQualifier().replaceFirst("^http://api.nsgreg.nga.mil/geo-political/", "geo-political/").replaceFirst("^urn:us:gov:dod:nga:def:geo-political:", "geo-political/").replaceFirst("^ge:", "geo-political:").replaceAll("/", ":");
        String string2 = countryCode.getValue();
        if (!string.matches("^geo-political:GENC:[23n]:ed\\d$")) {
            throw new InvalidDDMSException("ddms:countryCode must use a geo-political URN or URL, as specified in the DDMS Schematron file.");
        }
        if (string.contains("GENC:3:") && !string2.matches("^[A-Z]{3}$")) {
            throw new InvalidDDMSException("A GENC country code in a 3-alpha codespace (e.g. geo-political:GENC:3:ed1) must consist of exactly 3 uppercase alpha characters.");
        }
        if (string.contains("GENC:2:") && !string2.matches("^[A-Z]{2}$")) {
            throw new InvalidDDMSException("A GENC country code in a 2-alpha codespace (e.g. geo-political:GENC:2:ed1) must consist of exactly 2 uppercase alpha characters.");
        }
        if (string.contains("GENC:n:") && !string2.matches("^[0-9]{3}$")) {
            throw new InvalidDDMSException("A GENC country code in a numeric codespace (e.g. geo-political:GENC:n:ed1) must consist of exactly 3 numerals.");
        }
    }

    @Override
    protected void validateWarnings() {
        if (this.getDDMSVersion().isAtLeast("5.0") && this.getCountryCode() != null) {
            this.addWarning("The ddms:countryCode is syntactically correct, but was not looked up in the NGA registry at http://api.nsgreg.nga.mil/.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        GeographicIdentifier.addJson(jsonObject, NAME_NAME, this.getNames());
        GeographicIdentifier.addJson(jsonObject, REGION_NAME, this.getRegions());
        GeographicIdentifier.addJson(jsonObject, this.getCountryCode());
        GeographicIdentifier.addJson(jsonObject, this.getSubDivisionCode());
        GeographicIdentifier.addJson(jsonObject, this.getFacilityIdentifier());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3 + NAME_NAME, this.getNames()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3 + REGION_NAME, this.getRegions()));
        if (this.getCountryCode() != null) {
            stringBuffer.append(this.getCountryCode().getHTMLTextOutput(outputFormat, string3, ""));
        }
        if (this.getSubDivisionCode() != null) {
            stringBuffer.append(this.getSubDivisionCode().getHTMLTextOutput(outputFormat, string3, ""));
        }
        if (this.hasFacilityIdentifier()) {
            stringBuffer.append(this.getFacilityIdentifier().getHTMLTextOutput(outputFormat, string3, ""));
        }
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getCountryCode());
        arrayList.add(this.getSubDivisionCode());
        arrayList.add(this.getFacilityIdentifier());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof GeographicIdentifier)) {
            return false;
        }
        GeographicIdentifier geographicIdentifier = (GeographicIdentifier)object;
        return Util.listEquals(this.getNames(), geographicIdentifier.getNames()) && Util.listEquals(this.getRegions(), geographicIdentifier.getRegions());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getNames().hashCode();
        n = 7 * n + this.getRegions().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "geographicIdentifier";
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this._names);
    }

    public List<String> getRegions() {
        return Collections.unmodifiableList(this._regions);
    }

    public CountryCode getCountryCode() {
        return this._countryCode;
    }

    public SubDivisionCode getSubDivisionCode() {
        return this._subDivisionCode;
    }

    public FacilityIdentifier getFacilityIdentifier() {
        return this._facilityIdentifier;
    }

    public boolean hasFacilityIdentifier() {
        return this.getFacilityIdentifier() != null;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -6626896938484051916L;
        private List<String> _names = null;
        private List<String> _regions = null;
        private CountryCode.Builder _countryCode = null;
        private SubDivisionCode.Builder _subDivisionCode = null;
        private FacilityIdentifier.Builder _facilityIdentifier = null;

        public Builder() {
        }

        public Builder(GeographicIdentifier geographicIdentifier) {
            if (geographicIdentifier.hasFacilityIdentifier()) {
                this.setFacilityIdentifier(new FacilityIdentifier.Builder(geographicIdentifier.getFacilityIdentifier()));
            } else {
                this.setNames(geographicIdentifier.getNames());
                this.setRegions(geographicIdentifier.getRegions());
                if (geographicIdentifier.getCountryCode() != null) {
                    this.setCountryCode(new CountryCode.Builder(geographicIdentifier.getCountryCode()));
                }
                if (geographicIdentifier.getSubDivisionCode() != null) {
                    this.setSubDivisionCode(new SubDivisionCode.Builder(geographicIdentifier.getSubDivisionCode()));
                }
            }
        }

        @Override
        public GeographicIdentifier commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            FacilityIdentifier facilityIdentifier = this.getFacilityIdentifier().commit();
            if (facilityIdentifier != null) {
                return new GeographicIdentifier(facilityIdentifier);
            }
            return new GeographicIdentifier(this.getNames(), this.getRegions(), this.getCountryCode().commit(), this.getSubDivisionCode().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.containsOnlyEmptyValues(this.getNames()) && Util.containsOnlyEmptyValues(this.getRegions()) && this.getCountryCode().isEmpty() && this.getSubDivisionCode().isEmpty() && this.getFacilityIdentifier().isEmpty();
        }

        public List<String> getNames() {
            if (this._names == null) {
                this._names = new LazyList(String.class);
            }
            return this._names;
        }

        public void setNames(List<String> list) {
            this._names = new LazyList(list, String.class);
        }

        public List<String> getRegions() {
            if (this._regions == null) {
                this._regions = new LazyList(String.class);
            }
            return this._regions;
        }

        public void setRegions(List<String> list) {
            this._regions = new LazyList(list, String.class);
        }

        public CountryCode.Builder getCountryCode() {
            if (this._countryCode == null) {
                this._countryCode = new CountryCode.Builder();
            }
            return this._countryCode;
        }

        public void setCountryCode(CountryCode.Builder builder) {
            this._countryCode = builder;
        }

        public SubDivisionCode.Builder getSubDivisionCode() {
            if (this._subDivisionCode == null) {
                this._subDivisionCode = new SubDivisionCode.Builder();
            }
            return this._subDivisionCode;
        }

        public void setSubDivisionCode(SubDivisionCode.Builder builder) {
            this._subDivisionCode = builder;
        }

        public FacilityIdentifier.Builder getFacilityIdentifier() {
            if (this._facilityIdentifier == null) {
                this._facilityIdentifier = new FacilityIdentifier.Builder();
            }
            return this._facilityIdentifier;
        }

        public void setFacilityIdentifier(FacilityIdentifier.Builder builder) {
            this._facilityIdentifier = builder;
        }
    }
}

