/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import nu.xom.Element;

public final class Source
extends AbstractQualifierValue {
    private SecurityAttributes _securityAttributes = null;
    private static final String SCHEMA_QUALIFIER_NAME = "schemaQualifier";
    private static final String SCHEMA_HREF_NAME = "schemaHref";

    public Source(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Source(String string, String string2, String string3, String string4, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Source.getName(DDMSVersion.getCurrentVersion()), string, string2, false, true);
        try {
            Element element = this.getXOMElement();
            Util.addDDMSAttribute(element, SCHEMA_QUALIFIER_NAME, string3);
            Util.addDDMSAttribute(element, SCHEMA_HREF_NAME, string4);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Source.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getSchemaHref())) {
            Util.requireDDMSValidURI(this.getSchemaHref());
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes must not be applied to this component until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue()) && Util.isEmpty(this.getSchemaQualifier()) && Util.isEmpty(this.getSchemaHref())) {
            this.addWarning("A completely empty ddms:source element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Source.addJson(jsonObject, this.getQualifierName(), this.getQualifier());
        Source.addJson(jsonObject, this.getValueName(), this.getValue());
        Source.addJson(jsonObject, SCHEMA_QUALIFIER_NAME, this.getSchemaQualifier());
        Source.addJson(jsonObject, SCHEMA_HREF_NAME, this.getSchemaHref());
        Source.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Source.buildHTMLTextOutput(outputFormat, string3 + this.getQualifierName(), this.getQualifier()));
        stringBuffer.append(Source.buildHTMLTextOutput(outputFormat, string3 + this.getValueName(), this.getValue()));
        stringBuffer.append(Source.buildHTMLTextOutput(outputFormat, string3 + SCHEMA_QUALIFIER_NAME, this.getSchemaQualifier()));
        stringBuffer.append(Source.buildHTMLTextOutput(outputFormat, string3 + SCHEMA_HREF_NAME, this.getSchemaHref()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Source)) {
            return false;
        }
        Source source = (Source)object;
        return this.getSchemaQualifier().equals(source.getSchemaQualifier()) && this.getSchemaHref().equals(source.getSchemaHref());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSchemaQualifier().hashCode();
        n = 7 * n + this.getSchemaHref().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "source";
    }

    public String getSchemaQualifier() {
        return this.getAttributeValue(SCHEMA_QUALIFIER_NAME);
    }

    public String getSchemaHref() {
        return this.getAttributeValue(SCHEMA_HREF_NAME);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = -514632949760329348L;
        private String _schemaQualifier;
        private String _schemaHref;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(Source source) {
            super(source);
            this.setSchemaQualifier(source.getSchemaQualifier());
            this.setSchemaHref(source.getSchemaHref());
            this.setSecurityAttributes(new SecurityAttributes.Builder(source.getSecurityAttributes()));
        }

        @Override
        public Source commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Source(this.getQualifier(), this.getValue(), this.getSchemaQualifier(), this.getSchemaHref(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.isEmpty(this.getSchemaQualifier()) && Util.isEmpty(this.getSchemaHref()) && this.getSecurityAttributes().isEmpty();
        }

        public String getSchemaQualifier() {
            return this._schemaQualifier;
        }

        public void setSchemaQualifier(String string) {
            this._schemaQualifier = string;
        }

        public String getSchemaHref() {
            return this._schemaHref;
        }

        public void setSchemaHref(String string) {
            this._schemaHref = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

