/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Service
extends AbstractRoleEntity {
    private List<String> _affiliations = null;
    private static final String AFFILIATION_NAME = "affiliation";

    public Service(Element element) throws InvalidDDMSException {
        super(element, true);
        this._affiliations = Util.getDDMSChildValues(element, AFFILIATION_NAME);
    }

    public Service(List<String> list, List<String> list2, List<String> list3) throws InvalidDDMSException {
        this(list, list2, list3, null, null);
    }

    public Service(List<String> list, List<String> list2, List<String> list3, List<String> list4, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        super(Service.getName(DDMSVersion.getCurrentVersion()), list, list2, list3, extensibleAttributes);
        try {
            if (list4 == null) {
                list4 = Collections.emptyList();
            }
            Element element = this.getXOMElement();
            for (String string : list4) {
                element.appendChild((Node)Util.buildDDMSElement(AFFILIATION_NAME, string));
            }
            this._affiliations = list4;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Service.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = super.getJSONObject();
        Service.addJson(jsonObject, AFFILIATION_NAME, this.getAffiliations());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer(super.getHTMLTextOutput(outputFormat, string3, ""));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3 + AFFILIATION_NAME, this.getAffiliations()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Service)) {
            return false;
        }
        Service service = (Service)object;
        return Util.listEquals(this.getAffiliations(), service.getAffiliations());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAffiliations().hashCode();
        return n;
    }

    public List<String> getAffiliations() {
        return Collections.unmodifiableList(this._affiliations);
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "service" : "Service";
    }

    public static class Builder
    extends AbstractRoleEntity.Builder {
        private static final long serialVersionUID = 7653534173085296283L;
        private List<String> _affiliations;

        public Builder() {
        }

        public Builder(Service service) {
            super(service);
            this.setAffiliations(service.getAffiliations());
        }

        @Override
        public Service commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Service(this.getNames(), this.getPhones(), this.getEmails(), this.getAffiliations(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.containsOnlyEmptyValues(this.getAffiliations());
        }

        public List<String> getAffiliations() {
            if (this._affiliations == null) {
                this._affiliations = new LazyList(String.class);
            }
            return this._affiliations;
        }

        public void setAffiliations(List<String> list) {
            this._affiliations = new LazyList(list, String.class);
        }
    }
}

