/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.ITspiAddress;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import nu.xom.Element;

public abstract class AbstractTspiAddress
extends AbstractBaseComponent
implements ITspiAddress {
    public static final String NO_PREFIX = "";
    public static final String NO_NAMESPACE = "";
    public static final String ADD_ACTION = "ADD";
    public static final String DELETE_ACTION = "DELETE";
    private static final Set<String> ACTIONS = new HashSet<String>();
    private static final String ACTION_NAME = "action";

    protected AbstractTspiAddress(Element element) throws InvalidDDMSException {
        super(element);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("5.0");
        if (!Util.isEmpty(this.getAction()) && !ACTIONS.contains(this.getAction())) {
            throw new InvalidDDMSException("The action attribute must be one of " + ACTIONS);
        }
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        String string = this.getName().replaceAll("USPS", "usps");
        AbstractTspiAddress.addJson(jsonObject, "addressType", Util.decapitalize(string));
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = this.getName().replaceAll("USPS", "usps");
        stringBuffer.append(AbstractTspiAddress.buildHTMLTextOutput(outputFormat, string3 + "addressType", Util.decapitalize(string4)));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AbstractTspiAddress abstractTspiAddress = (AbstractTspiAddress)object;
        return this.getAction().equals(abstractTspiAddress.getAction()) && this.toXML().equals(abstractTspiAddress.toXML());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAction().hashCode();
        n = 7 * n + this.toXML().hashCode();
        return n;
    }

    public String getAction() {
        return this.getAttributeValue(ACTION_NAME, "");
    }

    static {
        ACTIONS.add(ADD_ACTION);
        ACTIONS.add(DELETE_ACTION);
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7824644958681123708L;
        private String _xml;

        protected Builder() {
        }

        protected Builder(AbstractTspiAddress abstractTspiAddress) {
            this.setXml(abstractTspiAddress.toXML());
        }

        protected Element commitXml() throws InvalidDDMSException {
            return Util.commitXml(this.getXml());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getXml());
        }

        public String getXml() {
            return this._xml;
        }

        public void setXml(String string) {
            this._xml = string;
        }
    }
}

