/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractSimpleString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import nu.xom.Element;

public final class Description
extends AbstractSimpleString {
    public Description(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public Description(String string, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Description.getName(DDMSVersion.getCurrentVersion()), string, securityAttributes, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Description.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("A ddms:" + this.getName() + " element was found with no description value.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Description.addJson(jsonObject, this.getName(), this.getValue());
        Description.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Description.buildHTMLTextOutput(outputFormat, string3, this.getValue()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3 + "."));
        return stringBuffer.toString();
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "description";
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Description;
    }

    public static class Builder
    extends AbstractSimpleString.Builder {
        private static final long serialVersionUID = 7750664735441105296L;

        public Builder() {
        }

        public Builder(Description description) {
            super(description);
        }

        @Override
        public Description commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Description(this.getValue(), this.getSecurityAttributes().commit());
        }
    }
}

