/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ISMVocabulary {
    public static final String CVE_DECLASS_EXCEPTION = "CVEnumISM25X.xml";
    public static final String CVE_ATOMIC_ENERGY_MARKINGS = "CVEnumISMAtomicEnergyMarkings.xml";
    public static final String CVE_ALL_CLASSIFICATIONS = "CVEnumISMClassificationAll.xml";
    public static final String CVE_US_CLASSIFICATIONS = "CVEnumISMClassificationUS.xml";
    public static final String CVE_COMPLIES_WITH = "CVEnumISMCompliesWith.xml";
    public static final String CVE_DISPLAY_ONLY_TO = "CVEnumISMRelTo.xml";
    public static final String CVE_DISSEMINATION_CONTROLS = "CVEnumISMDissem.xml";
    public static final String CVE_FGI_SOURCE_OPEN = "CVEnumISMFGIOpen.xml";
    public static final String CVE_FGI_SOURCE_PROTECTED = "CVEnumISMFGIProtected.xml";
    public static final String CVE_NON_IC_MARKINGS = "CVEnumISMNonIC.xml";
    public static final String CVE_NON_US_CONTROLS = "CVEnumISMNonUSControls.xml";
    public static final String CVE_NOTICE_TYPE = "CVEnumISMNotice.xml";
    public static final String CVE_OWNER_PRODUCERS = "CVEnumISMOwnerProducer.xml";
    public static final String CVE_POC_TYPE = "CVEnumISMPocType.xml";
    public static final String CVE_RELEASABLE_TO = "CVEnumISMRelTo.xml";
    public static final String CVE_SAR_IDENTIFIER = "CVEnumISMSAR.xml";
    public static final String CVE_SCI_CONTROLS = "CVEnumISMSCIControls.xml";
    public static final String CVE_TYPE_EXEMPTED_SOURCE = "CVEnumISMSourceMarked.xml";
    private static final Set<String> COMMON_NETWORK_TYPES = new HashSet<String>();
    private static final List<String> ALL_ENUMS;
    private static final String ENUMERATION_NAME = "Enumeration";
    private static final String TERM_NAME = "Term";
    private static final String VALUE_NAME = "Value";
    private static final String REG_EXP_NAME = "regularExpression";
    private static final ThreadLocal<String> LAST_ENUM_HOLDER;
    private static final ThreadLocal<Map<String, Set<String>>> ENUM_TOKEN_HOLDER;
    private static final ThreadLocal<Map<String, Set<String>>> ENUM_PATTERN_HOLDER;

    private ISMVocabulary() {
    }

    public static void validateEnumeration(DDMSVersion dDMSVersion, String string, String string2) throws InvalidDDMSException {
        if (!ISMVocabulary.enumContains(dDMSVersion, string, string2)) {
            String string3 = ISMVocabulary.getInvalidMessage(string, string2);
            throw new InvalidDDMSException(string3);
        }
    }

    public static Set<String> getEnumerationTokens(DDMSVersion dDMSVersion, String string) {
        ISMVocabulary.updateEnumLocation(dDMSVersion);
        Set<String> set = ENUM_TOKEN_HOLDER.get().get(string);
        if (set == null) {
            throw new IllegalArgumentException("No controlled vocabulary could be found for this key: " + string);
        }
        return Collections.unmodifiableSet(set);
    }

    protected static boolean enumContains(DDMSVersion dDMSVersion, String string, String string2) {
        Util.requireValue("key", string);
        boolean bl = ISMVocabulary.getEnumerationTokens(dDMSVersion, string).contains(string2);
        if (!bl) {
            for (String string3 : ISMVocabulary.getEnumerationPatterns(dDMSVersion, string)) {
                Pattern pattern = Pattern.compile(string3);
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected static Set<String> getEnumerationPatterns(DDMSVersion dDMSVersion, String string) {
        ISMVocabulary.updateEnumLocation(dDMSVersion);
        Set<String> set = ENUM_PATTERN_HOLDER.get().get(string);
        return Collections.unmodifiableSet(set);
    }

    private static void updateEnumLocation(DDMSVersion dDMSVersion) {
        String string = PropertyReader.getProperty(dDMSVersion.getVersion() + ".ism.cveLocation");
        if (LAST_ENUM_HOLDER.get() == null || !LAST_ENUM_HOLDER.get().equals(string)) {
            LAST_ENUM_HOLDER.set(string);
            try {
                ENUM_TOKEN_HOLDER.get().clear();
                ENUM_PATTERN_HOLDER.get().clear();
                XMLReader xMLReader = XMLReaderFactory.createXMLReader(PropertyReader.getProperty("xml.reader.class"));
                Builder builder = new Builder(xMLReader, false);
                for (String string2 : ALL_ENUMS) {
                    try {
                        String string3 = PropertyReader.getProperty(dDMSVersion.getVersion() + ".ism.cve.xmlNamespace");
                        ISMVocabulary.loadEnumeration(string, string3, builder, string2);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("Could not load controlled vocabularies: " + sAXException.getMessage());
            }
        }
    }

    private static void loadEnumeration(String string, String string2, Builder builder, String string3) throws ParsingException, IOException {
        InputStream inputStream = new ISMVocabulary().getClass().getResourceAsStream(string + string3);
        Document document = builder.build(inputStream);
        TreeSet<String> treeSet = new TreeSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Element element = document.getRootElement().getFirstChildElement(ENUMERATION_NAME, string2);
        Elements elements = element.getChildElements(TERM_NAME, string2);
        for (int i = 0; i < elements.size(); ++i) {
            Element element2 = elements.get(i).getFirstChildElement(VALUE_NAME, string2);
            boolean bl = Boolean.valueOf(element2.getAttributeValue(REG_EXP_NAME));
            if (element2 == null) continue;
            if (bl) {
                hashSet.add(element2.getValue());
                continue;
            }
            treeSet.add(element2.getValue());
        }
        ENUM_TOKEN_HOLDER.get().put(string3, treeSet);
        ENUM_PATTERN_HOLDER.get().put(string3, hashSet);
    }

    public static boolean usingOldClassification(String string) {
        return "NS-S".equals(string) || "NS-A".equals(string);
    }

    public static String getInvalidMessage(String string, String string2) {
        return string2 + " is not a valid enumeration token for this attribute, as specified in " + string + ".";
    }

    public static void requireValidNetwork(String string) throws InvalidDDMSException {
        if (!COMMON_NETWORK_TYPES.contains(string)) {
            throw new InvalidDDMSException("The network attribute must be one of " + COMMON_NETWORK_TYPES);
        }
    }

    static {
        COMMON_NETWORK_TYPES.add("NIPRNet");
        COMMON_NETWORK_TYPES.add("SIPRNet");
        COMMON_NETWORK_TYPES.add("JWICS");
        COMMON_NETWORK_TYPES.add("ADSN");
        COMMON_NETWORK_TYPES.add("StoneGhost");
        COMMON_NETWORK_TYPES.add("LOCE");
        COMMON_NETWORK_TYPES.add("CRONOS");
        COMMON_NETWORK_TYPES.add("other");
        ALL_ENUMS = new ArrayList<String>();
        ALL_ENUMS.add(CVE_DECLASS_EXCEPTION);
        ALL_ENUMS.add(CVE_ATOMIC_ENERGY_MARKINGS);
        ALL_ENUMS.add(CVE_ALL_CLASSIFICATIONS);
        ALL_ENUMS.add(CVE_US_CLASSIFICATIONS);
        ALL_ENUMS.add(CVE_COMPLIES_WITH);
        ALL_ENUMS.add(CVE_DISSEMINATION_CONTROLS);
        ALL_ENUMS.add("CVEnumISMRelTo.xml");
        ALL_ENUMS.add(CVE_FGI_SOURCE_OPEN);
        ALL_ENUMS.add(CVE_FGI_SOURCE_PROTECTED);
        ALL_ENUMS.add(CVE_NON_IC_MARKINGS);
        ALL_ENUMS.add(CVE_NON_US_CONTROLS);
        ALL_ENUMS.add(CVE_NOTICE_TYPE);
        ALL_ENUMS.add(CVE_OWNER_PRODUCERS);
        ALL_ENUMS.add(CVE_POC_TYPE);
        ALL_ENUMS.add("CVEnumISMRelTo.xml");
        ALL_ENUMS.add(CVE_SAR_IDENTIFIER);
        ALL_ENUMS.add(CVE_SCI_CONTROLS);
        ALL_ENUMS.add(CVE_TYPE_EXEMPTED_SOURCE);
        LAST_ENUM_HOLDER = new ThreadLocal();
        ENUM_TOKEN_HOLDER = new ThreadLocal<Map<String, Set<String>>>(){

            @Override
            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
        ENUM_PATTERN_HOLDER = new ThreadLocal<Map<String, Set<String>>>(){

            @Override
            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
    }
}

