/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.resource.Details;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Link;
import buri.ddmsence.ddms.summary.xlink.XLinkAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;

public final class RevisionRecall
extends AbstractBaseComponent {
    private List<Link> _links = null;
    private List<Details> _details = null;
    private Integer _revisionID = null;
    private XLinkAttributes _xlinkAttributes = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String FIXED_TYPE = "resource";
    public static final String NO_PREFIX = "";
    public static final String NO_NAMESPACE = "";
    private static final String REVISION_ID_NAME = "revisionID";
    private static final String REVISION_TYPE_NAME = "revisionType";
    private static final String NETWORK_NAME = "network";
    private static final String OTHER_NETWORK_NAME = "otherNetwork";
    private static final Set<String> REVISION_TYPE_TYPES = new HashSet<String>();

    public RevisionRecall(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._links = new ArrayList<Link>();
            Elements elements = element.getChildElements(Link.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._links.add(new Link(elements.get(i)));
            }
            this._details = new ArrayList<Details>();
            Elements elements2 = element.getChildElements(Details.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements2.size(); ++i) {
                this._details.add(new Details(elements2.get(i)));
            }
            String string = element.getAttributeValue(REVISION_ID_NAME, this.getNamespace());
            if (!Util.isEmpty(string)) {
                this._revisionID = Integer.valueOf(string);
            }
            this._xlinkAttributes = new XLinkAttributes(element);
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public RevisionRecall(List<Link> list, List<Details> list2, Integer n, String string, String string2, String string3, XLinkAttributes xLinkAttributes, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(null, list, list2, n, string, string2, string3, xLinkAttributes, securityAttributes);
    }

    public RevisionRecall(String string, Integer n, String string2, String string3, String string4, XLinkAttributes xLinkAttributes, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, null, null, n, string2, string3, string4, xLinkAttributes, securityAttributes);
    }

    private RevisionRecall(String string, List<Link> list, List<Details> list2, Integer n, String string2, String string3, String string4, XLinkAttributes xLinkAttributes, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(RevisionRecall.getName(DDMSVersion.getCurrentVersion()), string);
            for (Link object : list) {
                element.appendChild((Node)object.getXOMElementCopy());
            }
            for (Details details : list2) {
                element.appendChild((Node)details.getXOMElementCopy());
            }
            if (n != null) {
                this._revisionID = n;
                Util.addDDMSAttribute(element, REVISION_ID_NAME, n.toString());
            }
            Util.addDDMSAttribute(element, REVISION_TYPE_NAME, string2);
            if (DDMSVersion.getCurrentVersion().isAtLeast("5.0")) {
                String string5 = PropertyReader.getPrefix("virt");
                String string6 = DDMSVersion.getCurrentVersion().getVirtNamespace();
                Util.addAttribute(element, string5, NETWORK_NAME, string6, string3);
            } else {
                Util.addAttribute(element, "", NETWORK_NAME, "", string3);
            }
            Util.addAttribute(element, "", OTHER_NETWORK_NAME, "", string4);
            this._links = list;
            this._details = list2;
            this._xlinkAttributes = XLinkAttributes.getNonNullInstance(xLinkAttributes);
            this._xlinkAttributes.addTo(element);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        int n;
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), RevisionRecall.getName(this.getDDMSVersion()));
        boolean bl = false;
        for (n = 0; n < this.getXOMElement().getChildCount(); ++n) {
            Node node = this.getXOMElement().getChild(n);
            bl = bl || node instanceof Text && !Util.isEmpty(node.getValue().trim());
        }
        int n2 = n = !this.getLinks().isEmpty() || !this.getDetails().isEmpty() ? 1 : 0;
        if (bl && n != 0) {
            throw new InvalidDDMSException("A ddms:revisionRecall element must not have both child text and nested elements.");
        }
        for (Link link : this.getLinks()) {
            Util.requireDDMSValue("link security attributes", link.getSecurityAttributes());
            link.getSecurityAttributes().requireClassification();
        }
        Util.requireDDMSValue("revision ID", this.getRevisionID());
        if (!REVISION_TYPE_TYPES.contains(this.getRevisionType())) {
            throw new InvalidDDMSException("The revisionType attribute must be one of " + REVISION_TYPE_TYPES);
        }
        if (!Util.isEmpty(this.getXLinkAttributes().getType()) && !this.getXLinkAttributes().getType().equals(FIXED_TYPE)) {
            throw new InvalidDDMSException("The type attribute must have a fixed value of \"resource\".");
        }
        if (!Util.isEmpty(this.getNetwork())) {
            ISMVocabulary.requireValidNetwork(this.getNetwork());
        }
        if (this.getDDMSVersion().isAtLeast("5.0") && !Util.isEmpty(this.getOtherNetwork())) {
            throw new InvalidDDMSException("The otherNetwork attribute must not be used after DDMS 4.1.");
        }
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (this.getXLinkAttributes() != null) {
            this.addWarnings(this.getXLinkAttributes().getValidationWarnings(), true);
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        boolean bl = !this.getLinks().isEmpty() || !this.getDetails().isEmpty();
        JsonObject jsonObject = new JsonObject();
        if (!bl) {
            RevisionRecall.addJson(jsonObject, this.getName(), this.getValue());
        }
        RevisionRecall.addJson(jsonObject, REVISION_ID_NAME, this.getRevisionID());
        RevisionRecall.addJson(jsonObject, REVISION_TYPE_NAME, this.getRevisionType());
        RevisionRecall.addJson(jsonObject, NETWORK_NAME, this.getNetwork());
        RevisionRecall.addJson(jsonObject, OTHER_NETWORK_NAME, this.getOtherNetwork());
        RevisionRecall.addJson(jsonObject, "link", this.getLinks());
        RevisionRecall.addJson(jsonObject, "detail", this.getDetails());
        RevisionRecall.addJson(jsonObject, this.getXLinkAttributes());
        RevisionRecall.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        boolean bl = !this.getLinks().isEmpty() || !this.getDetails().isEmpty();
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append(RevisionRecall.buildHTMLTextOutput(outputFormat, string3, this.getValue()));
        }
        stringBuffer.append(RevisionRecall.buildHTMLTextOutput(outputFormat, string3 + "." + REVISION_ID_NAME, String.valueOf(this.getRevisionID())));
        stringBuffer.append(RevisionRecall.buildHTMLTextOutput(outputFormat, string3 + "." + REVISION_TYPE_NAME, this.getRevisionType()));
        stringBuffer.append(RevisionRecall.buildHTMLTextOutput(outputFormat, string3 + "." + NETWORK_NAME, this.getNetwork()));
        stringBuffer.append(RevisionRecall.buildHTMLTextOutput(outputFormat, string3 + "." + OTHER_NETWORK_NAME, this.getOtherNetwork()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3 + ".", this.getLinks()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3 + ".", this.getDetails()));
        stringBuffer.append(this.getXLinkAttributes().getHTMLTextOutput(outputFormat, string3 + "."));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getLinks());
        arrayList.addAll(this.getDetails());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof RevisionRecall)) {
            return false;
        }
        RevisionRecall revisionRecall = (RevisionRecall)object;
        return this.getValue().equals(revisionRecall.getValue()) && Util.nullEquals(this.getRevisionID(), revisionRecall.getRevisionID()) && this.getRevisionType().equals(revisionRecall.getRevisionType()) && this.getNetwork().equals(revisionRecall.getNetwork()) && this.getOtherNetwork().equals(revisionRecall.getOtherNetwork()) && this.getXLinkAttributes().equals(revisionRecall.getXLinkAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getValue().hashCode();
        n = 7 * n + this.getRevisionID().hashCode();
        n = 7 * n + this.getRevisionType().hashCode();
        n = 7 * n + this.getNetwork().hashCode();
        n = 7 * n + this.getOtherNetwork().hashCode();
        n = 7 * n + this.getXLinkAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "revisionRecall";
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this._links);
    }

    public List<Details> getDetails() {
        return Collections.unmodifiableList(this._details);
    }

    public String getValue() {
        return this.getXOMElement().getValue();
    }

    public Integer getRevisionID() {
        return this._revisionID;
    }

    public String getRevisionType() {
        return this.getAttributeValue(REVISION_TYPE_NAME);
    }

    public String getNetwork() {
        String string = this.getDDMSVersion().isAtLeast("5.0") ? this.getDDMSVersion().getVirtNamespace() : "";
        return this.getAttributeValue(NETWORK_NAME, string);
    }

    public String getOtherNetwork() {
        return this.getAttributeValue(OTHER_NETWORK_NAME, "");
    }

    public XLinkAttributes getXLinkAttributes() {
        return this._xlinkAttributes;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    static {
        REVISION_TYPE_TYPES.add("ADMINISTRATIVE RECALL");
        REVISION_TYPE_TYPES.add("ADMINISTRATIVE REVISION");
        REVISION_TYPE_TYPES.add("SUBSTANTIVE RECALL");
        REVISION_TYPE_TYPES.add("SUBSTANTIVE REVISION");
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4325950371570699184L;
        private String _value;
        private List<Link.Builder> _links;
        private List<Details.Builder> _details;
        private Integer _revisionID;
        private String _revisionType;
        private String _network;
        private String _otherNetwork;
        private XLinkAttributes.Builder _xlinkAttributes;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(RevisionRecall revisionRecall) {
            for (Link abstractBaseComponent : revisionRecall.getLinks()) {
                this.getLinks().add(new Link.Builder(abstractBaseComponent));
            }
            for (Details details : revisionRecall.getDetails()) {
                this.getDetails().add(new Details.Builder(details));
            }
            if (revisionRecall.getLinks().isEmpty() && revisionRecall.getDetails().isEmpty()) {
                this.setValue(revisionRecall.getValue());
            }
            this.setRevisionID(revisionRecall.getRevisionID());
            this.setRevisionType(revisionRecall.getRevisionType());
            this.setNetwork(revisionRecall.getNetwork());
            this.setOtherNetwork(revisionRecall.getOtherNetwork());
            this.setXLinkAttributes(new XLinkAttributes.Builder(revisionRecall.getXLinkAttributes()));
            this.setSecurityAttributes(new SecurityAttributes.Builder(revisionRecall.getSecurityAttributes()));
        }

        @Override
        public RevisionRecall commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Link> arrayList = new ArrayList<Link>();
            for (IBuilder object : this.getLinks()) {
                Link link = (Link)object.commit();
                if (link == null) continue;
                arrayList.add(link);
            }
            ArrayList arrayList2 = new ArrayList();
            for (IBuilder iBuilder : this.getDetails()) {
                Details details = (Details)iBuilder.commit();
                if (details == null) continue;
                arrayList2.add(details);
            }
            return new RevisionRecall(this.getValue(), arrayList, arrayList2, this.getRevisionID(), this.getRevisionType(), this.getNetwork(), this.getOtherNetwork(), this.getXLinkAttributes().commit(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getLinks()) {
                bl = bl || !iBuilder.isEmpty();
            }
            for (IBuilder iBuilder : this.getDetails()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && Util.isEmpty(this.getValue()) && this.getRevisionID() == null && Util.isEmpty(this.getRevisionType()) && Util.isEmpty(this.getNetwork()) && Util.isEmpty(this.getOtherNetwork()) && this.getXLinkAttributes().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public List<Link.Builder> getLinks() {
            if (this._links == null) {
                this._links = new LazyList(Link.Builder.class);
            }
            return this._links;
        }

        public List<Details.Builder> getDetails() {
            if (this._details == null) {
                this._details = new LazyList(Details.Builder.class);
            }
            return this._details;
        }

        public Integer getRevisionID() {
            return this._revisionID;
        }

        public void setRevisionID(Integer n) {
            this._revisionID = n;
        }

        public String getRevisionType() {
            return this._revisionType;
        }

        public void setRevisionType(String string) {
            this._revisionType = string;
        }

        public String getNetwork() {
            return this._network;
        }

        public void setNetwork(String string) {
            this._network = string;
        }

        public String getOtherNetwork() {
            return this._otherNetwork;
        }

        public void setOtherNetwork(String string) {
            this._otherNetwork = string;
        }

        public XLinkAttributes.Builder getXLinkAttributes() {
            if (this._xlinkAttributes == null) {
                this._xlinkAttributes = new XLinkAttributes.Builder();
            }
            return this._xlinkAttributes;
        }

        public void setXLinkAttributes(XLinkAttributes.Builder builder) {
            this._xlinkAttributes = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

