/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractSimpleString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Element;

public final class ProcessingInfo
extends AbstractSimpleString {
    private static final String DATE_PROCESSED_NAME = "dateProcessed";

    public ProcessingInfo(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public ProcessingInfo(String string, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(ProcessingInfo.getName(DDMSVersion.getCurrentVersion()), string, securityAttributes, false);
        try {
            Util.addDDMSAttribute(this.getXOMElement(), DATE_PROCESSED_NAME, string2);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), ProcessingInfo.getName(this.getDDMSVersion()));
        Util.requireDDMSValue(DATE_PROCESSED_NAME, this.getDateProcessedString());
        Util.requireDDMSDateFormat(this.getDateProcessedString(), this.getNamespace());
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        ProcessingInfo.addJson(jsonObject, this.getName(), this.getValue());
        ProcessingInfo.addJson(jsonObject, DATE_PROCESSED_NAME, this.getDateProcessedString());
        ProcessingInfo.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ProcessingInfo.buildHTMLTextOutput(outputFormat, string3, this.getValue()));
        stringBuffer.append(ProcessingInfo.buildHTMLTextOutput(outputFormat, string3 + "." + DATE_PROCESSED_NAME, this.getDateProcessedString()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof ProcessingInfo)) {
            return false;
        }
        ProcessingInfo processingInfo = (ProcessingInfo)object;
        return Util.nullEquals(this.getDateProcessedString(), processingInfo.getDateProcessedString());
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "processingInfo";
    }

    public XMLGregorianCalendar getDateProcessed() {
        return Util.toXMLGregorianCalendar(this.getDateProcessedString());
    }

    public String getDateProcessedString() {
        return this.getAttributeValue(DATE_PROCESSED_NAME);
    }

    public static class Builder
    extends AbstractSimpleString.Builder {
        private static final long serialVersionUID = -7348511606867959470L;
        private String _dateProcessed;

        public Builder() {
        }

        public Builder(ProcessingInfo processingInfo) {
            super(processingInfo);
            this.setDateProcessed(processingInfo.getDateProcessedString());
        }

        @Override
        public ProcessingInfo commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new ProcessingInfo(this.getValue(), this.getDateProcessed(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.isEmpty(this.getDateProcessed());
        }

        public String getDateProcessed() {
            return this._dateProcessed;
        }

        public void setDateProcessed(String string) {
            this._dateProcessed = string;
        }
    }
}

