/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.util;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.ITspiAddress;
import buri.ddmsence.ddms.ITspiShape;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.Notice;
import buri.ddmsence.ddms.security.ntk.Access;
import buri.ddmsence.ddms.summary.TemporalCoverage;
import buri.ddmsence.ddms.summary.gml.Point;
import buri.ddmsence.ddms.summary.gml.Polygon;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sf.saxon.om.NameChecker;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;
import org.joda.time.format.ISODateTimeFormat;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Util {
    private static XSLTransform _schematronIncludeTransform;
    private static XSLTransform _schematronAbstractTransform;
    private static Map<String, XSLTransform> _schematronSvrlTransforms;
    private static final String PROP_TRANSFORM_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final LinkedHashMap<String, String> XML_SPECIAL_CHARS;
    private static final String DDMS_DATE_HOUR_MIN_PATTERN = "[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(Z|[\\-\\+][0-9]{2}:[0-9]{2})?";
    private static Set<QName> DATE_DATATYPES;
    private static DatatypeFactory _factory;

    private Util() {
    }

    public static DatatypeFactory getDataTypeFactory() {
        return _factory;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(String string) {
        try {
            return Util.getDataTypeFactory().newXMLGregorianCalendar(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Util.isEmpty(string) || TemporalCoverage.EXTENDED_DATE_TYPES.contains(string)) {
                return null;
            }
            GregorianCalendar gregorianCalendar = ISODateTimeFormat.dateTimeParser().parseDateTime(string).toGregorianCalendar();
            return Util.getDataTypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        }
    }

    public static JsonArray getJSONArray(List<?> list) {
        JsonArray jsonArray = new JsonArray();
        for (Object obj : list) {
            if (obj instanceof Double) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)((Double)obj)));
                continue;
            }
            if (obj instanceof String) {
                jsonArray.add((JsonElement)new JsonPrimitive((String)obj));
                continue;
            }
            if (obj instanceof AbstractBaseComponent) {
                jsonArray.add((JsonElement)((AbstractBaseComponent)obj).getJSONObject());
                continue;
            }
            throw new IllegalArgumentException("Unexpected class for JSON property: " + obj);
        }
        return jsonArray;
    }

    public static void addNonEmptyJsonProperty(JsonObject jsonObject, String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof AbstractAttributeGroup) {
            AbstractAttributeGroup abstractAttributeGroup = (AbstractAttributeGroup)object;
            if (!abstractAttributeGroup.isEmpty()) {
                if (Boolean.valueOf(PropertyReader.getProperty("output.json.inlineAttributes")).booleanValue()) {
                    JsonObject jsonObject2 = abstractAttributeGroup.getJSONObject();
                    for (Map.Entry entry : jsonObject2.entrySet()) {
                        jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                } else {
                    jsonObject.add(string, (JsonElement)abstractAttributeGroup.getJSONObject());
                }
            }
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            jsonObject.addProperty(string, bl);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            jsonObject.addProperty(string, (Number)d);
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            jsonObject.addProperty(string, (Number)n);
        } else if (object instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)object;
            if (jsonArray.size() != 0) {
                jsonObject.add(string, (JsonElement)jsonArray);
            }
        } else if (object instanceof JsonObject) {
            JsonObject jsonObject3 = (JsonObject)object;
            jsonObject.add(string, (JsonElement)jsonObject3);
        } else if (object instanceof String) {
            String string2 = (String)object;
            if (!Util.isEmpty(string2)) {
                jsonObject.addProperty(string, string2);
            }
        } else {
            throw new IllegalArgumentException("Unexpected class for JSON property: " + object);
        }
    }

    public static String getNonNullString(String string) {
        return string == null ? "" : string;
    }

    public static List<String> getXsListAsList(String string) {
        if (Util.isEmpty(string)) {
            return Collections.emptyList();
        }
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (Util.isEmpty(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static String getXsList(List<?> list) {
        if (list == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object obj : list) {
            stringBuffer.append(obj).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public static int booleanHashCode(boolean bl) {
        return bl ? 1 : 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean containsOnlyEmptyValues(List<String> list) {
        if (list != null) {
            int n = 0;
            for (String string : list) {
                if (!Util.isEmpty(string)) continue;
                ++n;
            }
            return list.size() == n;
        }
        return false;
    }

    public static String getFirstDDMSChildValue(Element element, String string) {
        Util.requireValue("parent element", element);
        Util.requireValue("child name", string);
        if (!DDMSVersion.isSupportedDDMSNamespace(element.getNamespaceURI())) {
            throw new IllegalArgumentException("This method should only be called on an element in the DDMS namespace.");
        }
        Element element2 = element.getFirstChildElement(string, element.getNamespaceURI());
        return element2 == null ? "" : element2.getValue();
    }

    public static List<String> getDDMSChildValues(Element element, String string) {
        Util.requireValue("parent element", element);
        Util.requireValue("child name", string);
        if (!DDMSVersion.isSupportedDDMSNamespace(element.getNamespaceURI())) {
            throw new IllegalArgumentException("This method should only be called on an element in the DDMS namespace.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Elements elements = element.getChildElements(string, element.getNamespaceURI());
        for (int i = 0; i < elements.size(); ++i) {
            arrayList.add(elements.get(i).getValue());
        }
        return arrayList;
    }

    public static void requireHTMLText(OutputFormat outputFormat) {
        if (outputFormat != OutputFormat.HTML && outputFormat != OutputFormat.TEXT) {
            throw new IllegalArgumentException("This method can only be used for HTML or Text output.");
        }
    }

    public static void requireDDMSValue(String string, Object object) throws InvalidDDMSException {
        if (object == null || object instanceof String && Util.isEmpty((String)object)) {
            throw new InvalidDDMSException(string + " must exist.");
        }
    }

    public static void requireDDMSDateFormat(String string, String string2) throws InvalidDDMSException {
        Object object;
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(string2);
        if (dDMSVersion.isAtLeast("4.1") && Pattern.matches(DDMS_DATE_HOUR_MIN_PATTERN, string)) {
            return;
        }
        boolean bl = false;
        try {
            object = Util.getDataTypeFactory().newXMLGregorianCalendar(string);
            bl = DATE_DATATYPES.contains(((XMLGregorianCalendar)object).getXMLSchemaType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!bl) {
            object = "The date datatype must be one of " + DATE_DATATYPES;
            if (dDMSVersion.isAtLeast("4.1")) {
                object = (String)object + " or ddms:DateHourMinType";
            }
            throw new InvalidDDMSException((String)object);
        }
    }

    public static void requireDDMSQName(Element element, String string) throws InvalidDDMSException {
        Util.requireValue("element", element);
        Util.requireValue("local name", string);
        if (!string.equals(element.getLocalName()) || !DDMSVersion.isSupportedDDMSNamespace(element.getNamespaceURI())) {
            throw new InvalidDDMSException("Unexpected namespace URI and local name encountered: " + element.getQualifiedName());
        }
    }

    public static void requireQName(Element element, String string, String string2) throws InvalidDDMSException {
        Util.requireValue("element", element);
        Util.requireValue("local name", string2);
        if (string == null) {
            string = "";
        }
        if (!string2.equals(element.getLocalName()) || !string.equals(element.getNamespaceURI())) {
            throw new InvalidDDMSException("Unexpected namespace URI and local name encountered: " + element.getQualifiedName());
        }
    }

    public static void requireValue(String string, Object object) {
        if (object == null || object instanceof String && Util.isEmpty((String)object)) {
            throw new IllegalArgumentException(string + " must exist.");
        }
    }

    public static void requireBoundedChildCount(Element element, String string, int n, int n2) throws InvalidDDMSException {
        Util.requireValue("parent element", element);
        Util.requireValue("child name", string);
        int n3 = element.getChildElements(string, element.getNamespaceURI()).size();
        if (!Util.isBounded(n3, n, n2)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n == n2) {
                stringBuffer.append("Exactly ").append(n2).append(" ").append(string).append(" element");
                if (n2 != 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append(" must exist.");
            } else if (n == 0) {
                stringBuffer.append("No more than ").append(n2).append(" ").append(string).append(" element");
                if (n2 != 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append(" must exist.");
            } else {
                stringBuffer.append("The number of ").append(string).append(" elements must be between ").append(n).append(" and ").append(n2).append(".");
            }
            throw new InvalidDDMSException(stringBuffer.toString());
        }
    }

    public static void requireValidNCNames(List<String> list) throws InvalidDDMSException {
        if (list == null) {
            list = Collections.emptyList();
        }
        for (String string : list) {
            Util.requireValidNCName(string);
        }
    }

    public static void requireCompatibleVersion(IDDMSComponent iDDMSComponent, IDDMSComponent iDDMSComponent2) throws InvalidDDMSException {
        String string;
        Util.requireValue("parent", iDDMSComponent);
        Util.requireValue("child", iDDMSComponent2);
        String string2 = iDDMSComponent.getNamespace();
        if (iDDMSComponent2 instanceof Polygon || iDDMSComponent2 instanceof Point) {
            string2 = DDMSVersion.getVersionForNamespace(string2).getGmlNamespace();
        }
        if (iDDMSComponent2 instanceof Access) {
            string2 = DDMSVersion.getVersionForNamespace(string2).getNtkNamespace();
        }
        if (iDDMSComponent2 instanceof Notice) {
            string2 = DDMSVersion.getVersionForNamespace(string2).getIsmNamespace();
        }
        if (iDDMSComponent2 instanceof ITspiAddress || iDDMSComponent2 instanceof ITspiShape) {
            string2 = DDMSVersion.getVersionForNamespace(string2).getTspiNamespace();
        }
        if (!string2.equals(string = iDDMSComponent2.getNamespace())) {
            throw new InvalidDDMSException("A child component, " + iDDMSComponent2.getQualifiedName() + ", is using a different version of DDMS from its parent.");
        }
    }

    public static void requireValidNCName(String string) throws InvalidDDMSException {
        if (!NameChecker.isValidNCName((CharSequence)Util.getNonNullString(string))) {
            throw new InvalidDDMSException("\"" + string + "\" is not a valid NCName.");
        }
    }

    public static void requireValidNMToken(String string) throws InvalidDDMSException {
        if (!NameChecker.isValidNmtoken((CharSequence)Util.getNonNullString(string))) {
            throw new InvalidDDMSException("\"" + string + "\" is not a valid NMTOKEN.");
        }
    }

    public static void requireDDMSValidURI(String string) throws InvalidDDMSException {
        Util.requireValue("uri", string);
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidDDMSException(uRISyntaxException);
        }
    }

    public static void requireValidLongitude(Double d) throws InvalidDDMSException {
        if (d == null || new Double(-180.0).compareTo(d) > 0 || new Double(180.0).compareTo(d) < 0) {
            throw new InvalidDDMSException("A longitude value must be between -180 and 180 degrees: " + d);
        }
    }

    public static void requireValidLatitude(Double d) throws InvalidDDMSException {
        if (d == null || new Double(-90.0).compareTo(d) > 0 || new Double(90.0).compareTo(d) < 0) {
            throw new InvalidDDMSException("A latitude value must be between -90 and 90 degrees: " + d);
        }
    }

    public static boolean isBounded(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("Invalid number range: " + n2 + " to " + n3);
        }
        return n >= n2 && n <= n3;
    }

    public static boolean listEquals(List<?> list, List<?> list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("Null lists cannot be compared.");
        }
        if (list == list2) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj;
            Object obj2 = list.get(i);
            if (Util.nullEquals(obj2, obj = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean nullEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static String xmlEscape(String string) {
        if (string != null) {
            for (String string2 : XML_SPECIAL_CHARS.keySet()) {
                string = Pattern.compile(string2).matcher(string).replaceAll(XML_SPECIAL_CHARS.get(string2));
            }
        }
        return string;
    }

    public static String capitalize(String string) {
        if (Util.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    public static String decapitalize(String string) {
        if (Util.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
    }

    public static void addDDMSAttribute(Element element, String string, String string2) {
        Util.addAttribute(element, PropertyReader.getPrefix("ddms"), string, DDMSVersion.getCurrentVersion().getNamespace(), string2);
    }

    public static void addAttribute(Element element, String string, String string2, String string3, String string4) {
        if (!Util.isEmpty(string4)) {
            element.addAttribute(Util.buildAttribute(string, string2, string3, string4));
        }
    }

    public static void addDDMSChildElement(Element element, String string, String string2) {
        if (!Util.isEmpty(string2)) {
            element.appendChild((Node)Util.buildDDMSElement(string, string2));
        }
    }

    public static Element buildDDMSElement(String string, String string2) {
        return Util.buildElement(PropertyReader.getPrefix("ddms"), string, DDMSVersion.getCurrentVersion().getNamespace(), string2);
    }

    public static Element buildElement(String string, String string2, String string3, String string4) {
        Util.requireValue("name", string2);
        string = Util.isEmpty(string) ? "" : string + ":";
        Element element = new Element(string + string2, string3);
        if (!Util.isEmpty(string4)) {
            element.appendChild(string4);
        }
        return element;
    }

    public static Attribute buildDDMSAttribute(String string, String string2) {
        return Util.buildAttribute(PropertyReader.getPrefix("ddms"), string, DDMSVersion.getCurrentVersion().getNamespace(), string2);
    }

    public static Attribute buildAttribute(String string, String string2, String string3, String string4) {
        Util.requireValue("name", string2);
        Util.requireValue("value", string4);
        String string5 = string = Util.isEmpty(string) ? "" : string + ":";
        if (string3 == null) {
            string3 = "";
        }
        return new Attribute(string + string2, string3, string4);
    }

    public static Document buildXmlDocument(InputStream inputStream) throws IOException {
        Util.requireValue("input stream", inputStream);
        try {
            return new Builder().build(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new IOException(parsingException.getMessage());
        }
    }

    public static Element commitXml(String string) throws InvalidDDMSException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(PropertyReader.getProperty("xml.reader.class"));
            Builder builder = new Builder(xMLReader, false);
            Document document = builder.build((Reader)new StringReader(string));
            return document.getRootElement();
        }
        catch (Exception exception) {
            throw new InvalidDDMSException("Could not create a valid element from XML string: " + exception.getMessage());
        }
    }

    public static String getSchematronQueryBinding(Document document) throws IOException {
        Attribute attribute = document.getRootElement().getAttribute("queryBinding");
        return attribute == null ? "xslt" : attribute.getValue();
    }

    public static XSLTransform buildSchematronTransform(File file) throws IOException, XSLException {
        String string = System.getProperty(PROP_TRANSFORM_FACTORY);
        String string2 = PropertyReader.getProperty("xml.transform.TransformerFactory");
        if (Util.isEmpty(string) || !string2.equals(string)) {
            Util.clearTransformCaches();
            System.setProperty(PROP_TRANSFORM_FACTORY, string2);
        }
        Document document = Util.buildXmlDocument(new FileInputStream(file));
        String string3 = Util.getSchematronQueryBinding(document);
        XSLTransform xSLTransform = Util.getSchematronIncludeTransform();
        XSLTransform xSLTransform2 = Util.getSchematronAbstractTransform();
        XSLTransform xSLTransform3 = Util.getSchematronSvrlTransform(string3);
        Nodes nodes = xSLTransform3.transform(xSLTransform2.transform(xSLTransform.transform(document)));
        XSLTransform xSLTransform4 = new XSLTransform(XSLTransform.toDocument((Nodes)nodes));
        return xSLTransform4;
    }

    private static synchronized void clearTransformCaches() {
        _schematronIncludeTransform = null;
        _schematronAbstractTransform = null;
        _schematronSvrlTransforms.clear();
    }

    private static synchronized XSLTransform getSchematronIncludeTransform() throws IOException, XSLException {
        if (_schematronIncludeTransform == null) {
            InputStream inputStream = Util.getLoader().getResourceAsStream("schematron/iso_dsdl_include.xsl");
            _schematronIncludeTransform = new XSLTransform(Util.buildXmlDocument(inputStream));
        }
        return _schematronIncludeTransform;
    }

    private static synchronized XSLTransform getSchematronAbstractTransform() throws IOException, XSLException {
        if (_schematronAbstractTransform == null) {
            InputStream inputStream = Util.getLoader().getResourceAsStream("schematron/iso_abstract_expand.xsl");
            _schematronAbstractTransform = new XSLTransform(Util.buildXmlDocument(inputStream));
        }
        return _schematronAbstractTransform;
    }

    private static synchronized XSLTransform getSchematronSvrlTransform(String string) throws IOException, XSLException {
        String string2;
        if ("xslt2".equals(string)) {
            string2 = "schematron/iso_svrl_for_xslt2.xsl";
        } else if ("xslt".equals(string)) {
            string2 = "schematron/iso_svrl_for_xslt1.xsl";
        } else {
            throw new IllegalArgumentException("DDMSence currently only supports Schematron files with a queryBinding attribute of \"xslt\" or \"xslt2\".");
        }
        if (_schematronSvrlTransforms.get(string2) == null) {
            try {
                InputStream inputStream = Util.getLoader().getResourceAsStream(string2);
                Document document = Util.buildXmlDocument(inputStream);
                URI uRI = Util.getLoader().getResource(string2).toURI();
                document.setBaseURI(uRI.toString());
                _schematronSvrlTransforms.put(string2, new XSLTransform(document));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException.getMessage());
            }
        }
        return _schematronSvrlTransforms.get(string2);
    }

    private static ClassLoader getLoader() {
        return new FindClassLoader().getClass().getClassLoader();
    }

    static {
        _schematronSvrlTransforms = new HashMap<String, XSLTransform>();
        XML_SPECIAL_CHARS = new LinkedHashMap();
        XML_SPECIAL_CHARS.put("&", "&amp;");
        XML_SPECIAL_CHARS.put("\"", "&quot;");
        XML_SPECIAL_CHARS.put("'", "&apos;");
        XML_SPECIAL_CHARS.put("<", "&lt;");
        XML_SPECIAL_CHARS.put(">", "&gt;");
        DATE_DATATYPES = new HashSet<QName>();
        DATE_DATATYPES.add(DatatypeConstants.DATE);
        DATE_DATATYPES.add(DatatypeConstants.DATETIME);
        DATE_DATATYPES.add(DatatypeConstants.GYEARMONTH);
        DATE_DATATYPES.add(DatatypeConstants.GYEAR);
        try {
            _factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException("Could not load DatatypeFactory for date conversion.", datatypeConfigurationException);
        }
    }

    private static class FindClassLoader {
    }
}

