/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.ITspiShape;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.summary.gml.Point;
import buri.ddmsence.ddms.summary.gml.Polygon;
import buri.ddmsence.ddms.summary.tspi.Circle;
import buri.ddmsence.ddms.summary.tspi.Ellipse;
import buri.ddmsence.ddms.summary.tspi.Envelope;
import buri.ddmsence.ddms.summary.tspi.Point;
import buri.ddmsence.ddms.summary.tspi.Polygon;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class BoundingGeometry
extends AbstractBaseComponent {
    private List<buri.ddmsence.ddms.summary.gml.Polygon> _polygons = null;
    private List<buri.ddmsence.ddms.summary.gml.Point> _points = null;
    private List<ITspiShape> _tspiShapes = null;

    public BoundingGeometry(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("boundingGeometry element", element);
            this.setXOMElement(element, false);
            if (!this.getDDMSVersion().isAtLeast("5.0")) {
                String string = this.getDDMSVersion().getGmlNamespace();
                this._polygons = new ArrayList<buri.ddmsence.ddms.summary.gml.Polygon>();
                this._points = new ArrayList<buri.ddmsence.ddms.summary.gml.Point>();
                Elements elements = element.getChildElements(buri.ddmsence.ddms.summary.gml.Polygon.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements.size(); ++i) {
                    this._polygons.add(new buri.ddmsence.ddms.summary.gml.Polygon(elements.get(i)));
                }
                Elements elements2 = element.getChildElements(buri.ddmsence.ddms.summary.gml.Point.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements2.size(); ++i) {
                    this._points.add(new buri.ddmsence.ddms.summary.gml.Point(elements2.get(i)));
                }
            } else {
                String string = this.getDDMSVersion().getTspiNamespace();
                this._tspiShapes = new ArrayList<ITspiShape>();
                Elements elements = element.getChildElements(Circle.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements.size(); ++i) {
                    this._tspiShapes.add(new Circle(elements.get(i)));
                }
                Elements elements3 = element.getChildElements(Ellipse.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements3.size(); ++i) {
                    this._tspiShapes.add(new Ellipse(elements3.get(i)));
                }
                Elements elements4 = element.getChildElements(Envelope.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements4.size(); ++i) {
                    this._tspiShapes.add(new Envelope(elements4.get(i)));
                }
                Elements elements5 = element.getChildElements(Point.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements5.size(); ++i) {
                    this._tspiShapes.add(new Point(elements5.get(i)));
                }
                Elements elements6 = element.getChildElements(Polygon.getName(this.getDDMSVersion()), string);
                for (int i = 0; i < elements6.size(); ++i) {
                    this._tspiShapes.add(new Polygon(elements6.get(i)));
                }
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public BoundingGeometry(List<buri.ddmsence.ddms.summary.gml.Polygon> list, List<buri.ddmsence.ddms.summary.gml.Point> list2) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(BoundingGeometry.getName(DDMSVersion.getCurrentVersion()), null);
            for (buri.ddmsence.ddms.summary.gml.Polygon abstractBaseComponent : list) {
                element.appendChild((Node)abstractBaseComponent.getXOMElementCopy());
            }
            for (buri.ddmsence.ddms.summary.gml.Point point : list2) {
                element.appendChild((Node)point.getXOMElementCopy());
            }
            this._polygons = list;
            this._points = list2;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public BoundingGeometry(List<ITspiShape> list) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(BoundingGeometry.getName(DDMSVersion.getCurrentVersion()), null);
            if (list == null) {
                list = Collections.emptyList();
            }
            for (ITspiShape iTspiShape : list) {
                element.appendChild((Node)iTspiShape.getXOMElementCopy());
            }
            this._tspiShapes = list;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), BoundingGeometry.getName(this.getDDMSVersion()));
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            if (this.getGmlPolygons().size() + this.getGmlPoints().size() == 0) {
                throw new InvalidDDMSException("At least 1 of Polygon or Point must be used.");
            }
        } else {
            if (this.getGmlPolygons().size() + this.getGmlPoints().size() > 0) {
                throw new InvalidDDMSException("boundingGeometry must be defined with TSPI shapes.");
            }
            if (this.getTspiShapes().isEmpty()) {
                throw new InvalidDDMSException("At least 1 TSPI shape must exist.");
            }
        }
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            BoundingGeometry.addJson(jsonObject, "polygon", this.getGmlPolygons());
            BoundingGeometry.addJson(jsonObject, "point", this.getGmlPoints());
        } else {
            for (ITspiShape iTspiShape : this.getTspiShapes()) {
                BoundingGeometry.addJson(jsonObject, (AbstractBaseComponent)((Object)iTspiShape));
            }
        }
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3, this.getGmlPolygons()));
            stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3, this.getGmlPoints()));
        } else {
            for (ITspiShape iTspiShape : this.getTspiShapes()) {
                stringBuffer.append(iTspiShape.getHTMLTextOutput(outputFormat, string3, ""));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getGmlPoints());
        arrayList.addAll(this.getGmlPolygons());
        arrayList.addAll(this.getTspiShapes());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof BoundingGeometry;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "boundingGeometry";
    }

    public List<buri.ddmsence.ddms.summary.gml.Polygon> getGmlPolygons() {
        if (this._polygons == null) {
            this._polygons = Collections.emptyList();
        }
        return Collections.unmodifiableList(this._polygons);
    }

    public List<buri.ddmsence.ddms.summary.gml.Point> getGmlPoints() {
        if (this._points == null) {
            this._points = Collections.emptyList();
        }
        return Collections.unmodifiableList(this._points);
    }

    public List<ITspiShape> getTspiShapes() {
        if (this._tspiShapes == null) {
            this._tspiShapes = Collections.emptyList();
        }
        return Collections.unmodifiableList(this._tspiShapes);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -5734267242408462644L;
        private List<Polygon.Builder> _gmlPolygons;
        private List<Point.Builder> _gmlPoints;
        private List<Circle.Builder> _circles;
        private List<Ellipse.Builder> _ellipses;
        private List<Envelope.Builder> _envelopes;
        private List<Point.Builder> _points;
        private List<Polygon.Builder> _polygons;

        public Builder() {
        }

        public Builder(BoundingGeometry boundingGeometry) {
            for (buri.ddmsence.ddms.summary.gml.Polygon iDDMSComponent : boundingGeometry.getGmlPolygons()) {
                this.getGmlPolygons().add(new Polygon.Builder(iDDMSComponent));
            }
            for (buri.ddmsence.ddms.summary.gml.Point point : boundingGeometry.getGmlPoints()) {
                this.getGmlPoints().add(new Point.Builder(point));
            }
            for (ITspiShape iTspiShape : boundingGeometry.getTspiShapes()) {
                if (iTspiShape instanceof Circle) {
                    this.getCircles().add(new Circle.Builder((Circle)iTspiShape));
                }
                if (iTspiShape instanceof Ellipse) {
                    this.getEllipses().add(new Ellipse.Builder((Ellipse)iTspiShape));
                }
                if (iTspiShape instanceof Envelope) {
                    this.getEnvelopes().add(new Envelope.Builder((Envelope)iTspiShape));
                }
                if (iTspiShape instanceof Point) {
                    this.getPoints().add(new Point.Builder((Point)iTspiShape));
                }
                if (!(iTspiShape instanceof Polygon)) continue;
                this.getPolygons().add(new Polygon.Builder((Polygon)iTspiShape));
            }
        }

        @Override
        public BoundingGeometry commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            if (!DDMSVersion.getCurrentVersion().isAtLeast("5.0")) {
                ArrayList<buri.ddmsence.ddms.summary.gml.Polygon> arrayList = new ArrayList<buri.ddmsence.ddms.summary.gml.Polygon>();
                for (Polygon.Builder object : this.getGmlPolygons()) {
                    buri.ddmsence.ddms.summary.gml.Polygon polygon = object.commit();
                    if (polygon == null) continue;
                    arrayList.add(polygon);
                }
                ArrayList arrayList2 = new ArrayList();
                for (Point.Builder builder : this.getGmlPoints()) {
                    buri.ddmsence.ddms.summary.gml.Point point = builder.commit();
                    if (point == null) continue;
                    arrayList2.add(point);
                }
                return new BoundingGeometry(arrayList, arrayList2);
            }
            ArrayList<ITspiShape> arrayList = new ArrayList<ITspiShape>();
            for (Circle.Builder builder : this.getCircles()) {
                Circle circle = builder.commit();
                if (circle == null) continue;
                arrayList.add(circle);
            }
            for (Ellipse.Builder builder : this.getEllipses()) {
                Ellipse ellipse = builder.commit();
                if (ellipse == null) continue;
                arrayList.add(ellipse);
            }
            for (Envelope.Builder builder : this.getEnvelopes()) {
                Envelope envelope = builder.commit();
                if (envelope == null) continue;
                arrayList.add(envelope);
            }
            for (Point.Builder builder : this.getPoints()) {
                Point point = builder.commit();
                if (point == null) continue;
                arrayList.add(point);
            }
            for (Polygon.Builder builder : this.getPolygons()) {
                Polygon polygon = builder.commit();
                if (polygon == null) continue;
                arrayList.add(polygon);
            }
            return new BoundingGeometry(arrayList);
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getChildBuilders()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl;
        }

        private List<IBuilder> getChildBuilders() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getGmlPolygons());
            arrayList.addAll(this.getGmlPoints());
            arrayList.addAll(this.getCircles());
            arrayList.addAll(this.getEllipses());
            arrayList.addAll(this.getEnvelopes());
            arrayList.addAll(this.getPoints());
            arrayList.addAll(this.getPolygons());
            return arrayList;
        }

        public List<Polygon.Builder> getGmlPolygons() {
            if (this._gmlPolygons == null) {
                this._gmlPolygons = new LazyList(Polygon.Builder.class);
            }
            return this._gmlPolygons;
        }

        public List<Point.Builder> getGmlPoints() {
            if (this._gmlPoints == null) {
                this._gmlPoints = new LazyList(Point.Builder.class);
            }
            return this._gmlPoints;
        }

        public List<Circle.Builder> getCircles() {
            if (this._circles == null) {
                this._circles = new LazyList(Circle.Builder.class);
            }
            return this._circles;
        }

        public List<Ellipse.Builder> getEllipses() {
            if (this._ellipses == null) {
                this._ellipses = new LazyList(Ellipse.Builder.class);
            }
            return this._ellipses;
        }

        public List<Envelope.Builder> getEnvelopes() {
            if (this._envelopes == null) {
                this._envelopes = new LazyList(Envelope.Builder.class);
            }
            return this._envelopes;
        }

        public List<Point.Builder> getPoints() {
            if (this._points == null) {
                this._points = new LazyList(Point.Builder.class);
            }
            return this._points;
        }

        public List<Polygon.Builder> getPolygons() {
            if (this._polygons == null) {
                this._polygons = new LazyList(Polygon.Builder.class);
            }
            return this._polygons;
        }
    }
}

