/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractNtkString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import nu.xom.Element;

public final class GroupValue
extends AbstractNtkString {
    public GroupValue(Element element) throws InvalidDDMSException {
        super(false, element);
    }

    public GroupValue(String string, String string2, String string3, String string4, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(false, GroupValue.getName(DDMSVersion.getCurrentVersion()), string, string2, string3, string4, securityAttributes, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), GroupValue.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("A ntk:" + this.getName() + " element was found with no value.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        GroupValue.addJson(jsonObject, "groupValue", this.getValue());
        GroupValue.addJson(jsonObject, "id", this.getID());
        GroupValue.addJson(jsonObject, "idReference", this.getIDReference());
        GroupValue.addJson(jsonObject, "qualifier", this.getQualifier());
        GroupValue.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, "groupValue", string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GroupValue.buildHTMLTextOutput(outputFormat, string3, this.getValue()));
        stringBuffer.append(GroupValue.buildHTMLTextOutput(outputFormat, string3 + ".id", this.getID()));
        stringBuffer.append(GroupValue.buildHTMLTextOutput(outputFormat, string3 + ".idReference", this.getIDReference()));
        stringBuffer.append(GroupValue.buildHTMLTextOutput(outputFormat, string3 + ".qualifier", this.getQualifier()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3 + "."));
        return stringBuffer.toString();
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessGroupValue";
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof GroupValue;
    }

    public static class Builder
    extends AbstractNtkString.Builder {
        private static final long serialVersionUID = 7750664735441105296L;

        public Builder() {
        }

        public Builder(GroupValue groupValue) {
            super(groupValue);
        }

        @Override
        public GroupValue commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new GroupValue(this.getValue(), this.getID(), this.getIDReference(), this.getQualifier(), this.getSecurityAttributes().commit());
        }
    }
}

