/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import nu.xom.Element;

public final class Rights
extends AbstractBaseComponent {
    private static final String PRIVACY_ACT_NAME = "privacyAct";
    private static final String INTELLECTUAL_PROPERY_NAME = "intellectualProperty";
    private static final String COPYRIGHT_NAME = "copyright";

    public Rights(Element element) throws InvalidDDMSException {
        super(element);
    }

    public Rights(boolean bl, boolean bl2, boolean bl3) throws InvalidDDMSException {
        Element element = Util.buildDDMSElement(Rights.getName(DDMSVersion.getCurrentVersion()), null);
        Util.addDDMSAttribute(element, PRIVACY_ACT_NAME, Boolean.toString(bl));
        Util.addDDMSAttribute(element, INTELLECTUAL_PROPERY_NAME, Boolean.toString(bl2));
        Util.addDDMSAttribute(element, COPYRIGHT_NAME, Boolean.toString(bl3));
        this.setXOMElement(element, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Rights.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Rights.addJson(jsonObject, PRIVACY_ACT_NAME, this.getPrivacyAct());
        Rights.addJson(jsonObject, INTELLECTUAL_PROPERY_NAME, this.getIntellectualProperty());
        Rights.addJson(jsonObject, COPYRIGHT_NAME, this.getCopyright());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Rights.buildHTMLTextOutput(outputFormat, string3 + PRIVACY_ACT_NAME, String.valueOf(this.getPrivacyAct())));
        stringBuffer.append(Rights.buildHTMLTextOutput(outputFormat, string3 + INTELLECTUAL_PROPERY_NAME, String.valueOf(this.getIntellectualProperty())));
        stringBuffer.append(Rights.buildHTMLTextOutput(outputFormat, string3 + COPYRIGHT_NAME, String.valueOf(this.getCopyright())));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Rights)) {
            return false;
        }
        Rights rights = (Rights)object;
        return this.getPrivacyAct() == rights.getPrivacyAct() && this.getIntellectualProperty() == rights.getIntellectualProperty() && this.getCopyright() == rights.getCopyright();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + Util.booleanHashCode(this.getPrivacyAct());
        n = 7 * n + Util.booleanHashCode(this.getIntellectualProperty());
        n = 7 * n + Util.booleanHashCode(this.getCopyright());
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "rights";
    }

    public boolean getPrivacyAct() {
        return Boolean.valueOf(this.getAttributeValue(PRIVACY_ACT_NAME));
    }

    public boolean getIntellectualProperty() {
        return Boolean.valueOf(this.getAttributeValue(INTELLECTUAL_PROPERY_NAME));
    }

    public boolean getCopyright() {
        return Boolean.valueOf(this.getAttributeValue(COPYRIGHT_NAME));
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -2290965863004046496L;
        private Boolean _privacyAct = null;
        private Boolean _intellectualProperty = null;
        private Boolean _copyright = null;

        public Builder() {
        }

        public Builder(Rights rights) {
            this.setPrivacyAct(rights.getPrivacyAct());
            this.setIntellectualProperty(rights.getIntellectualProperty());
            this.setCopyright(rights.getCopyright());
        }

        @Override
        public Rights commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            boolean bl = this.getPrivacyAct() == null ? false : this.getPrivacyAct();
            boolean bl2 = this.getIntellectualProperty() == null ? false : this.getIntellectualProperty();
            boolean bl3 = this.getCopyright() == null ? false : this.getCopyright();
            return new Rights(bl, bl2, bl3);
        }

        @Override
        public boolean isEmpty() {
            return this.getPrivacyAct() == null && this.getIntellectualProperty() == null && this.getCopyright() == null;
        }

        public Boolean getPrivacyAct() {
            return this._privacyAct;
        }

        public void setPrivacyAct(Boolean bl) {
            this._privacyAct = bl;
        }

        public Boolean getIntellectualProperty() {
            return this._intellectualProperty;
        }

        public void setIntellectualProperty(Boolean bl) {
            this._intellectualProperty = bl;
        }

        public Boolean getCopyright() {
            return this._copyright;
        }

        public void setCopyright(Boolean bl) {
            this._copyright = bl;
        }
    }
}

