/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.resource.ProcessingInfo;
import buri.ddmsence.ddms.resource.RecordsManagementInfo;
import buri.ddmsence.ddms.resource.RevisionRecall;
import buri.ddmsence.ddms.resource.TaskingInfo;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class ResourceManagement
extends AbstractBaseComponent {
    private RecordsManagementInfo _recordsManagementInfo = null;
    private RevisionRecall _revisionRecall = null;
    private List<TaskingInfo> _taskingInfos = null;
    private List<ProcessingInfo> _processingInfos = null;
    private SecurityAttributes _securityAttributes = null;

    public ResourceManagement(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            this.setXOMElement(element, false);
            Element element3 = element.getFirstChildElement(RecordsManagementInfo.getName(this.getDDMSVersion()), this.getNamespace());
            if (element3 != null) {
                this._recordsManagementInfo = new RecordsManagementInfo(element3);
            }
            if ((element2 = element.getFirstChildElement(RevisionRecall.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._revisionRecall = new RevisionRecall(element2);
            }
            this._taskingInfos = new ArrayList<TaskingInfo>();
            Elements elements = element.getChildElements(TaskingInfo.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._taskingInfos.add(new TaskingInfo(elements.get(i)));
            }
            this._processingInfos = new ArrayList<ProcessingInfo>();
            Elements elements2 = element.getChildElements(ProcessingInfo.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements2.size(); ++i) {
                this._processingInfos.add(new ProcessingInfo(elements2.get(i)));
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public ResourceManagement(RecordsManagementInfo recordsManagementInfo, RevisionRecall revisionRecall, List<TaskingInfo> list, List<ProcessingInfo> list2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(ResourceManagement.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            if (recordsManagementInfo != null) {
                element.appendChild((Node)recordsManagementInfo.getXOMElementCopy());
            }
            if (revisionRecall != null) {
                element.appendChild((Node)revisionRecall.getXOMElementCopy());
            }
            for (TaskingInfo abstractBaseComponent : list) {
                element.appendChild((Node)abstractBaseComponent.getXOMElementCopy());
            }
            for (ProcessingInfo processingInfo : list2) {
                element.appendChild((Node)processingInfo.getXOMElementCopy());
            }
            this._recordsManagementInfo = recordsManagementInfo;
            this._revisionRecall = revisionRecall;
            this._taskingInfos = list;
            this._processingInfos = list2;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), ResourceManagement.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        ResourceManagement.addJson(jsonObject, this.getRecordsManagementInfo());
        ResourceManagement.addJson(jsonObject, this.getRevisionRecall());
        ResourceManagement.addJson(jsonObject, "taskingInfo", this.getTaskingInfos());
        ResourceManagement.addJson(jsonObject, "processingInfo", this.getProcessingInfos());
        ResourceManagement.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getRecordsManagementInfo() != null) {
            stringBuffer.append(this.getRecordsManagementInfo().getHTMLTextOutput(outputFormat, string3, ""));
        }
        if (this.getRevisionRecall() != null) {
            stringBuffer.append(this.getRevisionRecall().getHTMLTextOutput(outputFormat, string3, ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3, this.getTaskingInfos()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, string3, this.getProcessingInfos()));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getRecordsManagementInfo());
        arrayList.add(this.getRevisionRecall());
        arrayList.addAll(this.getTaskingInfos());
        arrayList.addAll(this.getProcessingInfos());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof ResourceManagement;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "resourceManagement";
    }

    public RecordsManagementInfo getRecordsManagementInfo() {
        return this._recordsManagementInfo;
    }

    public RevisionRecall getRevisionRecall() {
        return this._revisionRecall;
    }

    public List<TaskingInfo> getTaskingInfos() {
        return Collections.unmodifiableList(this._taskingInfos);
    }

    public List<ProcessingInfo> getProcessingInfos() {
        return Collections.unmodifiableList(this._processingInfos);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private RecordsManagementInfo.Builder _recordsManagementInfo;
        private RevisionRecall.Builder _revisionRecall;
        private List<TaskingInfo.Builder> _taskingInfos;
        private List<ProcessingInfo.Builder> _processingInfos;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(ResourceManagement resourceManagement) {
            if (resourceManagement.getRecordsManagementInfo() != null) {
                this.setRecordsManagementInfo(new RecordsManagementInfo.Builder(resourceManagement.getRecordsManagementInfo()));
            }
            if (resourceManagement.getRevisionRecall() != null) {
                this.setRevisionRecall(new RevisionRecall.Builder(resourceManagement.getRevisionRecall()));
            }
            for (TaskingInfo abstractBaseComponent : resourceManagement.getTaskingInfos()) {
                this.getTaskingInfos().add(new TaskingInfo.Builder(abstractBaseComponent));
            }
            for (ProcessingInfo processingInfo : resourceManagement.getProcessingInfos()) {
                this.getProcessingInfos().add(new ProcessingInfo.Builder(processingInfo));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(resourceManagement.getSecurityAttributes()));
        }

        @Override
        public ResourceManagement commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<TaskingInfo> arrayList = new ArrayList<TaskingInfo>();
            for (TaskingInfo.Builder object : this.getTaskingInfos()) {
                TaskingInfo taskingInfo = object.commit();
                if (taskingInfo == null) continue;
                arrayList.add(taskingInfo);
            }
            ArrayList arrayList2 = new ArrayList();
            for (ProcessingInfo.Builder builder : this.getProcessingInfos()) {
                ProcessingInfo processingInfo = builder.commit();
                if (processingInfo == null) continue;
                arrayList2.add(processingInfo);
            }
            return new ResourceManagement(this.getRecordsManagementInfo().commit(), this.getRevisionRecall().commit(), arrayList, arrayList2, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getProcessingInfos()) {
                bl = bl || !iBuilder.isEmpty();
            }
            for (IBuilder iBuilder : this.getTaskingInfos()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getRecordsManagementInfo().isEmpty() && this.getRevisionRecall().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public RecordsManagementInfo.Builder getRecordsManagementInfo() {
            if (this._recordsManagementInfo == null) {
                this._recordsManagementInfo = new RecordsManagementInfo.Builder();
            }
            return this._recordsManagementInfo;
        }

        public void setRecordsManagementInfo(RecordsManagementInfo.Builder builder) {
            this._recordsManagementInfo = builder;
        }

        public RevisionRecall.Builder getRevisionRecall() {
            if (this._revisionRecall == null) {
                this._revisionRecall = new RevisionRecall.Builder();
            }
            return this._revisionRecall;
        }

        public void setRevisionRecall(RevisionRecall.Builder builder) {
            this._revisionRecall = builder;
        }

        public List<TaskingInfo.Builder> getTaskingInfos() {
            if (this._taskingInfos == null) {
                this._taskingInfos = new LazyList(TaskingInfo.Builder.class);
            }
            return this._taskingInfos;
        }

        public List<ProcessingInfo.Builder> getProcessingInfos() {
            if (this._processingInfos == null) {
                this._processingInfos = new LazyList(ProcessingInfo.Builder.class);
            }
            return this._processingInfos;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

