/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.ddms.ValidationMessage;
import buri.ddmsence.ddms.extensible.ExtensibleElement;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;

public abstract class AbstractBaseComponent
implements IDDMSComponent {
    private List<ValidationMessage> _warnings = null;
    private Element _element = null;
    public static final Map<OutputFormat, String> OUTPUT_TEMPLATES = new HashMap<OutputFormat, String>();

    protected AbstractBaseComponent() throws InvalidDDMSException {
    }

    protected AbstractBaseComponent(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    public String getPrefix() {
        return this.getXOMElement() == null ? "" : this.getXOMElement().getNamespacePrefix();
    }

    @Override
    public String getName() {
        return this.getXOMElement() == null ? "" : this.getXOMElement().getLocalName();
    }

    @Override
    public String getNamespace() {
        return this.getXOMElement() == null ? "" : this.getXOMElement().getNamespaceURI();
    }

    @Override
    public String getQualifiedName() {
        return this.getXOMElement() == null ? "" : this.getXOMElement().getQualifiedName();
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return null;
    }

    @Override
    public List<ValidationMessage> getValidationWarnings() {
        return Collections.unmodifiableList(this.getWarnings());
    }

    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSValue("name", this.getName());
        for (IDDMSComponent iDDMSComponent : this.getNestedComponents()) {
            if (iDDMSComponent instanceof ExtensibleElement || iDDMSComponent == null) continue;
            Util.requireCompatibleVersion(this, iDDMSComponent);
        }
        this.validateWarnings();
    }

    protected void validateWarnings() {
        for (IDDMSComponent iDDMSComponent : this.getNestedComponents()) {
            if (iDDMSComponent == null) continue;
            this.addWarnings(iDDMSComponent.getValidationWarnings(), false);
        }
        if (this.getSecurityAttributes() != null) {
            this.addWarnings(this.getSecurityAttributes().getValidationWarnings(), true);
        }
    }

    protected void addDdms40Warning(String string) {
        this.addWarning("The " + string + " in this DDMS component was introduced in DDMS 4.1, and will prevent this XML instance" + " from being understood by DDMS 4.0.1 systems.");
    }

    @Override
    public String toHTML() {
        return this.getHTMLTextOutput(OutputFormat.HTML, "", "");
    }

    @Override
    public String toJSON() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (Boolean.valueOf(PropertyReader.getProperty("output.json.prettyPrint")).booleanValue()) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create().toJson((JsonElement)this.getJSONObject());
    }

    @Override
    public String toText() {
        return this.getHTMLTextOutput(OutputFormat.TEXT, "", "");
    }

    public abstract JsonObject getJSONObject();

    protected static void addJson(JsonObject jsonObject, String string, Object object) {
        Util.addNonEmptyJsonProperty(jsonObject, Util.decapitalize(string), object);
    }

    protected static void addJson(JsonObject jsonObject, String string, List<?> list) {
        Util.addNonEmptyJsonProperty(jsonObject, Util.decapitalize(string), Util.getJSONArray(list));
    }

    protected static void addJson(JsonObject jsonObject, AbstractAttributeGroup abstractAttributeGroup) {
        AbstractBaseComponent.addJson(jsonObject, abstractAttributeGroup.getName(), abstractAttributeGroup);
    }

    protected static void addJson(JsonObject jsonObject, AbstractBaseComponent abstractBaseComponent) {
        if (abstractBaseComponent != null) {
            AbstractBaseComponent.addJson(jsonObject, abstractBaseComponent.getName(), abstractBaseComponent.getJSONObject());
        }
    }

    public abstract String getHTMLTextOutput(OutputFormat var1, String var2, String var3);

    protected List<IDDMSComponent> getNestedComponents() {
        return Collections.EMPTY_LIST;
    }

    public static String buildHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        boolean bl;
        Util.requireHTMLText(outputFormat);
        if (Util.isEmpty(string2)) {
            return "";
        }
        boolean bl2 = bl = outputFormat == OutputFormat.HTML;
        if (bl) {
            string = Util.xmlEscape(string);
            string2 = Util.xmlEscape(string2);
        }
        return String.format((String)Resource.OUTPUT_TEMPLATES.get((Object)outputFormat), string, string2);
    }

    protected String buildHTMLTextOutput(OutputFormat outputFormat, String string, List<?> list) {
        Util.requireHTMLText(outputFormat);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof AbstractBaseComponent) {
                AbstractBaseComponent abstractBaseComponent = (AbstractBaseComponent)obj;
                stringBuffer.append(abstractBaseComponent.getHTMLTextOutput(outputFormat, string, this.buildIndex(i, list.size())));
                continue;
            }
            if (obj instanceof String) {
                stringBuffer.append(AbstractBaseComponent.buildHTMLTextOutput(outputFormat, string + this.buildIndex(i, list.size()), (String)obj));
                continue;
            }
            stringBuffer.append(AbstractBaseComponent.buildHTMLTextOutput(outputFormat, string + this.buildIndex(i, list.size()), String.valueOf(obj)));
        }
        return stringBuffer.toString();
    }

    protected String buildPrefix(String string, String string2, String string3) {
        return Util.getNonNullString(string) + Util.getNonNullString(string2) + Util.getNonNullString(string3);
    }

    protected String buildIndex(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The total must be at least 1.");
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("The index is not properly bounded between 0 and " + (n2 - 1));
        }
        String string = PropertyReader.getProperty("output.indexLevel");
        if ("2".equals(string)) {
            return "[" + (n + 1) + "]";
        }
        if ("1".equals(string) && n2 > 1) {
            return "[" + (n + 1) + "]";
        }
        return "";
    }

    @Override
    public String toXML() {
        return this.getXOMElement() == null ? "" : this.getXOMElement().toXML();
    }

    protected String getAttributeValue(String string) {
        return this.getAttributeValue(string, this.getNamespace());
    }

    protected String getAttributeValue(String string, String string2) {
        Util.requireValue("name", string);
        String string3 = this.getXOMElement().getAttributeValue(string, Util.getNonNullString(string2));
        return Util.getNonNullString(string3);
    }

    protected Element getChild(String string) {
        Util.requireValue("name", string);
        return this.getXOMElement().getFirstChildElement(string, this.getNamespace());
    }

    protected static Double getChildTextAsDouble(Element element, String string) {
        Util.requireValue("element", element);
        Util.requireValue("name", string);
        Element element2 = element.getFirstChildElement(string, element.getNamespaceURI());
        if (element2 == null) {
            return null;
        }
        return Double.valueOf(element2.getValue());
    }

    protected void requireAtLeastVersion(String string) throws InvalidDDMSException {
        if (!this.getDDMSVersion().isAtLeast(string)) {
            throw new InvalidDDMSException("The " + this.getName() + " element must not be used until DDMS " + string + " or later.");
        }
    }

    protected void requireAtMostVersion(String string) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionFor(string);
        if (!dDMSVersion.isAtLeast(this.getDDMSVersion().getVersion())) {
            throw new InvalidDDMSException("The " + this.getName() + " element must not be used after DDMS " + string + ".");
        }
    }

    protected DDMSVersion getDDMSVersion() {
        return DDMSVersion.getVersionForNamespace(this.getNamespace());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractBaseComponent) || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBaseComponent abstractBaseComponent = (AbstractBaseComponent)object;
        return this.getName().equals(abstractBaseComponent.getName()) && this.getNamespace().equals(abstractBaseComponent.getNamespace()) && Util.listEquals(this.getNestedComponents(), abstractBaseComponent.getNestedComponents()) && Util.nullEquals(this.getSecurityAttributes(), abstractBaseComponent.getSecurityAttributes());
    }

    public int hashCode() {
        int n = this.getName().hashCode();
        n = 7 * n + this.getNamespace().hashCode();
        for (IDDMSComponent iDDMSComponent : this.getNestedComponents()) {
            if (iDDMSComponent == null) continue;
            n = 7 * n + iDDMSComponent.hashCode();
        }
        if (this.getSecurityAttributes() != null) {
            n = 7 * n + this.getSecurityAttributes().hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toXML();
    }

    protected String getLocatorSuffix() {
        return "";
    }

    protected void addWarning(String string) {
        this.getWarnings().add(ValidationMessage.newWarning(string, this.getQualifiedName() + this.getLocatorSuffix()));
    }

    protected void addWarnings(List<ValidationMessage> list, boolean bl) {
        for (ValidationMessage validationMessage : list) {
            String string = this.getQualifiedName() + (bl ? "" : this.getLocatorSuffix()) + validationMessage.getLocator();
            this.getWarnings().add(ValidationMessage.newWarning(validationMessage.getText(), string));
        }
    }

    private List<ValidationMessage> getWarnings() {
        if (this._warnings == null) {
            this._warnings = new ArrayList<ValidationMessage>();
        }
        return this._warnings;
    }

    protected Element getXOMElement() {
        return this._element;
    }

    @Override
    public Element getXOMElementCopy() {
        return new Element(this._element);
    }

    protected void setXOMElement(Element element, boolean bl) throws InvalidDDMSException {
        Util.requireDDMSValue("XOM Element", element);
        this._element = element;
        if (bl) {
            this.validate();
        }
    }

    static {
        OUTPUT_TEMPLATES.put(OutputFormat.HTML, "<meta name=\"%s\" content=\"%s\" />\n");
        OUTPUT_TEMPLATES.put(OutputFormat.TEXT, "%s: %s\n");
    }
}

