/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.util;

import buri.ddmsence.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyReader {
    private Properties _properties = new Properties();
    private static final String PROPERTIES_FILE = "ddmsence.properties";
    private static final String PROPERTIES_PREFIX = "buri.ddmsence.";
    private static final String UNDEFINED_PROPERTY = "Undefined Property: ";
    private static final Set<String> CUSTOM_PROPERTIES = new HashSet<String>();
    private static final PropertyReader INSTANCE;

    private PropertyReader() {
        InputStream inputStream = PropertyReader.getLoader().getResourceAsStream(PROPERTIES_FILE);
        try {
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                inputStream.close();
                this._properties.putAll((Map<?, ?>)properties);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not load the properties file: " + iOException.getMessage());
        }
    }

    public static String getPrefix(String string) {
        return PropertyReader.getProperty(string + ".prefix");
    }

    public static String getProperty(String string) {
        String string2 = INSTANCE.getProperties().getProperty(PROPERTIES_PREFIX + string);
        if (string2 == null) {
            throw new IllegalArgumentException("Undefined Property: buri.ddmsence." + string);
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        if (!CUSTOM_PROPERTIES.contains(string)) {
            throw new IllegalArgumentException(string + " is not a configurable property.");
        }
        INSTANCE.getProperties().setProperty(PROPERTIES_PREFIX + string, Util.getNonNullString(string2).trim());
    }

    public static List<String> getListProperty(String string) {
        String string2 = PropertyReader.getProperty(string);
        String[] stringArray = string2.split(",");
        List<String> list = Arrays.asList(stringArray);
        return Collections.unmodifiableList(list);
    }

    private static ClassLoader getLoader() {
        return new FindClassLoader().getClass().getClassLoader();
    }

    private Properties getProperties() {
        return this._properties;
    }

    static {
        CUSTOM_PROPERTIES.add("ddms.prefix");
        CUSTOM_PROPERTIES.add("gml.prefix");
        CUSTOM_PROPERTIES.add("ism.prefix");
        CUSTOM_PROPERTIES.add("ntk.prefix");
        CUSTOM_PROPERTIES.add("output.json.inlineAttributes");
        CUSTOM_PROPERTIES.add("output.json.prettyPrint");
        CUSTOM_PROPERTIES.add("output.indexLevel");
        CUSTOM_PROPERTIES.add("sample.data");
        CUSTOM_PROPERTIES.add("tspi.prefix");
        CUSTOM_PROPERTIES.add("virt.prefix");
        CUSTOM_PROPERTIES.add("xlink.prefix");
        CUSTOM_PROPERTIES.add("xml.transform.TransformerFactory");
        INSTANCE = new PropertyReader();
    }

    private static class FindClassLoader {
    }
}

