/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.resource.Organization;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public class RecordKeeper
extends AbstractBaseComponent {
    private Organization _organization = null;
    private static final String RECORD_KEEPER_ID_NAME = "recordKeeperID";

    public RecordKeeper(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            Util.requireDDMSValue("element", element);
            if (element.getChildElements().size() > 1 && (element2 = element.getChildElements().get(1)) != null) {
                this._organization = new Organization(element2);
            }
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public RecordKeeper(String string, Organization organization) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(RecordKeeper.getName(DDMSVersion.getCurrentVersion()), null);
            if (!Util.isEmpty(string)) {
                element.appendChild((Node)Util.buildDDMSElement(RECORD_KEEPER_ID_NAME, string));
            }
            if (organization != null) {
                element.appendChild((Node)organization.getXOMElementCopy());
            }
            this._organization = organization;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), RecordKeeper.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("record keeper ID", this.getRecordKeeperID());
        Util.requireDDMSValue("organization", this.getOrganization());
        super.validate();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof RecordKeeper)) {
            return false;
        }
        RecordKeeper recordKeeper = (RecordKeeper)object;
        return this.getRecordKeeperID().equals(recordKeeper.getRecordKeeperID());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getRecordKeeperID().hashCode();
        return n;
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        RecordKeeper.addJson(jsonObject, RECORD_KEEPER_ID_NAME, this.getRecordKeeperID());
        RecordKeeper.addJson(jsonObject, this.getOrganization());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RecordKeeper.buildHTMLTextOutput(outputFormat, string3 + RECORD_KEEPER_ID_NAME, this.getRecordKeeperID()));
        stringBuffer.append(this.getOrganization().getHTMLTextOutput(outputFormat, string3, ""));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getOrganization());
        return arrayList;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "recordKeeper";
    }

    public String getRecordKeeperID() {
        return Util.getFirstDDMSChildValue(this.getXOMElement(), RECORD_KEEPER_ID_NAME);
    }

    public Organization getOrganization() {
        return this._organization;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4565840434345629470L;
        private String _recordKeeperID;
        private Organization.Builder _organization;

        public Builder() {
        }

        public Builder(RecordKeeper recordKeeper) {
            this.setRecordKeeperID(recordKeeper.getRecordKeeperID());
            this.setOrganization(new Organization.Builder(recordKeeper.getOrganization()));
        }

        @Override
        public RecordKeeper commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new RecordKeeper(this.getRecordKeeperID(), this.getOrganization().commit());
        }

        @Override
        public boolean isEmpty() {
            return this.getOrganization().isEmpty() && Util.isEmpty(this.getRecordKeeperID());
        }

        public String getRecordKeeperID() {
            return this._recordKeeperID;
        }

        public void setRecordKeeperID(String string) {
            this._recordKeeperID = string;
        }

        public Organization.Builder getOrganization() {
            if (this._organization == null) {
                this._organization = new Organization.Builder();
            }
            return this._organization;
        }

        public void setOrganization(Organization.Builder builder) {
            this._organization = builder;
        }
    }
}

