/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import nu.xom.Element;

public final class Language
extends AbstractQualifierValue {
    public Language(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public Language(String string, String string2) throws InvalidDDMSException {
        super(Language.getName(DDMSVersion.getCurrentVersion()), string, string2, true, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Language.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getValue())) {
            Util.requireDDMSValue("qualifier attribute", this.getQualifier());
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("A qualifier has been set without an accompanying value attribute.");
        }
        if (Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("Neither a qualifier nor a value was set on this language.");
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Language.addJson(jsonObject, this.getQualifierName(), this.getQualifier());
        Language.addJson(jsonObject, this.getValueName(), this.getValue());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Language.buildHTMLTextOutput(outputFormat, string3 + this.getQualifierName(), this.getQualifier()));
        stringBuffer.append(Language.buildHTMLTextOutput(outputFormat, string3 + this.getValueName(), this.getValue()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Language;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "language";
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = -6370530125138751078L;

        public Builder() {
        }

        public Builder(Language language) {
            super(language);
        }

        @Override
        public Language commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Language(this.getQualifier(), this.getValue());
        }
    }
}

