/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import nu.xom.Element;

public final class Identifier
extends AbstractQualifierValue {
    public Identifier(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public Identifier(String string, String string2) throws InvalidDDMSException {
        super(Identifier.getName(DDMSVersion.getCurrentVersion()), string, string2, true, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Identifier.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("qualifier attribute", this.getQualifier());
        Util.requireDDMSValidURI(this.getQualifier());
        Util.requireDDMSValue("value attribute", this.getValue());
        super.validate();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Identifier.addJson(jsonObject, this.getQualifierName(), this.getQualifier());
        Identifier.addJson(jsonObject, this.getValueName(), this.getValue());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Identifier.buildHTMLTextOutput(outputFormat, string3 + this.getQualifierName(), this.getQualifier()));
        stringBuffer.append(Identifier.buildHTMLTextOutput(outputFormat, string3 + this.getValueName(), this.getValue()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Identifier;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "identifier";
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = -1105410940799401080L;

        public Builder() {
        }

        public Builder(Identifier identifier) {
            super(identifier);
        }

        @Override
        public Identifier commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Identifier(this.getQualifier(), this.getValue());
        }
    }
}

