/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.ValidationMessage;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.ddms.extensible.ExtensibleElement;
import buri.ddmsence.ddms.format.Format;
import buri.ddmsence.ddms.metacard.MetacardInfo;
import buri.ddmsence.ddms.resource.Contributor;
import buri.ddmsence.ddms.resource.Creator;
import buri.ddmsence.ddms.resource.Dates;
import buri.ddmsence.ddms.resource.Identifier;
import buri.ddmsence.ddms.resource.Language;
import buri.ddmsence.ddms.resource.PointOfContact;
import buri.ddmsence.ddms.resource.Publisher;
import buri.ddmsence.ddms.resource.ResourceManagement;
import buri.ddmsence.ddms.resource.Rights;
import buri.ddmsence.ddms.resource.Source;
import buri.ddmsence.ddms.resource.Subtitle;
import buri.ddmsence.ddms.resource.Title;
import buri.ddmsence.ddms.resource.Type;
import buri.ddmsence.ddms.security.Security;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.ddms.security.ism.NoticeAttributes;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Description;
import buri.ddmsence.ddms.summary.GeospatialCoverage;
import buri.ddmsence.ddms.summary.NonStateActor;
import buri.ddmsence.ddms.summary.RelatedResource;
import buri.ddmsence.ddms.summary.SubjectCoverage;
import buri.ddmsence.ddms.summary.TemporalCoverage;
import buri.ddmsence.ddms.summary.VirtualCoverage;
import buri.ddmsence.util.DDMSReader;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;

public final class Resource
extends AbstractBaseComponent {
    private MetacardInfo _metacardInfo = null;
    private List<Identifier> _identifiers = new ArrayList<Identifier>();
    private List<Title> _titles = new ArrayList<Title>();
    private List<Subtitle> _subtitles = new ArrayList<Subtitle>();
    private Description _description = null;
    private List<Language> _languages = new ArrayList<Language>();
    private Dates _dates = null;
    private Rights _rights = null;
    private List<Source> _sources = new ArrayList<Source>();
    private List<Type> _types = new ArrayList<Type>();
    private List<Creator> _creators = new ArrayList<Creator>();
    private List<Publisher> _publishers = new ArrayList<Publisher>();
    private List<Contributor> _contributors = new ArrayList<Contributor>();
    private List<PointOfContact> _pointOfContacts = new ArrayList<PointOfContact>();
    private Format _format = null;
    private List<SubjectCoverage> _subjectCoverages = new ArrayList<SubjectCoverage>();
    private List<VirtualCoverage> _virtualCoverages = new ArrayList<VirtualCoverage>();
    private List<TemporalCoverage> _temporalCoverages = new ArrayList<TemporalCoverage>();
    private List<GeospatialCoverage> geospatialCoverages = new ArrayList<GeospatialCoverage>();
    private List<RelatedResource> _relatedResources = new ArrayList<RelatedResource>();
    private ResourceManagement _resourceManagement = null;
    private Security _security = null;
    private List<ExtensibleElement> _extensibleElements = new ArrayList<ExtensibleElement>();
    private List<IDDMSComponent> _orderedList = new ArrayList<IDDMSComponent>();
    private XMLGregorianCalendar _createDate = null;
    List<String> _compliesWiths = null;
    private Integer _ismDESVersion = null;
    private Integer _ntkDESVersion = null;
    private NoticeAttributes _noticeAttributes = null;
    private SecurityAttributes _securityAttributes = null;
    private ExtensibleAttributes _extensibleAttributes = null;
    protected static final String RESOURCE_ELEMENT_NAME = "resourceElement";
    protected static final String CREATE_DATE_NAME = "createDate";
    public static final String COMPLIES_WITH_NAME = "compliesWith";
    public static final String DES_VERSION_NAME = "DESVersion";
    private static final Set<String> ALL_IC_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> NON_EXTENSIBLE_NAMES;

    public Resource(Element element) throws InvalidDDMSException {
        try {
            int n;
            Object object;
            this.setXOMElement(element, false);
            String string = element.getNamespaceURI();
            String string2 = this.getDDMSVersion().getIsmNamespace();
            String string3 = this.getAttributeValue(CREATE_DATE_NAME, string2);
            if (!Util.isEmpty(string3)) {
                this._createDate = Resource.getFactory().newXMLGregorianCalendar(string3);
            }
            String string4 = this.getDDMSVersion().isAtLeast("5.0") ? this.getNamespace() : string2;
            this._compliesWiths = Util.getXsListAsList(this.getAttributeValue(COMPLIES_WITH_NAME, string4));
            String string5 = element.getAttributeValue(DES_VERSION_NAME, string2);
            if (!Util.isEmpty(string5)) {
                this._ismDESVersion = Integer.valueOf(string5);
            }
            if (this.getDDMSVersion().isAtLeast("4.0.1") && !Util.isEmpty((String)(object = element.getAttributeValue(DES_VERSION_NAME, this.getDDMSVersion().getNtkNamespace())))) {
                this._ntkDESVersion = Integer.valueOf((String)object);
            }
            this._noticeAttributes = new NoticeAttributes(element);
            this._securityAttributes = new SecurityAttributes(element);
            this._extensibleAttributes = new ExtensibleAttributes(element);
            object = this.getDDMSVersion();
            Element element2 = this.getChild(MetacardInfo.getName((DDMSVersion)object));
            if (element2 != null) {
                this._metacardInfo = new MetacardInfo(element2);
            }
            Elements elements = element.getChildElements(Identifier.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._identifiers.add(new Identifier(elements.get(n)));
            }
            elements = element.getChildElements(Title.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._titles.add(new Title(elements.get(n)));
            }
            elements = element.getChildElements(Subtitle.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._subtitles.add(new Subtitle(elements.get(n)));
            }
            element2 = this.getChild(Description.getName((DDMSVersion)object));
            if (element2 != null) {
                this._description = new Description(element2);
            }
            elements = element.getChildElements(Language.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._languages.add(new Language(elements.get(n)));
            }
            element2 = this.getChild(Dates.getName((DDMSVersion)object));
            if (element2 != null) {
                this._dates = new Dates(element2);
            }
            if ((element2 = this.getChild(Rights.getName((DDMSVersion)object))) != null) {
                this._rights = new Rights(element2);
            }
            elements = element.getChildElements(Source.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._sources.add(new Source(elements.get(n)));
            }
            elements = element.getChildElements(Type.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._types.add(new Type(elements.get(n)));
            }
            elements = element.getChildElements(Creator.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._creators.add(new Creator(elements.get(n)));
            }
            elements = element.getChildElements(Publisher.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._publishers.add(new Publisher(elements.get(n)));
            }
            elements = element.getChildElements(Contributor.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._contributors.add(new Contributor(elements.get(n)));
            }
            elements = element.getChildElements(PointOfContact.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._pointOfContacts.add(new PointOfContact(elements.get(n)));
            }
            element2 = this.getChild(Format.getName((DDMSVersion)object));
            if (element2 != null) {
                this._format = new Format(element2);
            }
            elements = element.getChildElements(SubjectCoverage.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._subjectCoverages.add(new SubjectCoverage(elements.get(n)));
            }
            elements = element.getChildElements(VirtualCoverage.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._virtualCoverages.add(new VirtualCoverage(elements.get(n)));
            }
            elements = element.getChildElements(TemporalCoverage.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this._temporalCoverages.add(new TemporalCoverage(elements.get(n)));
            }
            elements = element.getChildElements(GeospatialCoverage.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this.geospatialCoverages.add(new GeospatialCoverage(elements.get(n)));
            }
            elements = element.getChildElements(RelatedResource.getName((DDMSVersion)object), string);
            for (n = 0; n < elements.size(); ++n) {
                this.loadRelatedResource(elements.get(n));
            }
            element2 = this.getChild(ResourceManagement.getName((DDMSVersion)object));
            if (element2 != null) {
                this._resourceManagement = new ResourceManagement(element2);
            }
            if ((element2 = this.getChild(Security.getName((DDMSVersion)object))) != null) {
                this._security = new Security(element2);
                n = 0;
                Elements elements2 = element.getChildElements();
                while (elements2.get(n) != element2) {
                    ++n;
                }
                for (int i = n + 1; i < elements2.size(); ++i) {
                    this._extensibleElements.add(new ExtensibleElement(elements2.get(i)));
                }
            }
            this.populatedOrderedList();
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    private void loadRelatedResource(Element element) throws InvalidDDMSException {
        Elements elements = element.getChildElements("RelatedResource", this.getNamespace());
        if (elements.size() <= 1) {
            this._relatedResources.add(new RelatedResource(element));
        } else {
            for (int i = 0; i < elements.size(); ++i) {
                Element element2 = new Element(element);
                element2.removeChildren();
                element2.appendChild((Node)new Element(elements.get(i)));
                this._relatedResources.add(new RelatedResource(element2));
            }
        }
    }

    public Resource(List<IDDMSComponent> list, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        this(list, null, null, null, null, null, null, null, extensibleAttributes);
    }

    public Resource(List<IDDMSComponent> list, Boolean bl, String string, Integer n, SecurityAttributes securityAttributes, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        this(list, bl, string, null, n, null, securityAttributes, null, extensibleAttributes);
    }

    public Resource(List<IDDMSComponent> list, Boolean bl, String string, List<String> list2, Integer n, SecurityAttributes securityAttributes, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        this(list, bl, string, list2, n, null, securityAttributes, null, extensibleAttributes);
    }

    public Resource(List<IDDMSComponent> list, Boolean bl, String string, List<String> list2, Integer n, Integer n2, SecurityAttributes securityAttributes, NoticeAttributes noticeAttributes, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            String string2 = PropertyReader.getPrefix("ism");
            String string3 = dDMSVersion.getIsmNamespace();
            String string4 = PropertyReader.getPrefix("ntk");
            String string5 = dDMSVersion.getNtkNamespace();
            String string6 = PropertyReader.getPrefix("virt");
            String string7 = dDMSVersion.getVirtNamespace();
            Element element = Util.buildDDMSElement(Resource.getName(dDMSVersion), null);
            if (!Util.isEmpty(string5)) {
                element.addNamespaceDeclaration(string4, string5);
            }
            element.addNamespaceDeclaration(string2, string3);
            if (!Util.isEmpty(string7)) {
                element.addNamespaceDeclaration(string6, string7);
            }
            this._compliesWiths = list2;
            if (!list2.isEmpty()) {
                if (dDMSVersion.isAtLeast("5.0")) {
                    Util.addDDMSAttribute(element, COMPLIES_WITH_NAME, Util.getXsList(list2));
                } else {
                    Util.addAttribute(element, string2, COMPLIES_WITH_NAME, string3, Util.getXsList(list2));
                }
            }
            if (n2 != null) {
                this._ntkDESVersion = n2;
                Util.addAttribute(element, string4, DES_VERSION_NAME, string5, n2.toString());
            }
            if (bl != null) {
                Util.addAttribute(element, string2, RESOURCE_ELEMENT_NAME, string3, String.valueOf(bl));
            }
            if (n != null) {
                this._ismDESVersion = n;
                Util.addAttribute(element, string2, DES_VERSION_NAME, string3, n.toString());
            }
            if (!Util.isEmpty(string)) {
                try {
                    this._createDate = Resource.getFactory().newXMLGregorianCalendar(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidDDMSException("The ism:createDate attribute must adhere to a valid date format.");
                }
                Util.addAttribute(element, string2, CREATE_DATE_NAME, dDMSVersion.getIsmNamespace(), this.getCreateDate().toXMLFormat());
            }
            this._noticeAttributes = NoticeAttributes.getNonNullInstance(noticeAttributes);
            this._noticeAttributes.addTo(element);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this._extensibleAttributes = ExtensibleAttributes.getNonNullInstance(extensibleAttributes);
            this._extensibleAttributes.addTo(element);
            for (IDDMSComponent iDDMSComponent : list) {
                if (iDDMSComponent == null) continue;
                if (iDDMSComponent instanceof MetacardInfo) {
                    this._metacardInfo = (MetacardInfo)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Identifier) {
                    this._identifiers.add((Identifier)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Title) {
                    this._titles.add((Title)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Subtitle) {
                    this._subtitles.add((Subtitle)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Description) {
                    this._description = (Description)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Language) {
                    this._languages.add((Language)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Dates) {
                    this._dates = (Dates)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Rights) {
                    this._rights = (Rights)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Source) {
                    this._sources.add((Source)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Type) {
                    this._types.add((Type)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Creator) {
                    this._creators.add((Creator)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Publisher) {
                    this._publishers.add((Publisher)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Contributor) {
                    this._contributors.add((Contributor)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof PointOfContact) {
                    this._pointOfContacts.add((PointOfContact)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Format) {
                    this._format = (Format)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof SubjectCoverage) {
                    this._subjectCoverages.add((SubjectCoverage)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof VirtualCoverage) {
                    this._virtualCoverages.add((VirtualCoverage)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof TemporalCoverage) {
                    this._temporalCoverages.add((TemporalCoverage)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof GeospatialCoverage) {
                    this.geospatialCoverages.add((GeospatialCoverage)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof RelatedResource) {
                    this._relatedResources.add((RelatedResource)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof ResourceManagement) {
                    this._resourceManagement = (ResourceManagement)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Security) {
                    this._security = (Security)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof ExtensibleElement) {
                    this._extensibleElements.add((ExtensibleElement)iDDMSComponent);
                    continue;
                }
                throw new InvalidDDMSException(iDDMSComponent.getName() + " is not a valid top-level component in a resource.");
            }
            this.populatedOrderedList();
            for (IDDMSComponent iDDMSComponent : this.getTopLevelComponents()) {
                element.appendChild((Node)iDDMSComponent.getXOMElementCopy());
            }
            this.setXOMElement(element, true);
            DDMSReader.validateWithSchema(dDMSVersion, this.toXML());
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    private void populatedOrderedList() {
        if (this.getMetacardInfo() != null) {
            this._orderedList.add(this.getMetacardInfo());
        }
        this._orderedList.addAll(this.getIdentifiers());
        this._orderedList.addAll(this.getTitles());
        this._orderedList.addAll(this.getSubtitles());
        if (this.getDescription() != null) {
            this._orderedList.add(this.getDescription());
        }
        this._orderedList.addAll(this.getLanguages());
        if (this.getDates() != null) {
            this._orderedList.add(this.getDates());
        }
        if (this.getRights() != null) {
            this._orderedList.add(this.getRights());
        }
        this._orderedList.addAll(this.getSources());
        this._orderedList.addAll(this.getTypes());
        this._orderedList.addAll(this.getCreators());
        this._orderedList.addAll(this.getPublishers());
        this._orderedList.addAll(this.getContributors());
        this._orderedList.addAll(this.getPointOfContacts());
        if (this.getFormat() != null) {
            this._orderedList.add(this.getFormat());
        }
        this._orderedList.addAll(this.getSubjectCoverages());
        this._orderedList.addAll(this.getVirtualCoverages());
        this._orderedList.addAll(this.getTemporalCoverages());
        this._orderedList.addAll(this.getGeospatialCoverages());
        this._orderedList.addAll(this.getRelatedResources());
        if (this.getResourceManagement() != null) {
            this._orderedList.add(this.getResourceManagement());
        }
        if (this.getSecurity() != null) {
            this._orderedList.add(this.getSecurity());
        }
        this._orderedList.addAll(this.getExtensibleElements());
    }

    public List<ValidationMessage> validateWithSchematron(File file) throws XSLException, IOException {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        XSLTransform xSLTransform = Util.buildSchematronTransform(file);
        Nodes nodes = xSLTransform.transform(new Document(this.getXOMElementCopy()));
        Document document = XSLTransform.toDocument((Nodes)nodes);
        XPathContext xPathContext = XPathContext.makeNamespaceContext((Element)document.getRootElement());
        String string = xPathContext.lookup("svrl");
        Nodes nodes2 = document.query("//svrl:failed-assert | //svrl:successful-report", xPathContext);
        for (int i = 0; i < nodes2.size(); ++i) {
            if (!(nodes2.get(i) instanceof Element)) continue;
            Element element = (Element)nodes2.get(i);
            boolean bl = "failed-assert".equals(element.getLocalName());
            String string2 = element.getFirstChildElement("text", string).getValue();
            String string3 = element.getAttributeValue("location");
            arrayList.add(bl ? ValidationMessage.newError(string2, string3) : ValidationMessage.newWarning(string2, string3));
        }
        return arrayList;
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        boolean bl = this.getDDMSVersion().isAtLeast("3.0");
        boolean bl2 = this.getDDMSVersion().isAtLeast("4.0.1");
        boolean bl3 = this.getDDMSVersion().isAtLeast("5.0");
        Util.requireDDMSQName(this.getXOMElement(), Resource.getName(this.getDDMSVersion()));
        if (this.getDDMSVersion().isAtLeast("4.0.1")) {
            Util.requireBoundedChildCount(this.getXOMElement(), MetacardInfo.getName(this.getDDMSVersion()), 1, 1);
        }
        if (this.getIdentifiers().size() < 1) {
            throw new InvalidDDMSException("At least 1 identifier must exist.");
        }
        if (this.getTitles().size() < 1) {
            throw new InvalidDDMSException("At least 1 title must exist.");
        }
        if (this.getCreators().size() + this.getContributors().size() + this.getPublishers().size() + this.getPointOfContacts().size() == 0) {
            throw new InvalidDDMSException("At least 1 producer (creator, contributor, publisher, or pointOfContact) must exist.");
        }
        Util.requireBoundedChildCount(this.getXOMElement(), Description.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Dates.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Rights.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Format.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), ResourceManagement.getName(this.getDDMSVersion()), 0, 1);
        if (bl2) {
            if (this.getSubjectCoverages().size() < 1) {
                throw new InvalidDDMSException("At least 1 subjectCoverage must exist.");
            }
        } else {
            Util.requireBoundedChildCount(this.getXOMElement(), SubjectCoverage.getName(this.getDDMSVersion()), 1, 1);
        }
        if (!bl3) {
            Util.requireBoundedChildCount(this.getXOMElement(), Security.getName(this.getDDMSVersion()), 1, 1);
        }
        if (!bl && this.getExtensibleElements().size() > 1) {
            throw new InvalidDDMSException("Only 1 extensible element must exist in DDMS 2.0.");
        }
        this.validateOrderAttributes();
        if (bl && !bl3) {
            Util.requireDDMSValue(RESOURCE_ELEMENT_NAME, this.isResourceElement());
            Util.requireDDMSValue(CREATE_DATE_NAME, this.getCreateDate());
            if (!this.getCreateDate().getXMLSchemaType().equals(DatatypeConstants.DATE)) {
                throw new InvalidDDMSException("The createDate must be in the xs:date format (YYYY-MM-DD).");
            }
            Util.requireDDMSValue("ism:DESVersion", this.getIsmDESVersion());
            Util.requireDDMSValue("security attributes", this.getSecurityAttributes());
            this.getSecurityAttributes().requireClassification();
        }
        if (bl2 && !bl3) {
            Util.requireDDMSValue("ntk:DESVersion", this.getNtkDESVersion());
        }
        if (!this.getDDMSVersion().isAtLeast("3.1") && !this.getCompliesWiths().isEmpty()) {
            throw new InvalidDDMSException("The compliesWith attribute must not be used until DDMS 3.1 or later.");
        }
        if (this.getDDMSVersion().isAtLeast("3.1") && !bl3) {
            for (String string : this.getCompliesWiths()) {
                ISMVocabulary.validateEnumeration("CVEnumISMCompliesWith.xml", string);
            }
        }
        if (bl3) {
            if (this.isResourceElement() != null || this.getCreateDate() != null || this.getIsmDESVersion() != null || this.getNtkDESVersion() != null || !this.getSecurityAttributes().isEmpty() || !this.getNoticeAttributes().isEmpty()) {
                throw new InvalidDDMSException("The resource must not have ISM or NTK attributes, starting in DDMS 5.0.");
            }
            if (!this.getExtensibleAttributes().isEmpty() || !this.getExtensibleElements().isEmpty()) {
                throw new InvalidDDMSException("The resource must not have extensible elements or attributes, starting in DDMS 5.0.");
            }
        }
        super.validate();
    }

    private void validateOrderAttributes() throws InvalidDDMSException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (GeospatialCoverage object : this.getGeospatialCoverages()) {
            if (object.getOrder() == null) continue;
            arrayList.add(object.getOrder());
        }
        for (SubjectCoverage subjectCoverage : this.getSubjectCoverages()) {
            for (NonStateActor nonStateActor : subjectCoverage.getNonStateActors()) {
                if (nonStateActor.getOrder() == null) continue;
                arrayList.add(nonStateActor.getOrder());
            }
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = i + 1;
            if (n.equals(arrayList.get(i))) continue;
            throw new InvalidDDMSException("The ddms:order attributes throughout this resource must form a single, ordered list starting from 1.");
        }
    }

    @Override
    protected void validateWarnings() {
        if (!this.getDDMSVersion().isAtLeast("5.0") && !this.getNoticeAttributes().isEmpty()) {
            this.addWarnings(this.getNoticeAttributes().getValidationWarnings(), true);
            if (this.getNoticeAttributes().isExternalReference() != null) {
                this.addDdms40Warning("ism:externalNotice attribute");
            }
        }
        super.validateWarnings();
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        Resource.addJson(jsonObject, RESOURCE_ELEMENT_NAME, this.isResourceElement());
        if (this.getCreateDate() != null) {
            Resource.addJson(jsonObject, CREATE_DATE_NAME, this.getCreateDate().toXMLFormat());
        }
        Resource.addJson(jsonObject, COMPLIES_WITH_NAME, this.getCompliesWiths());
        Resource.addJson(jsonObject, "ism.DESVersion", this.getIsmDESVersion());
        Resource.addJson(jsonObject, "ntk.DESVersion", this.getNtkDESVersion());
        Resource.addJson(jsonObject, this.getSecurityAttributes());
        Resource.addJson(jsonObject, this.getNoticeAttributes());
        Resource.addJson(jsonObject, this.getExtensibleAttributes());
        Resource.addJson(jsonObject, this.getMetacardInfo());
        Resource.addJson(jsonObject, "identifier", this.getIdentifiers());
        Resource.addJson(jsonObject, "title", this.getTitles());
        Resource.addJson(jsonObject, "subtitle", this.getSubtitles());
        Resource.addJson(jsonObject, this.getDescription());
        Resource.addJson(jsonObject, "language", this.getLanguages());
        Resource.addJson(jsonObject, this.getDates());
        Resource.addJson(jsonObject, this.getRights());
        Resource.addJson(jsonObject, "source", this.getSources());
        Resource.addJson(jsonObject, "type", this.getTypes());
        Resource.addJson(jsonObject, "creator", this.getCreators());
        Resource.addJson(jsonObject, "publisher", this.getPublishers());
        Resource.addJson(jsonObject, "contributor", this.getContributors());
        Resource.addJson(jsonObject, "pointOfContact", this.getPointOfContacts());
        Resource.addJson(jsonObject, this.getFormat());
        Resource.addJson(jsonObject, "subjectCoverage", this.getSubjectCoverages());
        Resource.addJson(jsonObject, "virtualCoverage", this.getVirtualCoverages());
        Resource.addJson(jsonObject, "temporalCoverage", this.getTemporalCoverages());
        Resource.addJson(jsonObject, "geospatialCoverage", this.getGeospatialCoverages());
        Resource.addJson(jsonObject, "relatedResource", this.getRelatedResources());
        Resource.addJson(jsonObject, this.getResourceManagement());
        Resource.addJson(jsonObject, this.getSecurity());
        Resource.addJson(jsonObject, "extensible.layer", !this.getExtensibleElements().isEmpty());
        Resource.addJson(jsonObject, "ddms.generator", "DDMSence " + PropertyReader.getProperty("version"));
        Resource.addJson(jsonObject, "ddms.version", this.getDDMSVersion().getVersion());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isResourceElement() != null) {
            stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, string3 + RESOURCE_ELEMENT_NAME, String.valueOf(this.isResourceElement())));
        }
        if (this.getCreateDate() != null) {
            stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, string3 + CREATE_DATE_NAME, this.getCreateDate().toXMLFormat()));
        }
        stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, string3 + COMPLIES_WITH_NAME, Util.getXsList(this.getCompliesWiths())));
        if (this.getIsmDESVersion() != null) {
            stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, string3 + "ism." + DES_VERSION_NAME, String.valueOf(this.getIsmDESVersion())));
        }
        if (this.getNtkDESVersion() != null) {
            stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, string3 + "ntk." + DES_VERSION_NAME, String.valueOf(this.getNtkDESVersion())));
        }
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3));
        stringBuffer.append(this.getNoticeAttributes().getHTMLTextOutput(outputFormat, string3));
        stringBuffer.append(this.getExtensibleAttributes().getHTMLTextOutput(outputFormat, string3));
        if (this.getMetacardInfo() != null) {
            stringBuffer.append(this.getMetacardInfo().getHTMLTextOutput(outputFormat, "", ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getIdentifiers()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getTitles()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getSubtitles()));
        if (this.getDescription() != null) {
            stringBuffer.append(this.getDescription().getHTMLTextOutput(outputFormat, "", ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getLanguages()));
        if (this.getDates() != null) {
            stringBuffer.append(this.getDates().getHTMLTextOutput(outputFormat, "", ""));
        }
        if (this.getRights() != null) {
            stringBuffer.append(this.getRights().getHTMLTextOutput(outputFormat, "", ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getSources()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getTypes()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getCreators()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getPublishers()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getContributors()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getPointOfContacts()));
        if (this.getFormat() != null) {
            stringBuffer.append(this.getFormat().getHTMLTextOutput(outputFormat, "", ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getSubjectCoverages()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getVirtualCoverages()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getTemporalCoverages()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getGeospatialCoverages()));
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getRelatedResources()));
        if (this.getResourceManagement() != null) {
            stringBuffer.append(this.getResourceManagement().getHTMLTextOutput(outputFormat, "", ""));
        }
        if (this.getSecurity() != null) {
            stringBuffer.append(this.getSecurity().getHTMLTextOutput(outputFormat, "", ""));
        }
        stringBuffer.append(this.buildHTMLTextOutput(outputFormat, "", this.getExtensibleElements()));
        stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, "extensible.layer", String.valueOf(!this.getExtensibleElements().isEmpty())));
        stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, "ddms.generator", "DDMSence " + PropertyReader.getProperty("version")));
        stringBuffer.append(Resource.buildHTMLTextOutput(outputFormat, "ddms.version", this.getDDMSVersion().getVersion()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)object;
        return Util.nullEquals(this.isResourceElement(), resource.isResourceElement()) && Util.nullEquals(this.getCreateDate(), resource.getCreateDate()) && Util.listEquals(this.getCompliesWiths(), resource.getCompliesWiths()) && Util.nullEquals(this.getIsmDESVersion(), resource.getIsmDESVersion()) && Util.nullEquals(this.getNtkDESVersion(), resource.getNtkDESVersion()) && this.getNoticeAttributes().equals(resource.getNoticeAttributes()) && this.getExtensibleAttributes().equals(resource.getExtensibleAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.isResourceElement() != null) {
            n = 7 * n + this.isResourceElement().hashCode();
        }
        if (this.getCreateDate() != null) {
            n = 7 * n + this.getCreateDate().hashCode();
        }
        n = 7 * n + this.getCompliesWiths().hashCode();
        if (this.getIsmDESVersion() != null) {
            n = 7 * n + this.getIsmDESVersion().hashCode();
        }
        if (this.getNtkDESVersion() != null) {
            n = 7 * n + this.getNtkDESVersion().hashCode();
        }
        n = 7 * n + this.getNoticeAttributes().hashCode();
        n = 7 * n + this.getExtensibleAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "resource" : "Resource";
    }

    public MetacardInfo getMetacardInfo() {
        return this._metacardInfo;
    }

    public List<Identifier> getIdentifiers() {
        return Collections.unmodifiableList(this._identifiers);
    }

    public List<Title> getTitles() {
        return Collections.unmodifiableList(this._titles);
    }

    public List<Subtitle> getSubtitles() {
        return Collections.unmodifiableList(this._subtitles);
    }

    public Description getDescription() {
        return this._description;
    }

    public List<Language> getLanguages() {
        return Collections.unmodifiableList(this._languages);
    }

    public Dates getDates() {
        return this._dates;
    }

    public Rights getRights() {
        return this._rights;
    }

    public List<Source> getSources() {
        return Collections.unmodifiableList(this._sources);
    }

    public List<Type> getTypes() {
        return Collections.unmodifiableList(this._types);
    }

    public List<Creator> getCreators() {
        return Collections.unmodifiableList(this._creators);
    }

    public List<Publisher> getPublishers() {
        return Collections.unmodifiableList(this._publishers);
    }

    public List<Contributor> getContributors() {
        return Collections.unmodifiableList(this._contributors);
    }

    public List<PointOfContact> getPointOfContacts() {
        return Collections.unmodifiableList(this._pointOfContacts);
    }

    public Format getFormat() {
        return this._format;
    }

    public List<SubjectCoverage> getSubjectCoverages() {
        return this._subjectCoverages;
    }

    public List<VirtualCoverage> getVirtualCoverages() {
        return Collections.unmodifiableList(this._virtualCoverages);
    }

    public List<TemporalCoverage> getTemporalCoverages() {
        return Collections.unmodifiableList(this._temporalCoverages);
    }

    public List<GeospatialCoverage> getGeospatialCoverages() {
        return Collections.unmodifiableList(this.geospatialCoverages);
    }

    public List<RelatedResource> getRelatedResources() {
        return Collections.unmodifiableList(this._relatedResources);
    }

    public ResourceManagement getResourceManagement() {
        return this._resourceManagement;
    }

    public Security getSecurity() {
        return this._security;
    }

    public List<ExtensibleElement> getExtensibleElements() {
        return Collections.unmodifiableList(this._extensibleElements);
    }

    public Boolean isResourceElement() {
        String string = this.getAttributeValue(RESOURCE_ELEMENT_NAME, this.getDDMSVersion().getIsmNamespace());
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public XMLGregorianCalendar getCreateDate() {
        return this._createDate == null ? null : Resource.getFactory().newXMLGregorianCalendar(this._createDate.toXMLFormat());
    }

    public List<String> getCompliesWiths() {
        return Collections.unmodifiableList(this._compliesWiths);
    }

    public Integer getIsmDESVersion() {
        return this._ismDESVersion;
    }

    public Integer getNtkDESVersion() {
        return this._ntkDESVersion;
    }

    public List<IDDMSComponent> getTopLevelComponents() {
        return Collections.unmodifiableList(this._orderedList);
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        return this.getTopLevelComponents();
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public NoticeAttributes getNoticeAttributes() {
        return this._noticeAttributes;
    }

    public ExtensibleAttributes getExtensibleAttributes() {
        return this._extensibleAttributes;
    }

    private static DatatypeFactory getFactory() {
        return Util.getDataTypeFactory();
    }

    static {
        ALL_IC_ATTRIBUTES.add(RESOURCE_ELEMENT_NAME);
        ALL_IC_ATTRIBUTES.add(CREATE_DATE_NAME);
        ALL_IC_ATTRIBUTES.add(DES_VERSION_NAME);
        NON_EXTENSIBLE_NAMES = Collections.unmodifiableSet(ALL_IC_ATTRIBUTES);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -8581492714895157280L;
        private MetacardInfo.Builder _metacardInfo;
        private List<Identifier.Builder> _identifiers;
        private List<Title.Builder> _titles;
        private List<Subtitle.Builder> _subtitles;
        private Description.Builder _description;
        private List<Language.Builder> _languages;
        private Dates.Builder _dates;
        private Rights.Builder _rights;
        private List<Source.Builder> _sources;
        private List<Type.Builder> _types;
        private List<Creator.Builder> _creators;
        private List<Contributor.Builder> _contributors;
        private List<Publisher.Builder> _publishers;
        private List<PointOfContact.Builder> _pointOfContacts;
        private Format.Builder _format;
        private List<SubjectCoverage.Builder> _subjectCoverages;
        private List<VirtualCoverage.Builder> _virtualCoverages;
        private List<TemporalCoverage.Builder> _temporalCoverages;
        private List<GeospatialCoverage.Builder> _geospatialCoverages;
        private List<RelatedResource.Builder> _relatedResources;
        private ResourceManagement.Builder _resourceManagement;
        private Security.Builder _security;
        private List<ExtensibleElement.Builder> _extensibleElements;
        private Boolean _resourceElement;
        private String _createDate;
        private List<String> _compliesWiths;
        private Integer _ismDESVersion;
        private Integer _ntkDESVersion;
        private NoticeAttributes.Builder _noticeAttributes;
        private SecurityAttributes.Builder _securityAttributes;
        private ExtensibleAttributes.Builder _extensibleAttributes;

        public Builder() {
        }

        public Builder(Resource resource) {
            for (IDDMSComponent iDDMSComponent : resource.getTopLevelComponents()) {
                if (iDDMSComponent instanceof MetacardInfo) {
                    this.setMetacardInfo(new MetacardInfo.Builder((MetacardInfo)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Identifier) {
                    this.getIdentifiers().add(new Identifier.Builder((Identifier)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Title) {
                    this.getTitles().add(new Title.Builder((Title)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Subtitle) {
                    this.getSubtitles().add(new Subtitle.Builder((Subtitle)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Description) {
                    this.setDescription(new Description.Builder((Description)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Language) {
                    this.getLanguages().add(new Language.Builder((Language)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Dates) {
                    this.setDates(new Dates.Builder((Dates)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Rights) {
                    this.setRights(new Rights.Builder((Rights)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Source) {
                    this.getSources().add(new Source.Builder((Source)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Type) {
                    this.getTypes().add(new Type.Builder((Type)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Creator) {
                    this.getCreators().add(new Creator.Builder((Creator)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Contributor) {
                    this.getContributors().add(new Contributor.Builder((Contributor)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Publisher) {
                    this.getPublishers().add(new Publisher.Builder((Publisher)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof PointOfContact) {
                    this.getPointOfContacts().add(new PointOfContact.Builder((PointOfContact)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Format) {
                    this.setFormat(new Format.Builder((Format)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof SubjectCoverage) {
                    this.getSubjectCoverages().add(new SubjectCoverage.Builder((SubjectCoverage)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof VirtualCoverage) {
                    this.getVirtualCoverages().add(new VirtualCoverage.Builder((VirtualCoverage)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof TemporalCoverage) {
                    this.getTemporalCoverages().add(new TemporalCoverage.Builder((TemporalCoverage)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof GeospatialCoverage) {
                    this.getGeospatialCoverages().add(new GeospatialCoverage.Builder((GeospatialCoverage)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof RelatedResource) {
                    this.getRelatedResources().add(new RelatedResource.Builder((RelatedResource)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof ResourceManagement) {
                    this.setResourceManagement(new ResourceManagement.Builder((ResourceManagement)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Security) {
                    this.setSecurity(new Security.Builder((Security)iDDMSComponent));
                    continue;
                }
                if (!(iDDMSComponent instanceof ExtensibleElement)) continue;
                this.getExtensibleElements().add(new ExtensibleElement.Builder((ExtensibleElement)iDDMSComponent));
            }
            if (resource.getCreateDate() != null) {
                this.setCreateDate(resource.getCreateDate().toXMLFormat());
            }
            this.setResourceElement(resource.isResourceElement());
            this.setCompliesWiths(resource.getCompliesWiths());
            this.setIsmDESVersion(resource.getIsmDESVersion());
            this.setNtkDESVersion(resource.getNtkDESVersion());
            this.setSecurityAttributes(new SecurityAttributes.Builder(resource.getSecurityAttributes()));
            this.setNoticeAttributes(new NoticeAttributes.Builder(resource.getNoticeAttributes()));
            this.setExtensibleAttributes(new ExtensibleAttributes.Builder(resource.getExtensibleAttributes()));
        }

        @Override
        public Resource commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
            for (IBuilder iBuilder : this.getChildBuilders()) {
                IDDMSComponent iDDMSComponent = iBuilder.commit();
                if (iDDMSComponent == null) continue;
                arrayList.add(iDDMSComponent);
            }
            return new Resource(arrayList, this.getResourceElement(), this.getCreateDate(), this.getCompliesWiths(), this.getIsmDESVersion(), this.getNtkDESVersion(), this.getSecurityAttributes().commit(), this.getNoticeAttributes().commit(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getChildBuilders()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && Util.isEmpty(this.getCreateDate()) && this.getResourceElement() == null && this.getCompliesWiths().isEmpty() && this.getIsmDESVersion() == null && this.getNtkDESVersion() == null && this.getSecurityAttributes().isEmpty() && this.getNoticeAttributes().isEmpty() && this.getExtensibleAttributes().isEmpty();
        }

        private List<IBuilder> getChildBuilders() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getIdentifiers());
            arrayList.addAll(this.getTitles());
            arrayList.addAll(this.getSubtitles());
            arrayList.addAll(this.getLanguages());
            arrayList.addAll(this.getSources());
            arrayList.addAll(this.getTypes());
            arrayList.addAll(this.getCreators());
            arrayList.addAll(this.getContributors());
            arrayList.addAll(this.getPublishers());
            arrayList.addAll(this.getPointOfContacts());
            arrayList.addAll(this.getSubjectCoverages());
            arrayList.addAll(this.getVirtualCoverages());
            arrayList.addAll(this.getTemporalCoverages());
            arrayList.addAll(this.getGeospatialCoverages());
            arrayList.addAll(this.getRelatedResources());
            arrayList.addAll(this.getExtensibleElements());
            arrayList.add(this.getMetacardInfo());
            arrayList.add(this.getDescription());
            arrayList.add(this.getDates());
            arrayList.add(this.getRights());
            arrayList.add(this.getFormat());
            arrayList.add(this.getResourceManagement());
            arrayList.add(this.getSecurity());
            return arrayList;
        }

        public MetacardInfo.Builder getMetacardInfo() {
            if (this._metacardInfo == null) {
                this._metacardInfo = new MetacardInfo.Builder();
            }
            return this._metacardInfo;
        }

        public void setMetacardInfo(MetacardInfo.Builder builder) {
            this._metacardInfo = builder;
        }

        public List<Identifier.Builder> getIdentifiers() {
            if (this._identifiers == null) {
                this._identifiers = new LazyList(Identifier.Builder.class);
            }
            return this._identifiers;
        }

        public List<Title.Builder> getTitles() {
            if (this._titles == null) {
                this._titles = new LazyList(Title.Builder.class);
            }
            return this._titles;
        }

        public List<Subtitle.Builder> getSubtitles() {
            if (this._subtitles == null) {
                this._subtitles = new LazyList(Subtitle.Builder.class);
            }
            return this._subtitles;
        }

        public Description.Builder getDescription() {
            if (this._description == null) {
                this._description = new Description.Builder();
            }
            return this._description;
        }

        public void setDescription(Description.Builder builder) {
            this._description = builder;
        }

        public List<Language.Builder> getLanguages() {
            if (this._languages == null) {
                this._languages = new LazyList(Language.Builder.class);
            }
            return this._languages;
        }

        public Dates.Builder getDates() {
            if (this._dates == null) {
                this._dates = new Dates.Builder();
            }
            return this._dates;
        }

        public void setDates(Dates.Builder builder) {
            this._dates = builder;
        }

        public Rights.Builder getRights() {
            if (this._rights == null) {
                this._rights = new Rights.Builder();
            }
            return this._rights;
        }

        public void setRights(Rights.Builder builder) {
            this._rights = builder;
        }

        public List<Source.Builder> getSources() {
            if (this._sources == null) {
                this._sources = new LazyList(Source.Builder.class);
            }
            return this._sources;
        }

        public List<Type.Builder> getTypes() {
            if (this._types == null) {
                this._types = new LazyList(Type.Builder.class);
            }
            return this._types;
        }

        public List<IBuilder> getProducers() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getCreators());
            arrayList.addAll(this.getContributors());
            arrayList.addAll(this.getPublishers());
            arrayList.addAll(this.getPointOfContacts());
            return arrayList;
        }

        public List<Creator.Builder> getCreators() {
            if (this._creators == null) {
                this._creators = new LazyList(Creator.Builder.class);
            }
            return this._creators;
        }

        public List<Contributor.Builder> getContributors() {
            if (this._contributors == null) {
                this._contributors = new LazyList(Contributor.Builder.class);
            }
            return this._contributors;
        }

        public List<Publisher.Builder> getPublishers() {
            if (this._publishers == null) {
                this._publishers = new LazyList(Publisher.Builder.class);
            }
            return this._publishers;
        }

        public List<PointOfContact.Builder> getPointOfContacts() {
            if (this._pointOfContacts == null) {
                this._pointOfContacts = new LazyList(PointOfContact.Builder.class);
            }
            return this._pointOfContacts;
        }

        public Format.Builder getFormat() {
            if (this._format == null) {
                this._format = new Format.Builder();
            }
            return this._format;
        }

        public void setFormat(Format.Builder builder) {
            this._format = builder;
        }

        public List<SubjectCoverage.Builder> getSubjectCoverages() {
            if (this._subjectCoverages == null) {
                this._subjectCoverages = new LazyList(SubjectCoverage.Builder.class);
            }
            return this._subjectCoverages;
        }

        public List<VirtualCoverage.Builder> getVirtualCoverages() {
            if (this._virtualCoverages == null) {
                this._virtualCoverages = new LazyList(VirtualCoverage.Builder.class);
            }
            return this._virtualCoverages;
        }

        public List<TemporalCoverage.Builder> getTemporalCoverages() {
            if (this._temporalCoverages == null) {
                this._temporalCoverages = new LazyList(TemporalCoverage.Builder.class);
            }
            return this._temporalCoverages;
        }

        public List<GeospatialCoverage.Builder> getGeospatialCoverages() {
            if (this._geospatialCoverages == null) {
                this._geospatialCoverages = new LazyList(GeospatialCoverage.Builder.class);
            }
            return this._geospatialCoverages;
        }

        public List<RelatedResource.Builder> getRelatedResources() {
            if (this._relatedResources == null) {
                this._relatedResources = new LazyList(RelatedResource.Builder.class);
            }
            return this._relatedResources;
        }

        public ResourceManagement.Builder getResourceManagement() {
            if (this._resourceManagement == null) {
                this._resourceManagement = new ResourceManagement.Builder();
            }
            return this._resourceManagement;
        }

        public void setResourceManagement(ResourceManagement.Builder builder) {
            this._resourceManagement = builder;
        }

        public Security.Builder getSecurity() {
            if (this._security == null) {
                this._security = new Security.Builder();
            }
            return this._security;
        }

        public void setSecurity(Security.Builder builder) {
            this._security = builder;
        }

        public List<ExtensibleElement.Builder> getExtensibleElements() {
            if (this._extensibleElements == null) {
                this._extensibleElements = new LazyList(ExtensibleElement.Builder.class);
            }
            return this._extensibleElements;
        }

        public String getCreateDate() {
            return this._createDate;
        }

        public void setCreateDate(String string) {
            this._createDate = string;
        }

        public Boolean getResourceElement() {
            return this._resourceElement;
        }

        public void setResourceElement(Boolean bl) {
            this._resourceElement = bl;
        }

        public List<String> getCompliesWiths() {
            if (this._compliesWiths == null) {
                this._compliesWiths = new LazyList(String.class);
            }
            return this._compliesWiths;
        }

        public void setCompliesWiths(List<String> list) {
            this._compliesWiths = new LazyList(list, String.class);
        }

        public Integer getNtkDESVersion() {
            return this._ntkDESVersion;
        }

        public void setNtkDESVersion(Integer n) {
            this._ntkDESVersion = n;
        }

        public Integer getIsmDESVersion() {
            return this._ismDESVersion;
        }

        public void setIsmDESVersion(Integer n) {
            this._ismDESVersion = n;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public NoticeAttributes.Builder getNoticeAttributes() {
            if (this._noticeAttributes == null) {
                this._noticeAttributes = new NoticeAttributes.Builder();
            }
            return this._noticeAttributes;
        }

        public void setNoticeAttributes(NoticeAttributes.Builder builder) {
            this._noticeAttributes = builder;
        }

        public ExtensibleAttributes.Builder getExtensibleAttributes() {
            if (this._extensibleAttributes == null) {
                this._extensibleAttributes = new ExtensibleAttributes.Builder();
            }
            return this._extensibleAttributes;
        }

        public void setExtensibleAttributes(ExtensibleAttributes.Builder builder) {
            this._extensibleAttributes = builder;
        }
    }
}

