/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.IRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.OutputFormat;
import buri.ddmsence.ddms.resource.Organization;
import buri.ddmsence.ddms.resource.Person;
import buri.ddmsence.ddms.resource.Service;
import buri.ddmsence.ddms.resource.Unknown;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public abstract class AbstractProducerRole
extends AbstractBaseComponent {
    private IRoleEntity _entity = null;
    private List<String> _pocTypes = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String POC_TYPE_NAME = "pocType";

    protected AbstractProducerRole(Element element) throws InvalidDDMSException {
        try {
            Object object;
            this.setXOMElement(element, false);
            if (element.getChildElements().size() > 0) {
                object = element.getChildElements().get(0);
                String string = object.getLocalName();
                if (Organization.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Organization((Element)object);
                }
                if (Person.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Person((Element)object);
                }
                if (Service.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Service((Element)object);
                }
                if (Unknown.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Unknown((Element)object);
                }
            }
            object = element.getAttributeValue(POC_TYPE_NAME, this.getDDMSVersion().getIsmNamespace());
            this._pocTypes = Util.getXsListAsList((String)object);
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    protected AbstractProducerRole(String string, IRoleEntity iRoleEntity, List<String> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            Util.requireDDMSValue("producer type", string);
            Util.requireDDMSValue("entity", iRoleEntity);
            Element element = Util.buildDDMSElement(string, null);
            element.appendChild((Node)iRoleEntity.getXOMElementCopy());
            this._entity = iRoleEntity;
            if (!list.isEmpty()) {
                Util.addAttribute(element, PropertyReader.getPrefix("ism"), POC_TYPE_NAME, DDMSVersion.getCurrentVersion().getIsmNamespace(), Util.getXsList(list));
            }
            this._pocTypes = list;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSValue("entity", this.getEntity());
        Util.requireBoundedChildCount(this.getXOMElement(), Organization.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Person.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Service.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Unknown.getName(this.getDDMSVersion()), 0, 1);
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !this.getPocTypes().isEmpty()) {
            throw new InvalidDDMSException("This component must not have a pocType until DDMS 4.0.1 or later.");
        }
        for (String string : this.getPocTypes()) {
            ISMVocabulary.validateEnumeration("CVEnumISMPocType.xml", string);
        }
        super.validate();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AbstractProducerRole)) {
            return false;
        }
        AbstractProducerRole abstractProducerRole = (AbstractProducerRole)object;
        return Util.listEquals(this.getPocTypes(), abstractProducerRole.getPocTypes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getPocTypes().hashCode();
        return n;
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        AbstractProducerRole.addJson(jsonObject, (AbstractBaseComponent)((Object)this.getEntity()));
        AbstractProducerRole.addJson(jsonObject, POC_TYPE_NAME, this.getPocTypes());
        AbstractProducerRole.addJson(jsonObject, this.getSecurityAttributes());
        return jsonObject;
    }

    @Override
    public String getHTMLTextOutput(OutputFormat outputFormat, String string, String string2) {
        Util.requireHTMLText(outputFormat);
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((AbstractBaseComponent)((Object)this.getEntity())).getHTMLTextOutput(outputFormat, string3, ""));
        stringBuffer.append(AbstractProducerRole.buildHTMLTextOutput(outputFormat, string3 + POC_TYPE_NAME, Util.getXsList(this.getPocTypes())));
        stringBuffer.append(this.getSecurityAttributes().getHTMLTextOutput(outputFormat, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getEntity());
        return arrayList;
    }

    public IRoleEntity getEntity() {
        return this._entity;
    }

    public List<String> getPocTypes() {
        return this._pocTypes;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -1694935853087559491L;
        private String _entityType;
        private Organization.Builder _organization;
        private Person.Builder _person;
        private Service.Builder _service;
        private Unknown.Builder _unknown;
        private List<String> _pocTypes;
        private SecurityAttributes.Builder _securityAttributes;

        protected Builder() {
        }

        protected Builder(AbstractProducerRole abstractProducerRole) {
            this.setEntityType(abstractProducerRole.getEntity().getName());
            DDMSVersion dDMSVersion = abstractProducerRole.getDDMSVersion();
            if (Organization.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setOrganization(new Organization.Builder((Organization)abstractProducerRole.getEntity()));
            }
            if (Person.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setPerson(new Person.Builder((Person)abstractProducerRole.getEntity()));
            }
            if (Service.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setService(new Service.Builder((Service)abstractProducerRole.getEntity()));
            }
            if (Unknown.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setUnknown(new Unknown.Builder((Unknown)abstractProducerRole.getEntity()));
            }
            this.setPocTypes(abstractProducerRole.getPocTypes());
            this.setSecurityAttributes(new SecurityAttributes.Builder(abstractProducerRole.getSecurityAttributes()));
        }

        protected IRoleEntity commitSelectedEntity() throws InvalidDDMSException {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            if (Organization.getName(dDMSVersion).equalsIgnoreCase(this.getEntityType())) {
                return this.getOrganization().commit();
            }
            if (Person.getName(dDMSVersion).equalsIgnoreCase(this.getEntityType())) {
                return this.getPerson().commit();
            }
            if (Service.getName(dDMSVersion).equalsIgnoreCase(this.getEntityType())) {
                return this.getService().commit();
            }
            return this.getUnknown().commit();
        }

        @Override
        public boolean isEmpty() {
            return this.getOrganization().isEmpty() && this.getPerson().isEmpty() && this.getService().isEmpty() && this.getUnknown().isEmpty() && this.getPocTypes().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public String getEntityType() {
            return this._entityType;
        }

        public void setEntityType(String string) {
            this._entityType = string;
        }

        public Organization.Builder getOrganization() {
            if (this._organization == null) {
                this._organization = new Organization.Builder();
            }
            return this._organization;
        }

        public void setOrganization(Organization.Builder builder) {
            this._organization = builder;
        }

        public Person.Builder getPerson() {
            if (this._person == null) {
                this._person = new Person.Builder();
            }
            return this._person;
        }

        public void setPerson(Person.Builder builder) {
            this._person = builder;
        }

        public Service.Builder getService() {
            if (this._service == null) {
                this._service = new Service.Builder();
            }
            return this._service;
        }

        public void setService(Service.Builder builder) {
            this._service = builder;
        }

        public Unknown.Builder getUnknown() {
            if (this._unknown == null) {
                this._unknown = new Unknown.Builder();
            }
            return this._unknown;
        }

        public void setUnknown(Unknown.Builder builder) {
            this._unknown = builder;
        }

        public List<String> getPocTypes() {
            if (this._pocTypes == null) {
                this._pocTypes = new LazyList(String.class);
            }
            return this._pocTypes;
        }

        public void setPocTypes(List<String> list) {
            this._pocTypes = list;
        }
    }
}

