/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary.gml;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.gml.Position;
import buri.ddmsence.ddms.summary.gml.SRSAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Polygon
extends AbstractBaseComponent {
    private List<Position> _positions;
    private SRSAttributes _srsAttributes;
    private static final String EXTERIOR_NAME = "exterior";
    private static final String LINEAR_RING_NAME = "LinearRing";
    private static final String ID_NAME = "id";

    public Polygon(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            this.setXOMElement(element, false);
            this._positions = new ArrayList<Position>();
            Element element3 = element.getFirstChildElement(EXTERIOR_NAME, this.getNamespace());
            if (element3 != null && (element2 = element3.getFirstChildElement(LINEAR_RING_NAME, this.getNamespace())) != null) {
                Elements elements = element2.getChildElements(Position.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements.size(); ++i) {
                    this._positions.add(new Position(elements.get(i)));
                }
            }
            this._srsAttributes = new SRSAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Polygon(List<Position> list, SRSAttributes sRSAttributes, String string) throws InvalidDDMSException {
        try {
            Position position2;
            if (list == null) {
                list = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            String string2 = PropertyReader.getPrefix("gml");
            String string3 = dDMSVersion.getGmlNamespace();
            Element element = Util.buildElement(string2, LINEAR_RING_NAME, string3, null);
            for (Position position2 : list) {
                element.appendChild((Node)position2.getXOMElementCopy());
            }
            Element element2 = Util.buildElement(string2, EXTERIOR_NAME, string3, null);
            element2.appendChild((Node)element);
            position2 = Util.buildElement(string2, Polygon.getName(dDMSVersion), string3, null);
            position2.appendChild((Node)element2);
            Util.addAttribute((Element)position2, string2, ID_NAME, string3, string);
            this._positions = list;
            this._srsAttributes = SRSAttributes.getNonNullInstance(sRSAttributes);
            this._srsAttributes.addTo((Element)position2);
            this.setXOMElement((Element)position2, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Polygon.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("srsName", this.getSRSAttributes().getSrsName());
        Util.requireDDMSValue(ID_NAME, this.getId());
        Util.requireValidNCName(this.getId());
        Element element = this.getXOMElement().getFirstChildElement(EXTERIOR_NAME, this.getNamespace());
        Util.requireDDMSValue("exterior element", element);
        if (element != null) {
            Util.requireDDMSValue("LinearRing element", element.getFirstChildElement(LINEAR_RING_NAME, this.getNamespace()));
        }
        List<Position> list = this.getPositions();
        for (Position position : list) {
            String string;
            if (position.getSRSAttributes() == null || Util.isEmpty(string = position.getSRSAttributes().getSrsName()) || string.equals(this.getSRSAttributes().getSrsName())) continue;
            throw new InvalidDDMSException("The srsName of each position must match the srsName of the Polygon.");
        }
        if (list.size() < 4) {
            throw new InvalidDDMSException("At least 4 positions must exist for a valid Polygon.");
        }
        if (!list.isEmpty() && !list.get(0).equals(list.get(list.size() - 1))) {
            throw new InvalidDDMSException("The first and last position in the Polygon must be the same.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        this.addWarnings(this.getSRSAttributes().getValidationWarnings(), true);
        super.validateWarnings();
    }

    @Override
    protected String getLocatorSuffix() {
        String string = PropertyReader.getPrefix("gml");
        return "/" + string + ":" + EXTERIOR_NAME + "/" + string + ":" + LINEAR_RING_NAME;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Polygon.buildOutput(bl, string3 + ID_NAME, this.getId()));
        stringBuffer.append(this.getSRSAttributes().getOutput(bl, string3));
        stringBuffer.append(this.buildOutput(bl, string3, this.getPositions()));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getPositions());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Polygon)) {
            return false;
        }
        Polygon polygon = (Polygon)object;
        return this.getSRSAttributes().equals(polygon.getSRSAttributes()) && this.getId().equals(polygon.getId());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSRSAttributes().hashCode();
        n = 7 * n + this.getId().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "Polygon";
    }

    public SRSAttributes getSRSAttributes() {
        return this._srsAttributes;
    }

    public String getId() {
        return this.getAttributeValue(ID_NAME, this.getNamespace());
    }

    public List<Position> getPositions() {
        return Collections.unmodifiableList(this._positions);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -4324741146353401634L;
        private SRSAttributes.Builder _srsAttributes;
        private List<Position.Builder> _positions;
        private String _id;

        public Builder() {
        }

        public Builder(Polygon polygon) {
            this.setSrsAttributes(new SRSAttributes.Builder(polygon.getSRSAttributes()));
            for (Position position : polygon.getPositions()) {
                this.getPositions().add(new Position.Builder(position));
            }
            this.setId(polygon.getId());
        }

        @Override
        public Polygon commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Position> arrayList = new ArrayList<Position>();
            for (Position.Builder builder : this.getPositions()) {
                Position position = builder.commit();
                if (position == null) continue;
                arrayList.add(position);
            }
            return new Polygon(arrayList, this.getSrsAttributes().commit(), this.getId());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getPositions()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return Util.isEmpty(this.getId()) && !bl && this.getSrsAttributes().isEmpty();
        }

        public SRSAttributes.Builder getSrsAttributes() {
            if (this._srsAttributes == null) {
                this._srsAttributes = new SRSAttributes.Builder();
            }
            return this._srsAttributes;
        }

        public void setSrsAttributes(SRSAttributes.Builder builder) {
            this._srsAttributes = builder;
        }

        public List<Position.Builder> getPositions() {
            if (this._positions == null) {
                this._positions = new LazyList(Position.Builder.class);
            }
            return this._positions;
        }

        public String getId() {
            return this._id;
        }

        public void setId(String string) {
            this._id = string;
        }
    }
}

