/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary.gml;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.gml.Position;
import buri.ddmsence.ddms.summary.gml.SRSAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Point
extends AbstractBaseComponent {
    private Position _position = null;
    private SRSAttributes _srsAttributes = null;
    private static final String ID_NAME = "id";

    public Point(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            Element element2 = element.getFirstChildElement(Position.getName(this.getDDMSVersion()), this.getNamespace());
            if (element2 != null) {
                this._position = new Position(element2);
            }
            this._srsAttributes = new SRSAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Point(Position position, SRSAttributes sRSAttributes, String string) throws InvalidDDMSException {
        try {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildElement(PropertyReader.getPrefix("gml"), Point.getName(dDMSVersion), dDMSVersion.getGmlNamespace(), null);
            if (position != null) {
                element.appendChild((Node)position.getXOMElementCopy());
            }
            Util.addAttribute(element, PropertyReader.getPrefix("gml"), ID_NAME, DDMSVersion.getCurrentVersion().getGmlNamespace(), string);
            this._position = position;
            this._srsAttributes = SRSAttributes.getNonNullInstance(sRSAttributes);
            this._srsAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Point.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("srsAttributes", this.getSRSAttributes());
        Util.requireDDMSValue("srsName", this.getSRSAttributes().getSrsName());
        Util.requireDDMSValue(ID_NAME, this.getId());
        Util.requireValidNCName(this.getId());
        Util.requireDDMSValue("position", this.getPosition());
        String string = this.getPosition().getSRSAttributes().getSrsName();
        if (!Util.isEmpty(string) && !string.equals(this.getSRSAttributes().getSrsName())) {
            throw new InvalidDDMSException("The srsName of the position must match the srsName of the Point.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        this.addWarnings(this.getSRSAttributes().getValidationWarnings(), true);
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Point.buildOutput(bl, string3 + ID_NAME, this.getId()));
        stringBuffer.append(this.getSRSAttributes().getOutput(bl, string3));
        stringBuffer.append(this.getPosition().getOutput(bl, string3, ""));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getPosition());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return this.getSRSAttributes().equals(point.getSRSAttributes()) && this.getId().equals(point.getId());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSRSAttributes().hashCode();
        n = 7 * n + this.getId().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "Point";
    }

    public SRSAttributes getSRSAttributes() {
        return this._srsAttributes;
    }

    public String getId() {
        return this.getAttributeValue(ID_NAME, this.getNamespace());
    }

    public Position getPosition() {
        return this._position;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4003805386998809149L;
        private SRSAttributes.Builder _srsAttributes;
        private Position.Builder _position;
        private String _id;

        public Builder() {
        }

        public Builder(Point point) {
            this.setSrsAttributes(new SRSAttributes.Builder(point.getSRSAttributes()));
            this.setPosition(new Position.Builder(point.getPosition()));
            this.setId(point.getId());
        }

        @Override
        public Point commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Point(this.getPosition().commit(), this.getSrsAttributes().commit(), this.getId());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getId()) && this.getPosition().isEmpty() && this.getSrsAttributes().isEmpty();
        }

        public SRSAttributes.Builder getSrsAttributes() {
            if (this._srsAttributes == null) {
                this._srsAttributes = new SRSAttributes.Builder();
            }
            return this._srsAttributes;
        }

        public void setSrsAttributes(SRSAttributes.Builder builder) {
            this._srsAttributes = builder;
        }

        public Position.Builder getPosition() {
            if (this._position == null) {
                this._position = new Position.Builder();
            }
            return this._position;
        }

        public void setPosition(Position.Builder builder) {
            this._position = builder;
        }

        public String getId() {
            return this._id;
        }

        public void setId(String string) {
            this._id = string;
        }
    }
}

